/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.client.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.client.api.JavaEvaluator;
import com.android.tools.klint.detector.api.ClassContext;
import com.android.tools.klint.detector.api.DefaultPosition;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Position;
import com.google.common.annotations.Beta;
import com.google.common.base.Splitter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import java.io.File;
import java.util.Collections;
import java.util.List;
import lombok.ast.Catch;
import lombok.ast.For;
import lombok.ast.Identifier;
import lombok.ast.If;
import lombok.ast.Node;
import lombok.ast.Return;
import lombok.ast.StrictListAccessor;
import lombok.ast.Switch;
import lombok.ast.Throw;
import lombok.ast.TypeReference;
import lombok.ast.TypeReferencePart;
import lombok.ast.While;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UastContext;

@Beta
public abstract class JavaParser {
    public static final String TYPE_OBJECT = "java.lang.Object";
    public static final String TYPE_STRING = "java.lang.String";
    public static final String TYPE_INT = "int";
    public static final String TYPE_LONG = "long";
    public static final String TYPE_CHAR = "char";
    public static final String TYPE_FLOAT = "float";
    public static final String TYPE_DOUBLE = "double";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_SHORT = "short";
    public static final String TYPE_BYTE = "byte";
    public static final String TYPE_NULL = "null";
    public static final String TYPE_INTEGER_WRAPPER = "java.lang.Integer";
    public static final String TYPE_BOOLEAN_WRAPPER = "java.lang.Boolean";
    public static final String TYPE_BYTE_WRAPPER = "java.lang.Byte";
    public static final String TYPE_SHORT_WRAPPER = "java.lang.Short";
    public static final String TYPE_LONG_WRAPPER = "java.lang.Long";
    public static final String TYPE_DOUBLE_WRAPPER = "java.lang.Double";
    public static final String TYPE_FLOAT_WRAPPER = "java.lang.Float";
    public static final String TYPE_CHARACTER_WRAPPER = "java.lang.Character";

    public abstract void prepareJavaParse(@NonNull List<JavaContext> var1);

    @Deprecated
    @Nullable
    public Node parseJava(@NonNull JavaContext context) {
        return null;
    }

    @Nullable
    public abstract PsiJavaFile parseJavaToPsi(@NonNull JavaContext var1);

    @NonNull
    public abstract JavaEvaluator getEvaluator();

    public abstract Project getIdeaProject();

    public abstract UastContext getUastContext();

    @Deprecated
    @NonNull
    public Location getLocation(@NonNull JavaContext context, @NonNull Node node) {
        return Location.NONE;
    }

    @NonNull
    public Location getLocation(@NonNull JavaContext context, @NonNull PsiElement element) {
        TextRange range = element.getTextRange();
        UFile uFile = (UFile)this.getUastContext().convertElementWithParent((PsiElement)element.getContainingFile(), UFile.class);
        if (uFile == null) {
            return Location.NONE;
        }
        PsiFile containingFile = uFile.getPsi();
        File file = context.file;
        if (containingFile != context.getUFile().getPsi()) {
            if (context.getDriver().getScope().size() == 1) {
                return Location.NONE;
            }
            VirtualFile virtualFile = containingFile.getVirtualFile();
            if (virtualFile == null) {
                return Location.NONE;
            }
            file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
        }
        return Location.create(file, context.getContents(), range.getStartOffset(), range.getEndOffset());
    }

    @Deprecated
    @NonNull
    public abstract Location getRangeLocation(@NonNull JavaContext var1, @NonNull Node var2, int var3, @NonNull Node var4, int var5);

    @NonNull
    public Location getRangeLocation(@NonNull JavaContext context, @NonNull PsiElement from, int fromDelta, @NonNull PsiElement to, int toDelta) {
        String contents = context.getContents();
        int start = Math.max(0, from.getTextRange().getStartOffset() + fromDelta);
        int end = Math.min(contents == null ? Integer.MAX_VALUE : contents.length(), to.getTextRange().getEndOffset() + toDelta);
        return Location.create(context.file, contents, start, end);
    }

    @NonNull
    public Location getRangeLocation(@NonNull JavaContext context, @NonNull PsiElement from, int fromDelta, int toDelta) {
        return this.getRangeLocation(context, from, fromDelta, from, -(from.getTextRange().getLength() - toDelta));
    }

    @Deprecated
    @NonNull
    public Location getNameLocation(@NonNull JavaContext context, @NonNull Node node) {
        Location location;
        Position start;
        Node nameNode = JavaContext.findNameNode(node);
        if (nameNode != null) {
            node = nameNode;
        } else if ((node instanceof Switch || node instanceof For || node instanceof If || node instanceof While || node instanceof Throw || node instanceof Return) && (start = (location = this.getLocation(context, node)).getStart()) != null) {
            int length = node.getClass().getSimpleName().length();
            return Location.create(location.getFile(), start, new DefaultPosition(start.getLine(), start.getColumn() + length, start.getOffset() + length));
        }
        return this.getLocation(context, node);
    }

    @NonNull
    public Location getNameLocation(@NonNull JavaContext context, @NonNull PsiElement element) {
        PsiElement nameNode = JavaContext.findNameElement(element);
        if (nameNode != null) {
            element = nameNode;
        }
        return this.getLocation(context, element);
    }

    @Deprecated
    @NonNull
    public abstract Location.Handle createLocationHandle(@NonNull JavaContext var1, @NonNull Node var2);

    @Deprecated
    public void dispose(@NonNull JavaContext context, @NonNull Node compilationUnit) {
    }

    public void dispose(@NonNull JavaContext context, @NonNull PsiFile compilationUnit) {
    }

    public void dispose(@NonNull JavaContext context, @NonNull UFile compilationUnit) {
    }

    public void dispose() {
    }

    @Deprecated
    @Nullable
    public ResolvedNode resolve(@NonNull JavaContext context, @NonNull Node node) {
        return null;
    }

    @Nullable
    public ResolvedClass findClass(@NonNull JavaContext context, @NonNull String fullyQualifiedName) {
        return null;
    }

    @Deprecated
    public List<TypeDescriptor> getCatchTypes(@NonNull JavaContext context, @NonNull Catch catchBlock) {
        TypeReference typeReference2 = catchBlock.astExceptionDeclaration().astTypeReference();
        return Collections.singletonList(new DefaultTypeDescriptor(typeReference2.getTypeName()));
    }

    @Deprecated
    @Nullable
    public TypeDescriptor getType(@NonNull JavaContext context, @NonNull Node node) {
        return null;
    }

    public abstract void runReadAction(@NonNull Runnable var1);

    @Deprecated
    private static boolean haveSameCompilationUnit(@Nullable ResolvedClass cls1, @Nullable ResolvedClass cls2) {
        if (cls1 == null || cls2 == null) {
            return false;
        }
        while (cls1.getContainingClass() != null) {
            cls1 = cls1.getContainingClass();
        }
        while (cls2.getContainingClass() != null) {
            cls2 = cls2.getContainingClass();
        }
        return cls1.equals(cls2);
    }

    @Deprecated
    public static abstract class ResolvedVariable
    extends ResolvedNode {
        @Override
        @NonNull
        public abstract String getName();

        public abstract boolean matches(@NonNull String var1);

        @NonNull
        public abstract TypeDescriptor getType();
    }

    @Deprecated
    public static abstract class ResolvedPackage
    extends ResolvedNode {
        @Nullable
        public abstract ResolvedPackage getParentPackage();

        @Override
        @NonNull
        public Iterable<ResolvedAnnotation> getAnnotations() {
            return Collections.emptyList();
        }
    }

    @Deprecated
    public static abstract class ResolvedAnnotation
    extends ResolvedNode {
        @Override
        @NonNull
        public abstract String getName();

        public abstract boolean matches(@NonNull String var1);

        @NonNull
        public abstract TypeDescriptor getType();

        @Nullable
        public abstract ResolvedClass getClassType();

        @NonNull
        public abstract List<Value> getValues();

        @Nullable
        public Object getValue(@NonNull String name) {
            for (Value value2 : this.getValues()) {
                if (!name.equals(value2.name)) continue;
                return value2.value;
            }
            return null;
        }

        @Nullable
        public Object getValue() {
            return this.getValue("value");
        }

        @Override
        @NonNull
        public Iterable<ResolvedAnnotation> getAnnotations() {
            return Collections.emptyList();
        }

        public static class Value {
            @NonNull
            public final String name;
            @Nullable
            public final Object value;

            public Value(@NonNull String name, @Nullable Object value2) {
                this.name = name;
                this.value = value2;
            }
        }
    }

    @Deprecated
    public static abstract class ResolvedField
    extends ResolvedNode {
        @Override
        @NonNull
        public abstract String getName();

        public abstract boolean matches(@NonNull String var1);

        @NonNull
        public abstract TypeDescriptor getType();

        @Nullable
        public abstract ResolvedClass getContainingClass();

        @Nullable
        public abstract Object getValue();

        @Nullable
        public String getContainingClassName() {
            ResolvedClass containingClass = this.getContainingClass();
            return containingClass != null ? containingClass.getName() : null;
        }

        @Override
        public boolean isInPackage(@NonNull String pkg, boolean includeSubPackages) {
            ResolvedClass containingClass = this.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            String packageName = containingClass.getPackageName();
            if (pkg.equals(packageName)) {
                return true;
            }
            return includeSubPackages && packageName.length() > pkg.length() && packageName.charAt(pkg.length()) == '.' && packageName.startsWith(pkg);
        }
    }

    @Deprecated
    public static abstract class ResolvedMethod
    extends ResolvedNode {
        @Override
        @NonNull
        public abstract String getName();

        public abstract boolean matches(@NonNull String var1);

        @NonNull
        public abstract ResolvedClass getContainingClass();

        public abstract int getArgumentCount();

        @NonNull
        public abstract TypeDescriptor getArgumentType(int var1);

        public boolean argumentMatchesType(int index, @NonNull String signature) {
            return this.getArgumentType(index).matchesSignature(signature);
        }

        @Nullable
        public abstract TypeDescriptor getReturnType();

        public boolean isConstructor() {
            return this.getReturnType() == null;
        }

        @NonNull
        public abstract Iterable<ResolvedAnnotation> getParameterAnnotations(int var1);

        @Nullable
        public ResolvedAnnotation getParameterAnnotation(@NonNull String type2, int parameterIndex) {
            for (ResolvedAnnotation annotation : this.getParameterAnnotations(parameterIndex)) {
                if (!annotation.getType().matchesSignature(type2)) continue;
                return annotation;
            }
            return null;
        }

        @Nullable
        public ResolvedMethod getSuperMethod() {
            if ((this.getModifiers() & 2) != 0) {
                return null;
            }
            ResolvedClass cls = this.getContainingClass().getSuperClass();
            if (cls != null) {
                String methodName2 = this.getName();
                int argCount = this.getArgumentCount();
                for (ResolvedMethod method : cls.getMethods(methodName2, true)) {
                    if (argCount != method.getArgumentCount()) continue;
                    boolean sameTypes = true;
                    for (int arg = 0; arg < argCount; ++arg) {
                        if (method.getArgumentType(arg).equals(this.getArgumentType(arg))) continue;
                        sameTypes = false;
                        break;
                    }
                    if (!sameTypes) continue;
                    if ((method.getModifiers() & 2) != 0) {
                        if (JavaParser.haveSameCompilationUnit(this.getContainingClass(), method.getContainingClass())) {
                            return method;
                        }
                        return null;
                    }
                    return method;
                }
            }
            return null;
        }

        @Override
        public boolean isInPackage(@NonNull String pkg, boolean includeSubPackages) {
            String packageName = this.getContainingClass().getPackageName();
            if (pkg.equals(packageName)) {
                return true;
            }
            return includeSubPackages && packageName.length() > pkg.length() && packageName.charAt(pkg.length()) == '.' && packageName.startsWith(pkg);
        }
    }

    @Deprecated
    public static abstract class ResolvedClass
    extends ResolvedNode {
        @Override
        @NonNull
        public abstract String getName();

        @NonNull
        public abstract String getSimpleName();

        @NonNull
        public String getPackageName() {
            String name = this.getName();
            String simpleName = this.getSimpleName();
            if (name.length() > simpleName.length() + 1) {
                return name.substring(0, name.length() - simpleName.length() - 1);
            }
            return name;
        }

        public abstract boolean matches(@NonNull String var1);

        @Nullable
        public abstract ResolvedClass getSuperClass();

        @NonNull
        public abstract Iterable<ResolvedClass> getInterfaces();

        @Nullable
        public abstract ResolvedClass getContainingClass();

        public abstract boolean isInterface();

        public abstract boolean isEnum();

        public TypeDescriptor getType() {
            return new DefaultTypeDescriptor(this.getName());
        }

        public abstract boolean isSubclassOf(@NonNull String var1, boolean var2);

        public abstract boolean isImplementing(@NonNull String var1, boolean var2);

        public abstract boolean isInheritingFrom(@NonNull String var1, boolean var2);

        @NonNull
        public abstract Iterable<ResolvedMethod> getConstructors();

        @NonNull
        public abstract Iterable<ResolvedMethod> getMethods(boolean var1);

        @NonNull
        public abstract Iterable<ResolvedMethod> getMethods(@NonNull String var1, boolean var2);

        @NonNull
        public abstract Iterable<ResolvedField> getFields(boolean var1);

        @Nullable
        public abstract ResolvedField getField(@NonNull String var1, boolean var2);

        @Nullable
        public abstract ResolvedPackage getPackage();

        @Override
        public boolean isInPackage(@NonNull String pkg, boolean includeSubPackages) {
            String packageName = this.getPackageName();
            if (pkg.equals(packageName)) {
                return true;
            }
            return includeSubPackages && packageName.length() > pkg.length() && packageName.charAt(pkg.length()) == '.' && packageName.startsWith(pkg);
        }
    }

    @Deprecated
    public static abstract class ResolvedNode {
        @NonNull
        public abstract String getName();

        public abstract String getSignature();

        public abstract int getModifiers();

        public String toString() {
            return this.getSignature();
        }

        @NonNull
        public abstract Iterable<ResolvedAnnotation> getAnnotations();

        @Nullable
        public ResolvedAnnotation getAnnotation(@NonNull String type2) {
            for (ResolvedAnnotation annotation : this.getAnnotations()) {
                if (!annotation.getType().matchesSignature(type2)) continue;
                return annotation;
            }
            return null;
        }

        public boolean isInPackage(@NonNull String pkg, boolean includeSubPackages) {
            return this.getSignature().startsWith(pkg);
        }

        @Nullable
        public Node findAstNode() {
            return null;
        }
    }

    @Deprecated
    public static class DefaultTypeDescriptor
    extends TypeDescriptor {
        private String mName;

        public DefaultTypeDescriptor(String name) {
            this.mName = name;
        }

        @Override
        @NonNull
        public String getName() {
            return this.mName;
        }

        @Override
        @NonNull
        public String getSignature() {
            return this.getName();
        }

        @Override
        public boolean matchesName(@NonNull String name) {
            return this.mName.equals(name);
        }

        @Override
        public boolean isArray() {
            return this.mName.endsWith("[]");
        }

        @Override
        public boolean isPrimitive() {
            return this.mName.indexOf(46) != -1;
        }

        @Override
        public boolean matchesSignature(@NonNull String signature) {
            return this.matchesName(signature);
        }

        @Override
        public String toString() {
            return this.getSignature();
        }

        @Override
        @Nullable
        public ResolvedClass getTypeClass() {
            return null;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultTypeDescriptor that = (DefaultTypeDescriptor)o;
            return !(this.mName == null ? that.mName != null : !this.mName.equals(that.mName));
        }

        public int hashCode() {
            return this.mName != null ? this.mName.hashCode() : 0;
        }
    }

    @Deprecated
    public static abstract class TypeDescriptor {
        @NonNull
        public abstract String getName();

        @NonNull
        public String getSimpleName() {
            String name = this.getName();
            int index = name.lastIndexOf(46);
            if (index != -1) {
                return name.substring(index + 1);
            }
            return name;
        }

        @NonNull
        public abstract String getSignature();

        @NonNull
        public String getInternalName() {
            return ClassContext.getInternalName(this.getName());
        }

        public abstract boolean matchesName(@NonNull String var1);

        public abstract boolean isArray();

        public abstract boolean isPrimitive();

        public abstract boolean matchesSignature(@NonNull String var1);

        @NonNull
        public TypeReference getNode() {
            TypeReference typeReference2 = new TypeReference();
            StrictListAccessor parts = typeReference2.astParts();
            for (String part : Splitter.on((char)'.').split((CharSequence)this.getName())) {
                Identifier identifier = Identifier.of((String)part);
                parts.addToEnd((Node[])new TypeReferencePart[]{new TypeReferencePart().astIdentifier(identifier)});
            }
            return typeReference2;
        }

        @Nullable
        public abstract ResolvedClass getTypeClass();

        public abstract boolean equals(Object var1);

        public String toString() {
            return this.getName();
        }
    }
}

