/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.run;

import cucumber.api.Result;
import cucumber.api.TestCase;
import cucumber.api.TestStep;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseFinished;
import cucumber.api.event.TestCaseStarted;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestSourceRead;
import cucumber.api.event.TestStepFinished;
import cucumber.api.event.TestStepStarted;
import cucumber.api.formatter.Formatter;
import gherkin.events.PickleEvent;
import gherkin.pickles.PickleLocation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.plugins.cucumber.java.run.CucumberJvmSMFormatterUtil;

public class CucumberJvm2SMFormatter
implements Formatter {
    private static final String EXAMPLES_CAPTION = "Examples:";
    private static final String SCENARIO_OUTLINE_CAPTION = "Scenario: Line: ";
    private Map<String, String> pathToDescription = new HashMap<String, String>();
    private String currentFilePath;
    private int currentScenarioOutlineLine;
    private String currentScenarioOutlineName;
    private EventHandler<TestCaseStarted> testCaseStartedHandler = new EventHandler<TestCaseStarted>(){

        public void receive(TestCaseStarted event) {
            CucumberJvm2SMFormatter.this.handleTestCaseStarted(event);
        }
    };
    private EventHandler<TestCaseFinished> testCaseFinishedHandler = new EventHandler<TestCaseFinished>(){

        public void receive(TestCaseFinished event) {
            CucumberJvm2SMFormatter.handleTestCaseFinished(event);
        }
    };
    private EventHandler<TestRunFinished> testRunFinishedHandler = new EventHandler<TestRunFinished>(){

        public void receive(TestRunFinished event) {
            CucumberJvm2SMFormatter.this.handleTestRunFinished(event);
        }
    };
    private EventHandler<TestStepStarted> testStepStartedHandler = new EventHandler<TestStepStarted>(){

        public void receive(TestStepStarted event) {
            CucumberJvm2SMFormatter.handleTestStepStarted(event);
        }
    };
    private EventHandler<TestStepFinished> testStepFinishedHandler = new EventHandler<TestStepFinished>(){

        public void receive(TestStepFinished event) {
            CucumberJvm2SMFormatter.handleTestStepFinished(event);
        }
    };
    private EventHandler<TestSourceRead> testSourceReadHandler = new EventHandler<TestSourceRead>(){

        public void receive(TestSourceRead event) {
            CucumberJvm2SMFormatter.this.handleTestSourceRead(event);
        }
    };

    public CucumberJvm2SMFormatter() {
        CucumberJvm2SMFormatter.outCommand(String.format("##teamcity[enteredTheMatrix timestamp = '%s']", CucumberJvmSMFormatterUtil.getCurrentTime()));
        CucumberJvm2SMFormatter.outCommand(String.format("##teamcity[customProgressStatus testsCategory = 'Scenarios' count = '%s' timestamp = '%s']", 0, CucumberJvmSMFormatterUtil.getCurrentTime()));
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestCaseStarted.class, this.testCaseStartedHandler);
        publisher.registerHandlerFor(TestCaseFinished.class, this.testCaseFinishedHandler);
        publisher.registerHandlerFor(TestStepStarted.class, this.testStepStartedHandler);
        publisher.registerHandlerFor(TestStepFinished.class, this.testStepFinishedHandler);
        publisher.registerHandlerFor(TestSourceRead.class, this.testSourceReadHandler);
        publisher.registerHandlerFor(TestRunFinished.class, this.testRunFinishedHandler);
    }

    private void handleTestCaseStarted(TestCaseStarted event) {
        if (this.currentFilePath == null) {
            CucumberJvm2SMFormatter.outCommand(String.format("##teamcity[testSuiteStarted timestamp = '%s' locationHint = 'file://%s' name = '%s']", CucumberJvmSMFormatterUtil.getCurrentTime(), event.testCase.getUri(), this.getFeatureFileDescription(event.testCase.getUri())));
        } else if (!event.testCase.getUri().equals(this.currentFilePath)) {
            this.closeCurrentScenarioOutline();
            CucumberJvm2SMFormatter.outCommand(String.format("##teamcity[testSuiteFinished timestamp = '%s' name = '%s']", CucumberJvmSMFormatterUtil.getCurrentTime(), this.getFeatureFileDescription(this.currentFilePath)));
            CucumberJvm2SMFormatter.outCommand(String.format("##teamcity[testSuiteStarted timestamp = '%s' locationHint = 'file://%s' name = '%s']", CucumberJvmSMFormatterUtil.getCurrentTime(), event.testCase.getUri(), this.getFeatureFileDescription(event.testCase.getUri())));
        }
        if (CucumberJvm2SMFormatter.isScenarioOutline(event.testCase)) {
            int mainScenarioLine = CucumberJvm2SMFormatter.getScenarioOutlineLine(event.testCase);
            if (this.currentScenarioOutlineLine != mainScenarioLine || this.currentFilePath == null || !this.currentFilePath.equals(event.testCase.getUri())) {
                this.closeCurrentScenarioOutline();
                this.currentScenarioOutlineLine = mainScenarioLine;
                this.currentScenarioOutlineName = event.testCase.getName();
                CucumberJvm2SMFormatter.outCommand(String.format("##teamcity[testSuiteStarted timestamp = '%s' locationHint = 'file://%s' name = '%s']", CucumberJvmSMFormatterUtil.getCurrentTime(), event.testCase.getUri() + ":" + this.currentScenarioOutlineLine, this.currentScenarioOutlineName));
                CucumberJvm2SMFormatter.outCommand(String.format("##teamcity[testSuiteStarted timestamp = '%s' locationHint = 'file://%s' name = '%s']", CucumberJvmSMFormatterUtil.getCurrentTime(), "", EXAMPLES_CAPTION));
            }
        } else {
            this.closeCurrentScenarioOutline();
        }
        this.currentFilePath = event.testCase.getUri();
        CucumberJvm2SMFormatter.outCommand(String.format("##teamcity[testSuiteStarted timestamp = '%s' locationHint = 'file://%s' name = '%s']", CucumberJvmSMFormatterUtil.getCurrentTime(), event.testCase.getUri() + ":" + event.testCase.getLine(), CucumberJvm2SMFormatter.getScenarioName(event.testCase)));
    }

    private static void handleTestCaseFinished(TestCaseFinished event) {
        CucumberJvm2SMFormatter.outCommand(String.format("##teamcity[testSuiteFinished timestamp = '%s' name = '%s']", CucumberJvmSMFormatterUtil.getCurrentTime(), CucumberJvm2SMFormatter.getScenarioName(event.testCase)));
    }

    private void handleTestRunFinished(TestRunFinished event) {
        this.closeCurrentScenarioOutline();
        CucumberJvm2SMFormatter.outCommand(String.format("##teamcity[testSuiteFinished timestamp = '%s' name = '%s']", CucumberJvmSMFormatterUtil.getCurrentTime(), this.getFeatureFileDescription(this.currentFilePath)));
    }

    private static void handleTestStepStarted(TestStepStarted event) {
        if (event.testStep.isHook()) {
            return;
        }
        CucumberJvm2SMFormatter.outCommand(String.format("##teamcity[testStarted timestamp = '%s' locationHint = 'file:///%s' captureStandardOutput = 'true' name = '%s']", CucumberJvmSMFormatterUtil.getCurrentTime(), CucumberJvm2SMFormatter.getStepLocation(event.testStep), CucumberJvm2SMFormatter.getStepName(event.testStep)));
    }

    private static void handleTestStepFinished(TestStepFinished event) {
        if (event.testStep.isHook()) {
            return;
        }
        if (event.result.getStatus() != Result.Type.PASSED) {
            if (event.result.getStatus() == Result.Type.SKIPPED || event.result.getStatus() == Result.Type.PENDING) {
                CucumberJvm2SMFormatter.outCommand(String.format("##teamcity[testIgnored name = '%s' message = 'Skipped step' timestamp = '%s']", CucumberJvm2SMFormatter.getStepName(event.testStep), CucumberJvmSMFormatterUtil.getCurrentTime()));
            } else {
                CucumberJvm2SMFormatter.outCommand(String.format("##teamcity[testFailed timestamp = '%s' details = '%s' message = '%s' name = '%s' %s]", CucumberJvmSMFormatterUtil.getCurrentTime(), "", CucumberJvmSMFormatterUtil.escape(event.result.getErrorMessage()), CucumberJvm2SMFormatter.getStepName(event.testStep), ""));
            }
        }
        Long duration = event.result.getDuration() != null ? event.result.getDuration() / 1000000L : 0L;
        CucumberJvm2SMFormatter.outCommand(String.format("##teamcity[testFinished timestamp = '%s' duration = '%s' name = '%s']", CucumberJvmSMFormatterUtil.getCurrentTime(), duration, CucumberJvm2SMFormatter.getStepName(event.testStep)));
    }

    private String getFeatureFileDescription(String uri) {
        if (this.pathToDescription.containsKey(uri)) {
            return this.pathToDescription.get(uri);
        }
        return uri;
    }

    private void handleTestSourceRead(TestSourceRead event) {
        this.closeCurrentScenarioOutline();
        String[] lines = event.source.split("\n");
        if (lines.length > 0) {
            this.pathToDescription.put(event.uri, lines[0]);
        } else {
            this.pathToDescription.put(event.uri, event.source);
        }
    }

    private void closeCurrentScenarioOutline() {
        if (this.currentScenarioOutlineLine > 0) {
            CucumberJvm2SMFormatter.outCommand(String.format("##teamcity[testSuiteFinished timestamp = '%s' name = '%s']", CucumberJvmSMFormatterUtil.getCurrentTime(), EXAMPLES_CAPTION));
            CucumberJvm2SMFormatter.outCommand(String.format("##teamcity[testSuiteFinished timestamp = '%s' name = '%s']", CucumberJvmSMFormatterUtil.getCurrentTime(), this.currentScenarioOutlineName));
            this.currentScenarioOutlineLine = 0;
            this.currentScenarioOutlineName = null;
        }
    }

    private static String getStepLocation(TestStep step) {
        return step.getStepLocation() + ":" + step.getStepLine();
    }

    private static String getStepName(TestStep step) {
        return CucumberJvmSMFormatterUtil.escape(step.getStepText());
    }

    private static void outCommand(String s) {
        System.out.println(s);
    }

    private static PickleEvent getPickleEvent(TestCase testCase) {
        try {
            Field pickleEventField = TestCase.class.getDeclaredField("pickleEvent");
            pickleEventField.setAccessible(true);
            return (PickleEvent)pickleEventField.get(testCase);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static boolean isScenarioOutline(TestCase testCase) {
        PickleEvent pickleEvent = CucumberJvm2SMFormatter.getPickleEvent(testCase);
        return pickleEvent != null && pickleEvent.pickle.getLocations().size() > 1;
    }

    private static int getScenarioOutlineLine(TestCase testCase) {
        PickleEvent pickleEvent = CucumberJvm2SMFormatter.getPickleEvent(testCase);
        if (pickleEvent != null) {
            return ((PickleLocation)pickleEvent.pickle.getLocations().get(pickleEvent.pickle.getLocations().size() - 1)).getLine();
        }
        return 0;
    }

    private static String getScenarioName(TestCase testCase) {
        if (CucumberJvm2SMFormatter.isScenarioOutline(testCase)) {
            return SCENARIO_OUTLINE_CAPTION + testCase.getLine();
        }
        return CucumberJvmSMFormatterUtil.escape(testCase.getName());
    }
}

