/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.conflict;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseNodeDescription;
import org.jetbrains.idea.svn.api.NodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNConflictVersion;

public class ConflictVersion
extends BaseNodeDescription {
    private final SVNURL myRepositoryRoot;
    private final String myPath;
    private final long myPegRevision;

    @Nullable
    public static ConflictVersion create(@Nullable SVNConflictVersion conflictVersion) {
        ConflictVersion result = null;
        if (conflictVersion != null) {
            result = new ConflictVersion(conflictVersion.getRepositoryRoot(), conflictVersion.getPath(), conflictVersion.getPegRevision(), NodeKind.from(conflictVersion.getKind()));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public ConflictVersion(SVNURL repositoryRoot, String path, long pegRevision, @NotNull NodeKind nodeKind) {
        void kind;
        if (nodeKind == null) {
            ConflictVersion.$$$reportNull$$$0(0);
        }
        super((NodeKind)kind);
        this.myRepositoryRoot = repositoryRoot;
        this.myPath = path;
        this.myPegRevision = pegRevision;
    }

    public SVNURL getRepositoryRoot() {
        return this.myRepositoryRoot;
    }

    public String getPath() {
        return this.myPath;
    }

    public long getPegRevision() {
        return this.myPegRevision;
    }

    @NotNull
    public NodeKind getKind() {
        NodeKind nodeKind = this.myKind;
        if (nodeKind == null) {
            ConflictVersion.$$$reportNull$$$0(1);
        }
        return nodeKind;
    }

    @NotNull
    public String toPresentableString() {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(this.myRepositoryRoot != null ? this.myRepositoryRoot : "");
        urlBuilder.append("/");
        urlBuilder.append(this.myPath != null ? this.myPath : "...");
        String string = "(" + (Object)((Object)this.getKind()) + ") " + urlBuilder + "@" + this.getPegRevision();
        if (string == null) {
            ConflictVersion.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String toPresentableString(@Nullable ConflictVersion version) {
        String string = version == null ? "" : version.toPresentableString();
        if (string == null) {
            ConflictVersion.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/conflict/ConflictVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/conflict/ConflictVersion";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toPresentableString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

