/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip.extension;

import com.google.gson.stream.JsonToken;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.jetbrains.debugger.wip.extension.DebuggerServiceKt;
import com.jetbrains.debugger.wip.extension.JbWipVm;
import gnu.trove.TIntObjectHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.MessagingLogger;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.JsonServiceInvocator;
import org.jetbrains.rpc.CommandProcessorKt;
import org.jetbrains.wip.WipCommandProcessor;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ1\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0096\u0002J\u001e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0004\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/debugger/wip/extension/DebuggerService;", "Lorg/jetbrains/io/jsonRpc/JsonServiceInvocator;", "()V", "getVm", "Lcom/jetbrains/debugger/wip/extension/JbWipVm;", "tabId", "", "client", "Lorg/jetbrains/io/jsonRpc/Client;", "invoke", "", "command", "", "reader", "Lorg/jetbrains/io/JsonReaderEx;", "messageId", "rawMessage", "", "registerConnection", "vm", "ChromeConnector"})
public final class DebuggerService
implements JsonServiceInvocator {
    public final void registerConnection(@NotNull Client client, int tabId, @NotNull JbWipVm vm) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)((Object)vm), (String)"vm");
        TIntObjectHashMap connections = (TIntObjectHashMap)DebuggerServiceKt.access$getCONNECTION_KEY$p().get((UserDataHolder)client);
        if (connections == null) {
            connections = new TIntObjectHashMap();
            DebuggerServiceKt.access$getCONNECTION_KEY$p().set((UserDataHolder)client, (Object)connections);
        }
        if (connections.put(tabId, (Object)vm) != null) {
            throw (Throwable)new IllegalStateException("Connection " + tabId + " for client " + client + " is already registered");
        }
        Disposer.register((Disposable)vm, (Disposable)new Disposable(client, tabId){
            final /* synthetic */ Client $client;
            final /* synthetic */ int $tabId;

            public final void dispose() {
                block0: {
                    TIntObjectHashMap tIntObjectHashMap = (TIntObjectHashMap)DebuggerServiceKt.access$getCONNECTION_KEY$p().get((UserDataHolder)this.$client);
                    if (tIntObjectHashMap == null) break block0;
                    JbWipVm cfr_ignored_0 = (JbWipVm)((Object)tIntObjectHashMap.remove(this.$tabId));
                }
            }
            {
                this.$client = client;
                this.$tabId = n;
            }
        });
    }

    @Nullable
    public final JbWipVm getVm(int tabId, @Nullable Client client) {
        JbWipVm jbWipVm;
        Client client2 = client;
        if (client2 != null) {
            Client client3;
            Client it = client3 = client2;
            TIntObjectHashMap tIntObjectHashMap = (TIntObjectHashMap)DebuggerServiceKt.access$getCONNECTION_KEY$p().get((UserDataHolder)it);
            jbWipVm = tIntObjectHashMap != null ? (JbWipVm)((Object)tIntObjectHashMap.get(tabId)) : null;
        } else {
            jbWipVm = null;
        }
        return jbWipVm;
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(@NotNull String command, @NotNull Client client, @NotNull JsonReaderEx reader, int messageId, @NotNull CharSequence rawMessage) {
        JbWipVm vm;
        block7: {
            Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
            Intrinsics.checkParameterIsNotNull((Object)rawMessage, (String)"rawMessage");
            if (Intrinsics.areEqual((Object)command, (Object)"inspect")) {
                String string = reader.nextString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"reader.nextString()");
                DebuggerServiceKt.access$inspect(client, string, reader.nextInt());
                return;
            }
            TIntObjectHashMap tIntObjectHashMap = (TIntObjectHashMap)client.getUserData(DebuggerServiceKt.access$getCONNECTION_KEY$p());
            JbWipVm jbWipVm = vm = tIntObjectHashMap != null ? (JbWipVm)((Object)tIntObjectHashMap.get(reader.nextInt())) : null;
            if (vm == null) {
                if (Intrinsics.areEqual((Object)command, (Object)"detached") ^ true && Intrinsics.areEqual((Object)command, (Object)"handleResult") ^ true) {
                    CommandProcessorKt.getLOG().warn("connection null");
                }
                return;
            }
            MessagingLogger messagingLogger = vm.getDebugMessageQueue$ChromeConnector();
            if (messagingLogger != null) {
                MessagingLogger messagingLogger2;
                MessagingLogger it = messagingLogger2 = messagingLogger;
                int n = 0;
                int n2 = 101;
                while (n < n2) {
                    void i;
                    if (!StringsKt.startsWith$default((CharSequence)rawMessage, (CharSequence)" \"Network.", (int)i, (boolean)false, (int)4, null)) {
                        ++i;
                        continue;
                    }
                    break block7;
                }
                MessagingLogger.add$default((MessagingLogger)it, (CharSequence)rawMessage, null, (int)2, null);
            }
        }
        if (Intrinsics.areEqual((Object)command, (Object)"detached")) {
            vm.externallyDetached();
            return;
        }
        WipCommandProcessor commandProcessor2 = vm.getCommandProcessor();
        vm.getQueueProcessor().add((Object)new Function0<Unit>(command, commandProcessor2, reader){
            final /* synthetic */ String $command;
            final /* synthetic */ WipCommandProcessor $commandProcessor;
            final /* synthetic */ JsonReaderEx $reader;

            public final void invoke() {
                switch (this.$command) {
                    case "handleResult": {
                        this.$commandProcessor.commandResultReceived(this.$reader.nextInt(), Intrinsics.areEqual((Object)this.$reader.peek(), (Object)JsonToken.END_ARRAY) ? null : this.$reader);
                        break;
                    }
                    case "handleError": {
                        int n = this.$reader.nextInt();
                        String string = this.$reader.nextString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"reader.nextString()");
                        this.$commandProcessor.commandErrorReceived(n, string);
                        break;
                    }
                    case "handleEvent": {
                        String string = this.$reader.nextString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"reader.nextString()");
                        this.$commandProcessor.eventEmitted(string, Intrinsics.areEqual((Object)this.$reader.peek(), (Object)JsonToken.END_ARRAY) ? null : this.$reader);
                        break;
                    }
                    default: {
                        throw (Throwable)new IllegalStateException("unknown method " + this.$command);
                    }
                }
            }
            {
                this.$command = string;
                this.$commandProcessor = wipCommandProcessor;
                this.$reader = jsonReaderEx;
                super(0);
            }
        });
    }
}

