/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.reactnative;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import com.jetbrains.plugins.reactnative.ReactNativeProcessStateKt;
import com.jetbrains.plugins.reactnative.ReactNativeRunConfiguration;
import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u001d\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/plugins/reactnative/ReactNativeProcessState;", "Lcom/intellij/execution/configurations/RunProfileState;", "configuration", "Lcom/jetbrains/plugins/reactnative/ReactNativeRunConfiguration;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "(Lcom/jetbrains/plugins/reactnative/ReactNativeRunConfiguration;Lcom/intellij/execution/runners/ExecutionEnvironment;)V", "getConfiguration", "()Lcom/jetbrains/plugins/reactnative/ReactNativeRunConfiguration;", "getEnvironment", "()Lcom/intellij/execution/runners/ExecutionEnvironment;", "execute", "Lcom/intellij/execution/ExecutionResult;", "executor", "Lcom/intellij/execution/Executor;", "runner", "Lcom/intellij/execution/runners/ProgramRunner;", "findProxyResource", "", "startNodeProcess", "Lcom/intellij/execution/process/OSProcessHandler;", "debugPort", "", "packagerPort", "startNodeProcess$ReactNativeDebugger", "ReactNativeDebugger"})
public final class ReactNativeProcessState
implements RunProfileState {
    @NotNull
    private final ReactNativeRunConfiguration configuration;
    @NotNull
    private final ExecutionEnvironment environment;

    @Nullable
    public ExecutionResult execute(@Nullable Executor executor, @NotNull ProgramRunner<?> runner) {
        Intrinsics.checkParameterIsNotNull(runner, (String)"runner");
        throw (Throwable)new NotImplementedError("Should be started in ReactNativeProgramRunner");
    }

    @NotNull
    public final OSProcessHandler startNodeProcess$ReactNativeDebugger(int debugPort, int packagerPort) {
        GeneralCommandLine commandLine = new GeneralCommandLine();
        NodeJsLocalInterpreter interpreter = this.configuration.getNodePath().resolveAsLocal(this.environment.getProject());
        commandLine.setExePath(interpreter.getInterpreterSystemDependentPath());
        NodeCommandLineUtil.addNodeOptionsForDebugging((GeneralCommandLine)commandLine, Collections.emptyList(), (int)debugPort, (boolean)true, (NodeJsInterpreter)((NodeJsInterpreter)interpreter), (boolean)false);
        commandLine.withWorkDirectory(this.configuration.getEffectiveWorkingDirectory());
        String resource = this.findProxyResource();
        String path = resource + File.separator + "launcher.js";
        commandLine.addParameter(path);
        int n = packagerPort;
        int n2 = 10;
        StringBuilder stringBuilder = new StringBuilder().append("--port=");
        GeneralCommandLine generalCommandLine = commandLine;
        String string = Integer.toString(n, CharsKt.checkRadix((int)n2));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
        String string2 = string;
        generalCommandLine.addParameter(stringBuilder.append(string2).toString());
        Project project = this.environment.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"environment.project");
        String storagePath = ReactNativeProcessStateKt.reactNativeBuildPath(project);
        FileUtil.createDirectory((File)new File(storagePath));
        commandLine.addParameter("--sourcesStoragePath=" + storagePath);
        if (ReactNativeProcessStateKt.access$getLOG$p().isTraceEnabled()) {
            Map map = commandLine.getEnvironment();
            String string3 = "RN_LOG_LEVEL";
            String string4 = "Trace";
            map.put(string3, string4);
        }
        OSProcessHandler processHandler = new OSProcessHandler(commandLine);
        ProcessTerminatedListener.attach((ProcessHandler)((ProcessHandler)processHandler), (Project)this.environment.getProject());
        return processHandler;
    }

    private final String findProxyResource() {
        String jarPath = PathUtil.getJarPathForClass(ReactNativeProcessState.class);
        if (!StringsKt.endsWith$default((String)jarPath, (String)".jar", (boolean)false, (int)2, null)) {
            URL uRL = ReactNativeProcessState.class.getClassLoader().getResource("proxy");
            if (uRL == null) {
                throw (Throwable)new RuntimeException("Installation corrupted: no react native debugger proxy files found");
            }
            URL resource = uRL;
            String string = resource.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resource.path");
            return string;
        }
        File jarFile = new File(jarPath);
        if (!jarFile.isFile()) {
            throw (Throwable)new RuntimeException("jar file not found");
        }
        File pluginBaseDir = jarFile.getParentFile().getParentFile();
        return pluginBaseDir.getAbsolutePath() + File.separator + "proxy";
    }

    @NotNull
    public final ReactNativeRunConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final ExecutionEnvironment getEnvironment() {
        return this.environment;
    }

    public ReactNativeProcessState(@NotNull ReactNativeRunConfiguration configuration, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        this.configuration = configuration;
        this.environment = environment;
    }
}

