/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.server;

import com.intellij.javaee.appServerIntegrations.ApplicationServerPersistentDataEditor;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.openapi.ex.AppServerIntegrationsManager;
import com.intellij.javaee.oss.descriptor.JavaeeAppDescriptor;
import com.intellij.javaee.oss.descriptor.JavaeeCmpDescriptor;
import com.intellij.javaee.oss.descriptor.JavaeeDescriptorsManager;
import com.intellij.javaee.oss.descriptor.JavaeeEjbDescriptor;
import com.intellij.javaee.oss.descriptor.JavaeeWebDescriptor;
import com.intellij.javaee.oss.jboss.JBossBundle;
import com.intellij.javaee.oss.jboss.JBossUtil;
import com.intellij.javaee.oss.jboss.descriptor.JBoss7AppDescriptor;
import com.intellij.javaee.oss.jboss.descriptor.JBoss7WebDescriptor;
import com.intellij.javaee.oss.jboss.model.JBoss7AppRoot;
import com.intellij.javaee.oss.jboss.model.JBoss7WebRoot;
import com.intellij.javaee.oss.jboss.model.JBossAppRoot;
import com.intellij.javaee.oss.jboss.model.JBossCmpRoot;
import com.intellij.javaee.oss.jboss.model.JBossEjbRoot;
import com.intellij.javaee.oss.jboss.model.JBossWebRoot;
import com.intellij.javaee.oss.jboss.server.JBossDeploymentProvider;
import com.intellij.javaee.oss.jboss.server.JBossServerHelper;
import com.intellij.javaee.oss.jboss.server.JBossServerVersionConfig;
import com.intellij.javaee.oss.jboss.version.JBossVersion6Handler;
import com.intellij.javaee.oss.jboss.version.JBossVersion7Handler;
import com.intellij.javaee.oss.jboss.version.JBossVersionHandler;
import com.intellij.javaee.oss.server.JavaeeIntegration;
import com.intellij.javaee.oss.server.JavaeePersistentData;
import com.intellij.javaee.oss.server.JavaeePersistentDataEditor;
import com.intellij.javaee.oss.server.JavaeeServerHelper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Function;
import icons.IdeaJbossBaseIcons;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBossIntegration
extends JavaeeIntegration {
    private static final Logger LOG = Logger.getInstance(JBossIntegration.class);

    public static JavaeeIntegration getInstance() {
        return (JavaeeIntegration)AppServerIntegrationsManager.getInstance().getIntegration(JBossIntegration.class);
    }

    @NotNull
    public String getName() {
        String string = JBossBundle.getText("JBossIntegration.name", new Object[0]);
        if (string == null) {
            JBossIntegration.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = IdeaJbossBaseIcons.Jboss;
        if (icon == null) {
            JBossIntegration.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    public Icon getBigIcon() {
        Icon icon = IdeaJbossBaseIcons.Jbossbig;
        if (icon == null) {
            JBossIntegration.$$$reportNull$$$0(2);
        }
        return icon;
    }

    protected void collectDescriptors(JavaeeDescriptorsManager descriptorsManager) {
        descriptorsManager.addItem(JavaeeAppDescriptor.class, JBossAppRoot.class, "jboss-app");
        descriptorsManager.addItem(JavaeeEjbDescriptor.class, JBossEjbRoot.class, "jboss");
        descriptorsManager.addItem(JavaeeCmpDescriptor.class, JBossCmpRoot.class, "jbosscmp-jdbc");
        descriptorsManager.addItem(JavaeeWebDescriptor.class, JBossWebRoot.class, "jboss-web");
        String deploymentStructureRootTagName = "jboss-deployment-structure";
        descriptorsManager.addItem(JBoss7AppDescriptor.class, JBoss7AppRoot.class, "jboss-deployment-structure");
        descriptorsManager.addItem(JBoss7WebDescriptor.class, JBoss7WebRoot.class, "jboss-deployment-structure");
    }

    @Nullable
    @NonNls
    public String getNameFromTemplate(String template) {
        return template.split("_")[0];
    }

    @Nullable
    @NonNls
    public String getVersionFromTemplate(String template) {
        return template.replaceAll("[\\w-]+_(\\d+)_(\\d)\\.xml", "$1.$2");
    }

    @Nullable
    public static JBossVersionHandler getVersionHandler(String home) {
        JBossVersionHandler[] versionHandlers;
        for (JBossVersionHandler versionHandler : versionHandlers = new JBossVersionHandler[]{new JBossVersion7Handler(home), new JBossVersion6Handler(home)}) {
            try {
                versionHandler.detect();
                return versionHandler;
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
            }
        }
        return null;
    }

    @NotNull
    public String getServerVersion(JavaeePersistentData data) throws Exception {
        String string = JBossServerVersionConfig.get(data);
        if (string == null) {
            JBossIntegration.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected void checkValidServerHome(String home, String version) throws Exception {
    }

    protected void addLibraryLocations(String home, List<File> locations) {
        locations.add(new File(home, "common/lib"));
        locations.add(new File(home, "lib"));
        File[] files = new File(home, "server").listFiles();
        if (files != null) {
            for (File server : files) {
                locations.add(new File(server, "lib"));
                locations.add(new File(server, "deploy"));
            }
        }
        locations.add(new File(home, "modules"));
    }

    protected boolean allLibrariesFound(Collection<String> classes, Function<String, String> mapper) {
        return JBossIntegration.allLibrariesExceptEjbFound(classes, mapper);
    }

    @Nullable
    public String getContextRoot(JavaeeFacet facet) {
        JBossWebRoot web = JBossUtil.getWebRoot(facet);
        return web != null ? (String)web.getContextRoot().getValue() : null;
    }

    public boolean isKillOnDestroyWhileStarting() {
        return true;
    }

    public DeploymentProvider getDeploymentProvider(boolean local) {
        return new JBossDeploymentProvider();
    }

    protected JavaeeServerHelper createServerHelper() {
        return new JBossServerHelper();
    }

    public ApplicationServerPersistentDataEditor createNewServerEditor() {
        return new JavaeePersistentDataEditor((JavaeeIntegration)this);
    }

    public boolean isJreCustomizable() {
        return true;
    }

    @Nullable
    public String getFrameworkLibrariesDescriptionRemoteName() {
        return "jboss";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/javaee/oss/jboss/server/JBossIntegration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBigIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerVersion";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

