/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.server;

import com.intellij.javaee.oss.jboss.config.JBoss7PortConfig;
import com.intellij.javaee.oss.jboss.config.Jboss7ServerGroupsConfig;
import com.intellij.javaee.oss.jboss.server.JBossLocalModel;
import com.intellij.javaee.oss.jboss.server.JBossServerModel;
import com.intellij.javaee.oss.server.JavaeePortConfig;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class JBossOperatingModePanel {
    private JPanel myMainPanel;
    private JRadioButton myStandaloneRadioButton;
    private JRadioButton myDomainRadioButton;
    private JComboBox myServerGroupComboBox;
    private JBLabel myServerGroupLabel;
    private JLabel myPortOffsetLabel;
    private JTextField myPortOffsetField;
    private boolean myOffsetSupported;
    private final boolean myLocal;

    public JBossOperatingModePanel(boolean isLocal) {
        this.myLocal = isLocal;
        this.myOffsetSupported = isLocal;
        this.$$$setupUI$$$();
        this.myDomainRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JBossOperatingModePanel.this.setVisibleServerGroup(true);
                JBossOperatingModePanel.this.setVisiblePortOffset(false);
            }
        });
        this.myStandaloneRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JBossOperatingModePanel.this.setVisibleServerGroup(false);
                JBossOperatingModePanel.this.setVisiblePortOffset(JBossOperatingModePanel.this.myOffsetSupported);
            }
        });
        this.myStandaloneRadioButton.doClick();
    }

    private void setVisibleServerGroup(boolean isVisible) {
        this.myServerGroupLabel.setVisible(isVisible);
        this.myServerGroupComboBox.setVisible(isVisible);
    }

    private void setVisiblePortOffset(boolean isVisible) {
        this.myPortOffsetLabel.setVisible(isVisible);
        this.myPortOffsetField.setVisible(isVisible);
    }

    public void setVisible(boolean visible) {
        this.myMainPanel.setVisible(visible);
    }

    public void resetEditorFrom(JBossServerModel model) {
        (model.isDomain() ? this.myDomainRadioButton : this.myStandaloneRadioButton).doClick();
        this.myServerGroupComboBox.removeAllItems();
        if (this.myLocal) {
            for (String serverGroup : Jboss7ServerGroupsConfig.getServerGroups(model)) {
                this.myServerGroupComboBox.addItem(serverGroup);
            }
            String vmArgumentName = JBoss7PortConfig.getOffsetVmArgumentName((JBossLocalModel)model);
            this.myOffsetSupported = StringUtil.isNotEmpty((String)vmArgumentName);
            this.setVisiblePortOffset(this.myOffsetSupported);
            if (this.myOffsetSupported) {
                this.myPortOffsetField.setText(StringUtil.notNullize((String)model.getVmArgument(vmArgumentName)));
            }
        }
        this.myServerGroupComboBox.setEditable(!this.myLocal);
        this.myServerGroupComboBox.setSelectedItem(model.getServerGroup());
    }

    public void applyEditorTo(JBossServerModel model) {
        model.setDomain(this.myDomainRadioButton.isSelected());
        model.setServerGroup((String)this.myServerGroupComboBox.getSelectedItem());
        if (this.myLocal) {
            Integer portOffset = JavaeePortConfig.safeParseInt((String)this.myPortOffsetField.getText());
            String vmArgumentName = JBoss7PortConfig.getOffsetVmArgumentName((JBossLocalModel)model);
            if (vmArgumentName != null) {
                model.setVmArgument(vmArgumentName, portOffset == null || model.isDomain() ? null : String.valueOf(portOffset));
            }
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JLabel jLabel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JComboBox jComboBox;
        JBLabel jBLabel;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myServerGroupLabel = jBLabel = new JBLabel();
        jBLabel.setText("Server group:");
        jPanel.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myServerGroupComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(2, 1, 1, 3, 8, 1, 2, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Operating mode:");
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myStandaloneRadioButton = jRadioButton2 = new JRadioButton();
        ((Component)jRadioButton2).setEnabled(true);
        jRadioButton2.setSelected(true);
        jRadioButton2.setText("standalone");
        jRadioButton2.setMnemonic('S');
        jRadioButton2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDomainRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("domain");
        jRadioButton.setMnemonic('D');
        jRadioButton.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jRadioButton, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myPortOffsetLabel = jLabel = new JLabel();
        jLabel.setText("Port offset:");
        jLabel.setDisplayedMnemonic('P');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPortOffsetField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 3, 8, 1, 0, 0, null, new Dimension(150, -1), null));
        jBLabel.setLabelFor(jComboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

