/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.server;

import com.intellij.javaee.oss.jboss.server.JBossIntegration;
import com.intellij.javaee.oss.jboss.server.JBossOperatingModePanel;
import com.intellij.javaee.oss.jboss.server.JBossRemoteModel;
import com.intellij.javaee.oss.jboss.version.JBossContributionsProvider;
import com.intellij.javaee.oss.jboss.version.JBossVersion6Handler;
import com.intellij.javaee.oss.jboss.version.JBossVersion7Handler;
import com.intellij.javaee.oss.jboss.version.JBossVersionContribution;
import com.intellij.javaee.oss.server.JavaeeRunSettingsEditor;
import com.intellij.javaee.oss.transport.SimpleRemoteServerModel;
import com.intellij.javaee.oss.transport.SimpleRemoteStagingEditor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

class JBossRemoteEditor
extends JavaeeRunSettingsEditor<JBossRemoteModel> {
    private JPanel panel;
    private JTextField username;
    private JPasswordField password;
    private SimpleRemoteStagingEditor myRemoteStagingEditor;
    private JLabel myJndiPortLabel;
    private JTextField myJndiPort;
    private JTextField myManagementPort;
    private JLabel myManagementPortLabel;
    private JBossOperatingModePanel myOperatingModePanel;
    private final JBossContributionsProvider<RemoteEditorContribution> myContributionsProvider;

    public JBossRemoteEditor() {
        super(JBossIntegration.getInstance());
        this.$$$setupUI$$$();
        this.myContributionsProvider = new JBossContributionsProvider<RemoteEditorContribution>(RemoteEditorContribution.class);
        this.myContributionsProvider.add(JBossVersion6Handler.ID, new RemoteEditorContribution(){

            @Override
            public void resetEditorFrom(JBossRemoteModel model) {
                JBossRemoteEditor.this.setJndiVisible(true);
                JBossRemoteEditor.this.setManagementVisible(false);
                JBossRemoteEditor.this.myOperatingModePanel.setVisible(false);
            }
        });
        this.myContributionsProvider.add(JBossVersion7Handler.ID, new RemoteEditorContribution(){

            @Override
            public void resetEditorFrom(JBossRemoteModel model) {
                JBossRemoteEditor.this.setJndiVisible(false);
                JBossRemoteEditor.this.setManagementVisible(true);
                JBossRemoteEditor.this.myOperatingModePanel.resetEditorFrom(model);
                JBossRemoteEditor.this.myOperatingModePanel.setVisible(true);
            }
        });
        this.myContributionsProvider.addDefault(new RemoteEditorContribution(){

            @Override
            public void resetEditorFrom(JBossRemoteModel model) {
                JBossRemoteEditor.this.setJndiVisible(false);
                JBossRemoteEditor.this.setManagementVisible(false);
                JBossRemoteEditor.this.myOperatingModePanel.setVisible(false);
            }
        });
    }

    private void setJndiVisible(boolean visible) {
        this.myJndiPort.setVisible(visible);
        this.myJndiPortLabel.setVisible(visible);
    }

    private void setManagementVisible(boolean visible) {
        this.myManagementPort.setVisible(visible);
        this.myManagementPortLabel.setVisible(visible);
    }

    @NotNull
    protected JComponent getEditor() {
        JPanel jPanel = this.panel;
        if (jPanel == null) {
            JBossRemoteEditor.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    protected void resetEditorFrom(JBossRemoteModel model) {
        model.getContribution(this.myContributionsProvider).resetEditorFrom(model);
        this.myJndiPort.setText(String.valueOf(model.JNDI_PORT));
        this.myManagementPort.setText(String.valueOf(model.MANAGEMENT_PORT));
        this.username.setText(model.USERNAME);
        this.password.setText(model.PASSWORD);
        this.myRemoteStagingEditor.resetEditorFrom((SimpleRemoteServerModel)model);
    }

    protected void applyEditorTo(JBossRemoteModel model) throws ConfigurationException {
        model.JNDI_PORT = JBossRemoteEditor.getPort(this.myJndiPort, 1099);
        model.MANAGEMENT_PORT = JBossRemoteEditor.getPort(this.myManagementPort, 9999);
        model.USERNAME = this.username.getText();
        model.PASSWORD = new String(this.password.getPassword());
        this.myRemoteStagingEditor.applyEditorTo((SimpleRemoteServerModel)model);
        this.myOperatingModePanel.applyEditorTo(model);
    }

    private static int getPort(JTextField portField, int defaultValue) {
        try {
            return Integer.parseInt(portField.getText());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private void createUIComponents() {
        this.myRemoteStagingEditor = new SimpleRemoteStagingEditor();
        this.myOperatingModePanel = new JBossOperatingModePanel(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/jboss/server/JBossRemoteEditor", "getEditor"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPasswordField jPasswordField;
        JTextField jTextField;
        JLabel jLabel;
        JTextField jTextField2;
        JTextField jTextField3;
        JLabel jLabel2;
        JPanel jPanel;
        this.createUIComponents();
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myJndiPortLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("resources/jboss").getString("JBossRemoteEditor.port"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myJndiPort = jTextField3 = new JTextField();
        jTextField3.setColumns(4);
        jPanel.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("resources/javaee").getString("RunEditor.username"));
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.username = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(2, 1, 1, 1, 8, 1, 0, 0, null, new Dimension(150, -1), null));
        SimpleRemoteStagingEditor simpleRemoteStagingEditor = this.myRemoteStagingEditor;
        JComponent jComponent = simpleRemoteStagingEditor.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(5, 0, 1, 3, 0, 1, 3, 3, null, null, null));
        this.myManagementPortLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("resources/jboss").getString("JBossRemoteEditor.port.management"));
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myManagementPort = jTextField = new JTextField();
        jTextField.setColumns(4);
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("resources/javaee").getString("RunEditor.password"));
        jPanel.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.password = jPasswordField = new JPasswordField();
        jPanel.add((Component)jPasswordField, new GridConstraints(3, 1, 1, 1, 8, 1, 0, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JBossOperatingModePanel jBossOperatingModePanel = this.myOperatingModePanel;
        JComponent jComponent2 = jBossOperatingModePanel.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent2, new GridConstraints(4, 0, 1, 3, 0, 1, 3, 3, null, null, null));
        jLabel2.setLabelFor(jTextField3);
        jLabel3.setLabelFor(jTextField2);
        jLabel.setLabelFor(jTextField3);
        jLabel4.setLabelFor(jPasswordField);
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static interface RemoteEditorContribution
    extends JBossVersionContribution {
        public void resetEditorFrom(JBossRemoteModel var1);
    }
}

