/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.configuration;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.specs.Spec;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.process.internal.CurrentProcess;
import org.gradle.process.internal.JvmOptions;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonJvmOptions
extends JvmOptions {
    public static final String SSL_KEYSTORE_KEY = "javax.net.ssl.keyStore";
    public static final String SSL_KEYSTOREPASSWORD_KEY = "javax.net.ssl.keyStorePassword";
    public static final String SSL_KEYSTORETYPE_KEY = "javax.net.ssl.keyStoreType";
    public static final String SSL_TRUSTSTORE_KEY = "javax.net.ssl.trustStore";
    public static final String SSL_TRUSTPASSWORD_KEY = "javax.net.ssl.trustStorePassword";
    public static final String SSL_TRUSTSTORETYPE_KEY = "javax.net.ssl.trustStoreType";
    public static final Set<String> IMMUTABLE_DAEMON_SYSTEM_PROPERTIES = ImmutableSet.of((Object)"javax.net.ssl.keyStore", (Object)"javax.net.ssl.keyStorePassword", (Object)"javax.net.ssl.keyStoreType", (Object)"javax.net.ssl.trustStorePassword", (Object)"javax.net.ssl.trustStore", (Object)"javax.net.ssl.trustStoreType", (Object[])new String[]{"org.gradle.cache.reserved.mb"});

    public DaemonJvmOptions(PathToFileResolver resolver) {
        super(resolver);
        JvmOptions currentProcessJvmOptions = new CurrentProcess().getJvmOptions();
        this.systemProperties(currentProcessJvmOptions.getImmutableSystemProperties());
        this.handleDaemonImmutableProperties(currentProcessJvmOptions.getMutableSystemProperties());
    }

    private void handleDaemonImmutableProperties(Map<String, Object> systemProperties) {
        for (Map.Entry<String, Object> entry : systemProperties.entrySet()) {
            if (!IMMUTABLE_DAEMON_SYSTEM_PROPERTIES.contains(entry.getKey())) continue;
            this.immutableSystemProperties.put(entry.getKey(), entry.getValue());
        }
    }

    public Map<String, Object> getImmutableDaemonProperties() {
        return CollectionUtils.filter(this.immutableSystemProperties, new Spec<Map.Entry<String, Object>>(){

            @Override
            public boolean isSatisfiedBy(Map.Entry<String, Object> element) {
                return IMMUTABLE_DAEMON_SYSTEM_PROPERTIES.contains(element.getKey());
            }
        });
    }

    @Override
    public void systemProperty(String name, Object value) {
        if (IMMUTABLE_DAEMON_SYSTEM_PROPERTIES.contains(name)) {
            this.immutableSystemProperties.put(name, value);
        } else {
            super.systemProperty(name, value);
        }
    }

    public List<String> getAllSingleUseImmutableJvmArgs() {
        ArrayList<String> immutableDaemonParameters = new ArrayList<String>();
        this.formatSystemProperties(this.getImmutableDaemonProperties(), immutableDaemonParameters);
        List<String> jvmArgs = this.getAllImmutableJvmArgs();
        jvmArgs.removeAll(immutableDaemonParameters);
        return jvmArgs;
    }
}

