/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.providers.contexts.spring;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.CollectionElements;
import com.intellij.spring.model.xml.beans.ListOrSet;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.spring.web.mvc.views.ViewResolverFactory;
import com.intellij.spring.web.mvc.views.ViewResolverRegistry;
import com.intellij.thymeleaf.references.paths.ThymeleafTemplateResolverMethodsSearchHelper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThymeleafViewResolverFactory
extends ViewResolverFactory {
    private static final String[] ourResolvers = new String[]{"org.thymeleaf.spring3.view.ThymeleafViewResolver", "org.thymeleaf.spring4.view.ThymeleafViewResolver"};
    private static final String VIEW_RESOLVER_ID = "thymeleaf";

    protected boolean isMine(@Nullable CommonSpringBean bean, PsiClass beanClass) {
        for (String resolverClass : ourResolvers) {
            if (!InheritanceUtil.isInheritor((PsiClass)beanClass, (String)resolverClass)) continue;
            return true;
        }
        return false;
    }

    public String getBeanClass() {
        return null;
    }

    @NotNull
    public Set<ViewResolver> doCreate(@Nullable CommonSpringBean bean, SpringModel model) {
        Module module;
        assert (bean != null);
        Module module2 = module = model.getModule() != null ? model.getModule() : bean.getModule();
        if (module == null) {
            Set<ViewResolver> set = Collections.emptySet();
            if (set == null) {
                ThymeleafViewResolverFactory.$$$reportNull$$$0(0);
            }
            return set;
        }
        com.intellij.util.containers.hash.HashSet resolvers = new com.intellij.util.containers.hash.HashSet();
        GlobalSearchScope moduleScope = GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)false);
        PsiClass templateResolverClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass("org.thymeleaf.templateresolver.ITemplateResolver", moduleScope);
        if (templateResolverClass == null) {
            Set<ViewResolver> set = Collections.emptySet();
            if (set == null) {
                ThymeleafViewResolverFactory.$$$reportNull$$$0(1);
            }
            return set;
        }
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)templateResolverClass).withInheritors();
        List configurers = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)searchParameters);
        if (!configurers.isEmpty()) {
            if (bean instanceof SpringBean) {
                resolvers.addAll(this.getTemplateResolvers((SpringBean)bean));
            } else if (configurers.size() > 0) {
                for (SpringBeanPointer templateResolver : configurers) {
                    ViewResolver viewResolver = ThymeleafViewResolverFactory.createURLBasedViewResolver(templateResolver);
                    resolvers.add(viewResolver);
                }
            }
        } else {
            PsiFile file = bean.getContainingFile();
            if (file instanceof PsiJavaFile) {
                GlobalSearchScope scope = GlobalSearchScope.fileScope((PsiFile)file);
                resolvers.addAll(ThymeleafViewResolverFactory.getConfiguredViewResolvers("org.thymeleaf.templateresolver.TemplateResolver", module, (SearchScope)scope));
                resolvers.addAll(ThymeleafViewResolverFactory.getConfiguredViewResolvers("org.thymeleaf.templateresolver.AbstractConfigurableTemplateResolver", module, (SearchScope)scope));
            }
        }
        com.intellij.util.containers.hash.HashSet hashSet = resolvers;
        if (hashSet == null) {
            ThymeleafViewResolverFactory.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    @NotNull
    private static Set<ViewResolver> getConfiguredViewResolvers(@NotNull String resolverClass, @NotNull Module module, @NotNull SearchScope scope) {
        if (resolverClass == null) {
            ThymeleafViewResolverFactory.$$$reportNull$$$0(3);
        }
        if (module == null) {
            ThymeleafViewResolverFactory.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            ThymeleafViewResolverFactory.$$$reportNull$$$0(5);
        }
        HashSet resolvers = ContainerUtil.newHashSet();
        PsiClass aClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(resolverClass, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
        for (Pair<PsiElement, String> pair : ThymeleafTemplateResolverMethodsSearchHelper.getTemplateResolverPrefixExpressions(aClass, "setPrefix", scope)) {
            String prefix = (String)pair.second;
            PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)pair.getFirst()), PsiMethod.class);
            if (psiMethod == null) continue;
            Set<String> suffixes = ThymeleafTemplateResolverMethodsSearchHelper.getTemplateResolverPrefixes(aClass, "setSuffix", (SearchScope)new LocalSearchScope((PsiElement)psiMethod));
            if (suffixes.isEmpty()) {
                ViewResolver viewResolver = ThymeleafViewResolverFactory.createURLBasedViewResolver(prefix, "");
                resolvers.add(viewResolver);
                continue;
            }
            resolvers.addAll(suffixes.stream().map(suffix -> ThymeleafViewResolverFactory.createURLBasedViewResolver(prefix, suffix)).collect(Collectors.toList()));
        }
        HashSet hashSet = resolvers;
        if (hashSet == null) {
            ThymeleafViewResolverFactory.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    @NotNull
    public Set<ViewResolver> getTemplateResolvers(@NotNull SpringBean bean) {
        CommonSpringBean templateEngine;
        SpringBeanPointer templateEngineBean;
        if (bean == null) {
            ThymeleafViewResolverFactory.$$$reportNull$$$0(7);
        }
        com.intellij.util.containers.hash.HashSet resolvers = new com.intellij.util.containers.hash.HashSet();
        SpringPropertyDefinition property = bean.getProperty("templateEngine");
        if (property instanceof SpringProperty && (templateEngineBean = (SpringBeanPointer)((SpringProperty)property).getRefAttr().getValue()) != null && (templateEngine = templateEngineBean.getSpringBean()) instanceof SpringBean) {
            SpringPropertyDefinition templateResolversProperty;
            SpringBeanPointer templateResolver2;
            SpringPropertyDefinition templateResolverProperty = ((SpringBean)templateEngine).getProperty("templateResolver");
            if (templateResolverProperty instanceof SpringProperty && (templateResolver2 = templateResolverProperty.getRefValue()) != null) {
                ViewResolver viewResolver = ThymeleafViewResolverFactory.createURLBasedViewResolver(templateResolver2);
                resolvers.add(viewResolver);
            }
            if ((templateResolversProperty = ((SpringBean)templateEngine).getProperty("templateResolvers")) instanceof SpringProperty) {
                Set<SpringBeanPointer> pointers = ThymeleafViewResolverFactory.getCollectionPointers((SpringProperty)templateResolversProperty);
                resolvers.addAll(pointers.stream().map(templateResolver -> ThymeleafViewResolverFactory.createURLBasedViewResolver(templateResolver)).collect(Collectors.toList()));
            }
        }
        com.intellij.util.containers.hash.HashSet hashSet = resolvers;
        if (hashSet == null) {
            ThymeleafViewResolverFactory.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    private static ViewResolver createURLBasedViewResolver(SpringBeanPointer templateResolver) {
        return ViewResolverRegistry.getInstance().createURLBasedViewResolver(VIEW_RESOLVER_ID, templateResolver.getSpringBean());
    }

    private static ViewResolver createURLBasedViewResolver(String prefix, String suffix) {
        return ViewResolverRegistry.getInstance().createURLBasedViewResolver(VIEW_RESOLVER_ID, prefix, suffix);
    }

    @NotNull
    private static Set<SpringBeanPointer> getCollectionPointers(@NotNull SpringProperty springProperty) {
        if (springProperty == null) {
            ThymeleafViewResolverFactory.$$$reportNull$$$0(9);
        }
        LinkedHashMap beans = new LinkedHashMap();
        List listOrSets = DomUtil.getChildrenOfType((DomElement)springProperty, ListOrSet.class);
        for (ListOrSet listOrSet : listOrSets) {
            SpringPropertyUtils.addCollectionReferences((CollectionElements)listOrSet, beans);
        }
        Set<SpringBeanPointer> set = beans.keySet();
        if (set == null) {
            ThymeleafViewResolverFactory.$$$reportNull$$$0(10);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/thymeleaf/providers/contexts/spring/ThymeleafViewResolverFactory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolverClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreate";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/thymeleaf/providers/contexts/spring/ThymeleafViewResolverFactory";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguredViewResolvers";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateResolvers";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCollectionPointers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguredViewResolvers";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateResolvers";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCollectionPointers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

