/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.contents.DiffContent;
import com.intellij.ide.diff.AsyncDiffElement;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.ide.diff.VirtualFileDiffElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.plugins.webDeployment.AlwaysAsk;
import com.jetbrains.plugins.webDeployment.AlwaysOverwrite;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.SyncLocalVsRemoteAction;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.CompositeDiffElement;
import com.jetbrains.plugins.webDeployment.ui.RemoteDiffElement;
import com.jetbrains.plugins.webDeployment.ui.RemoteItemDiffElement;
import com.jetbrains.plugins.webDeployment.ui.SyncLoadComponent;
import com.jetbrains.plugins.webDeployment.ui.SyncUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class LocalItemDiffElement
extends VirtualFileDiffElement
implements AsyncDiffElement {
    private static final Logger LOG = Logger.getInstance(LocalItemDiffElement.class);
    private static final int UNKNOWN_VALUE = -1;
    private static final LocalItemDiffElement[] EMPTY = new LocalItemDiffElement[0];
    private final AtomicBoolean myOperationRunning;
    private PublishConfig myConfig;
    private Deployable myServer;
    private final String myName;
    private final boolean myIsRoot;
    private final DirDiffSettings mySettings;
    private final boolean myExcluded;
    private final Project myProject;
    private final DeploymentPathMapping myMapping;

    public LocalItemDiffElement(@NotNull VirtualFile file, @NotNull DeploymentPathMapping mapping, PublishConfig config, @NotNull Deployable server, boolean excluded, DirDiffSettings settings, @NotNull String name, Project project, boolean isRoot) {
        if (file == null) {
            LocalItemDiffElement.$$$reportNull$$$0(0);
        }
        if (mapping == null) {
            LocalItemDiffElement.$$$reportNull$$$0(1);
        }
        if (server == null) {
            LocalItemDiffElement.$$$reportNull$$$0(2);
        }
        if (name == null) {
            LocalItemDiffElement.$$$reportNull$$$0(3);
        }
        super(file);
        this.myOperationRunning = new AtomicBoolean(false);
        this.myMapping = mapping;
        this.myConfig = config;
        this.myServer = server;
        this.myExcluded = excluded;
        this.mySettings = settings;
        this.myName = name;
        this.myProject = project;
        this.myIsRoot = isRoot;
    }

    public LocalItemDiffElement(@NotNull VirtualFile file, @NotNull DeploymentPathMapping mapping, PublishConfig config, @NotNull Deployable server, boolean excluded, DirDiffSettings settings, Project project, boolean isRoot) {
        if (file == null) {
            LocalItemDiffElement.$$$reportNull$$$0(4);
        }
        if (mapping == null) {
            LocalItemDiffElement.$$$reportNull$$$0(5);
        }
        if (server == null) {
            LocalItemDiffElement.$$$reportNull$$$0(6);
        }
        this(file, mapping, config, server, excluded, settings, CompositeDiffElement.getSimpleRootName(file), project, isRoot);
    }

    public LocalItemDiffElement[] getChildren() {
        if (this.myExcluded && SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings)) {
            return EMPTY;
        }
        if (this.getValue().is(VFileProperty.SYMLINK)) {
            return EMPTY;
        }
        VirtualFile[] files = this.getValue().getChildren();
        ArrayList<LocalItemDiffElement> elements = new ArrayList<LocalItemDiffElement>();
        for (VirtualFile file : files) {
            boolean isExcluded = SyncUtils.isExcludedLocalOrCorresponding(file.getPath(), this.myMapping, this.myServer, this.myConfig, this.mySettings);
            if (isExcluded && SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings) || FileTypeManager.getInstance().isFileIgnored(file)) continue;
            elements.add(new LocalItemDiffElement(file, this.myMapping, this.myConfig, this.myServer, isExcluded, this.mySettings, this.myProject, false));
        }
        return elements.toArray(new LocalItemDiffElement[elements.size()]);
    }

    @NotNull
    public DiffContent createDiffContent(@Nullable Project project, @NotNull ProgressIndicator indicator) throws ProcessCanceledException {
        if (indicator == null) {
            LocalItemDiffElement.$$$reportNull$$$0(7);
        }
        LOG.assertTrue(!SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings) || !this.isExcluded());
        DiffContent diffContent = DiffContentFactory.getInstance().create(project, this.getValue());
        if (diffContent == null) {
            LocalItemDiffElement.$$$reportNull$$$0(8);
        }
        return diffContent;
    }

    public boolean isOperationsEnabled() {
        if (this.myIsRoot) {
            return true;
        }
        if (this.myExcluded || this.myOperationRunning.get()) {
            return false;
        }
        WebServerConfig.RemotePath remotePath = this.myMapping.mapToDeployPath(this.getValue().getPath(), (Mappable)this.myServer);
        return !this.myConfig.isExcludedByName(remotePath.path) && !PublishConfig.isRemotePathExcluded(remotePath, (Mappable)this.myServer, this.myConfig);
    }

    protected boolean isExcluded() {
        return this.myExcluded;
    }

    public long getSize() {
        if (this.isExcluded() && SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings)) {
            return -1L;
        }
        try {
            return super.getSize();
        }
        catch (InvalidVirtualFileAccessException e) {
            return -1L;
        }
    }

    public long getTimeStamp() {
        long result;
        if (this.isExcluded() && SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings)) {
            result = -1L;
        } else {
            try {
                result = super.getTimeStamp();
            }
            catch (InvalidVirtualFileAccessException e) {
                LOG.warn((Throwable)e);
                result = -1L;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Timestamp of " + this.getValue().getPath() + " is " + result);
        }
        return result;
    }

    @Nullable
    public byte[] getContent() throws IOException {
        if (this.isExcluded() && SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings)) {
            return null;
        }
        if (RemoteItemDiffElement.isTooBig((DiffElement)this)) {
            return null;
        }
        try {
            return super.getContent();
        }
        catch (InvalidVirtualFileAccessException e) {
            return null;
        }
    }

    public VirtualFileDiffElement copyTo(DiffElement container, String relativePath) {
        throw new UnsupportedOperationException("Use BackgroundOperatingDiffElement.copyTo()");
    }

    public boolean delete() {
        throw new UnsupportedOperationException("Use BackgroundOperatingDiffElement.delete()");
    }

    @NotNull
    public Promise<DiffElement> copyToAsync(@NotNull DiffElement container, final @Nullable DiffElement targetElement, @NotNull String path) {
        if (container == null) {
            LocalItemDiffElement.$$$reportNull$$$0(9);
        }
        if (path == null) {
            LocalItemDiffElement.$$$reportNull$$$0(10);
        }
        if (this.myExcluded) {
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                LocalItemDiffElement.$$$reportNull$$$0(11);
            }
            return promise;
        }
        LOG.assertTrue(container instanceof RemoteDiffElement);
        final RemoteDiffElement remoteElement = (RemoteDiffElement)container;
        if (!this.myOperationRunning.compareAndSet(false, true)) {
            LOG.debug("Operation is still running on " + this.getPresentablePath());
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                LocalItemDiffElement.$$$reportNull$$$0(12);
            }
            return promise;
        }
        this.saveDocument();
        SyncLoadComponent component = (SyncLoadComponent)this.mySettings.customSettings.get("syncLoadComponent");
        WebServerConfig.RemotePath remotePath = this.myMapping.mapToDeployPath(this.getValue().getPath(), (Mappable)this.myServer);
        final AsyncPromise promise = new AsyncPromise();
        TransferOperation.Copy operation = new TransferOperation.Copy(DeploymentPathUtils.getLocalFile(this.getValue().getPath()), remotePath){

            @Override
            public void execute(ExecutionContext context) throws FileSystemException {
                RemoteItemDiffElement newElement = null;
                try {
                    context.setIgnoreOverwritingStrategy(this.promptOverwriteIgnoreNeeded(context) ? AlwaysOverwrite.INSTANCE : AlwaysAsk.INSTANCE);
                    super.execute(context);
                    if (this.mySuccessfullyFinished) {
                        newElement = new RemoteItemDiffElement(remoteElement.getConnection(), LocalItemDiffElement.this.myServer, this.myTarget, remoteElement.getProject(), LocalItemDiffElement.this.myConfig, false, LocalItemDiffElement.this.myMapping, LocalItemDiffElement.this.mySettings, LocalItemDiffElement.this.myIsRoot);
                    }
                }
                catch (FileSystemException e) {
                    LOG.warn((Throwable)e);
                    promise.setError(WDBundle.message("failed.to.upload.file.0", LocalItemDiffElement.this.getPresentablePath()));
                    throw e;
                }
                finally {
                    context.setIgnoreOverwritingStrategy(AlwaysAsk.INSTANCE);
                    RemoteItemDiffElement finalNewElement = newElement;
                    ApplicationManager.getApplication().invokeAndWait(() -> promise.setResult((Object)finalNewElement));
                    LocalItemDiffElement.this.myOperationRunning.set(false);
                }
            }

            private boolean promptOverwriteIgnoreNeeded(final ExecutionContext context) {
                if (targetElement == null || context.getConfig().getPromptOnRemoteOverwrite() == PublishConfig.PromptOnRemoteOverwrite.NONE) {
                    return false;
                }
                LOG.assertTrue(targetElement instanceof RemoteItemDiffElement);
                final RemoteItemDiffElement remoteTargetElement = (RemoteItemDiffElement)targetElement;
                try {
                    return remoteTargetElement.getConnection().executeServerOperation(new ThrowableComputable<Boolean, FileSystemException>(){

                        public Boolean compute() throws FileSystemException {
                            FileObject remoteTargetFile = remoteTargetElement.getValue();
                            DeploymentPathUtils.refreshRemoteFile(remoteTargetFile, context);
                            FileContent content = remoteTargetFile.getContent();
                            switch (context.getConfig().getPromptOnRemoteOverwrite()) {
                                case CHECK_TIMESTAMP: {
                                    boolean unchanged = true;
                                    if (remoteTargetElement.getSize() != content.getSize()) {
                                        unchanged = false;
                                    }
                                    boolean accurateTimestamp = context.getServer().getAccurateTimestamps() != AdvancedOptionsConfig.AccurateTimestamps.NEVER;
                                    long newTimestamp = content.getLastModifiedTime(accurateTimestamp);
                                    if (!(unchanged &= TransferOperation.areTimestampsEqual(remoteTargetElement.getTimeStamp(), newTimestamp, ((LocalItemDiffElement)LocalItemDiffElement.this).mySettings.compareTimestampAccuracy))) {
                                        remoteTargetElement.reset(content.getSize(), newTimestamp, null);
                                    }
                                    return unchanged;
                                }
                                case CHECK_CONTENT: {
                                    boolean unchanged = true;
                                    if (remoteTargetElement.getSize() != content.getSize()) {
                                        unchanged = false;
                                    }
                                    byte[] newContent = null;
                                    if (unchanged) {
                                        try {
                                            newContent = FileUtil.getContent((FileObject)remoteTargetFile);
                                            unchanged = Arrays.equals(remoteTargetElement.getContent(), newContent);
                                        }
                                        catch (IOException e) {
                                            LOG.warn((Throwable)e);
                                            return false;
                                        }
                                    }
                                    if (!unchanged) {
                                        boolean accurateTimestamp = context.getServer().getAccurateTimestamps() != AdvancedOptionsConfig.AccurateTimestamps.NEVER;
                                        long newTimestamp = content.getLastModifiedTime(accurateTimestamp);
                                        unchanged = TransferOperation.areTimestampsEqual(remoteTargetElement.getTimeStamp(), newTimestamp, remoteTargetFile.getFileSystem().getLastModTimeAccuracy());
                                        remoteTargetElement.reset(content.getSize(), newTimestamp, newContent);
                                    }
                                    return unchanged;
                                }
                            }
                            return false;
                        }
                    }, null);
                }
                catch (FileSystemException e) {
                    LOG.warn((Throwable)e);
                    return false;
                }
            }
        };
        component.offerTransferOperation(operation, true);
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            LocalItemDiffElement.$$$reportNull$$$0(13);
        }
        return asyncPromise;
    }

    protected void saveDocument() {
        FileDocumentManager manager = FileDocumentManager.getInstance();
        Document document = manager.getDocument(this.getValue());
        if (document != null) {
            manager.saveDocument(document);
        }
    }

    @NotNull
    public Promise<Void> deleteAsync() {
        if (!this.myOperationRunning.compareAndSet(false, true)) {
            LOG.debug("Operation is still running on " + this.getPresentablePath());
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                LocalItemDiffElement.$$$reportNull$$$0(14);
            }
            return promise;
        }
        if (this.myExcluded) {
            LOG.debug("Excluded " + this.getPresentablePath());
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                LocalItemDiffElement.$$$reportNull$$$0(15);
            }
            return promise;
        }
        if (!this.getValue().exists()) {
            this.myOperationRunning.set(false);
            Promise promise = Promises.resolvedPromise();
            if (promise == null) {
                LocalItemDiffElement.$$$reportNull$$$0(16);
            }
            return promise;
        }
        try {
            WriteAction.run(() -> this.getValue().delete((Object)this));
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            Promise promise = Promises.rejectedPromise((String)WDBundle.message("failed.to.delete.local.file.0.1", this.getValue().getPath(), StringUtil.decapitalize((String)StringUtil.notNullize((String)e.getLocalizedMessage(), (String)WDBundle.message("unknown.reason", new Object[0])))));
            Promise promise2 = promise;
            if (promise2 == null) {
                LocalItemDiffElement.$$$reportNull$$$0(17);
            }
            return promise2;
        }
        finally {
            this.myOperationRunning.set(false);
        }
        Promise promise = Promises.resolvedPromise();
        if (promise == null) {
            LocalItemDiffElement.$$$reportNull$$$0(18);
        }
        return promise;
    }

    public LocalItemDiffElement createElement(VirtualFile file) {
        return LocalItemDiffElement.createLocalElement(file, this.myMapping, this.myConfig, this.myServer, this.mySettings, this.myProject);
    }

    static LocalItemDiffElement createLocalElement(VirtualFile file, DeploymentPathMapping mapping, PublishConfig config, Deployable server, DirDiffSettings settings, Project project) {
        boolean excluded = SyncUtils.isExcludedLocalOrCorresponding(file.getPath(), mapping, server, config, settings);
        return new LocalItemDiffElement(file, mapping, config, server, excluded, settings, project, false);
    }

    public Callable<DiffElement<VirtualFile>> getElementChooser(Project project) {
        return null;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            LocalItemDiffElement.$$$reportNull$$$0(19);
        }
        return string;
    }

    public String toString() {
        return "LocalItemDiffElement{name=" + this.getName() + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/LocalItemDiffElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/LocalItemDiffElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createDiffContent";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "copyToAsync";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "deleteAsync";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDiffContent";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "copyToAsync";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

