/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.config;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.CellEditorComponentWithBrowseButton;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.IconTableCellRenderer;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.ExcludedPath;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableTab;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableTabProvider;
import com.jetbrains.plugins.webDeployment.ui.config.SettingsDeployable;
import com.jetbrains.plugins.webDeployment.ui.config.SharedDataHolder;
import com.jetbrains.plugins.webDeployment.ui.config.mappings.MappingsConfigurableForm;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.NavigableSet;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExcludedPathsConfigurableForm
implements Disposable {
    private static final LayeredIcon WARNING_FOLDER_ICON = new LayeredIcon(new Icon[]{PlatformIcons.FOLDER_ICON, AllIcons.General.WarningDecorator});
    private static final Comparator<ExcludedPath> EXCLUDED_PATH_COMPARATOR = (o1, o2) -> {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.isLocal() != o2.isLocal()) {
            return o1.isLocal() ? 1 : -1;
        }
        return StringUtil.compare((String)o1.getPath(), (String)o2.getPath(), (boolean)false);
    };
    private JBLabel myExcludedPathsLegendLabel;
    private JButton myAddLocalPathButton;
    private JButton myAddRemotePathButton;
    private JButton myRemoveExcludedPathButton;
    private JPanel myContentPane;
    private TableView<ExcludedPath> myExcludedPathsTable;
    private JPanel mySettingsPanel;
    private JPanel myLocalServerPanel;
    private JLabel myMessageLabel;
    private final Project myProject;
    private final DeploymentConfigurableTabProvider.ServerStateProvider myServerStateProvider;
    private final SharedDataHolder mySharedData;
    private final ProjectFileIndex myFileIndex;

    private void createUIComponents() {
        this.myExcludedPathsTable = new TableView();
        this.myExcludedPathsTable.setModelAndUpdateColumns(new ListTableModel(new ColumnInfo[]{new PathIconColumnInfo(), new ExcludedPathColumnInfo()}));
        this.myExcludedPathsTable.setRowHeight(Math.max(PlatformIcons.FOLDER_ICON.getIconHeight() + 2, new JTextField().getPreferredSize().height));
        this.myExcludedPathsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ExcludedPathsConfigurableForm.this.updateRemoveExcludedPathButton();
            }
        });
        this.myExcludedPathsTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ExcludedPathsConfigurableForm.this.updateMessage();
            }
        });
    }

    public ExcludedPathsConfigurableForm(Project project, DeploymentConfigurableTabProvider.ServerStateProvider serverStateProvider, SharedDataHolder sharedData, Disposable parentDisposable) {
        this.$$$setupUI$$$();
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myProject = project;
        this.myServerStateProvider = serverStateProvider;
        this.mySharedData = sharedData;
        this.myFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        this.myServerStateProvider.addListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SettingsDeployable server = (SettingsDeployable)ExcludedPathsConfigurableForm.this.myServerStateProvider.compute();
                boolean local = server == null || !server.needsTransfer();
                ExcludedPathsConfigurableForm.this.myLocalServerPanel.setVisible(local);
                ExcludedPathsConfigurableForm.this.mySettingsPanel.setVisible(!local);
            }
        }, this);
        class AddPathActionListener
        implements ActionListener {
            private final boolean isLocal;

            AddPathActionListener(boolean local) {
                this.isLocal = local;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ExcludedPathsConfigurableForm.this.myExcludedPathsTable.stopEditing();
                ExcludedPath item = new ExcludedPath("", this.isLocal);
                int modelIndex = ExcludedPathsConfigurableForm.this.myExcludedPathsTable.getListTableModel().getRowCount();
                ExcludedPathsConfigurableForm.this.myExcludedPathsTable.getListTableModel().insertRow(modelIndex, (Object)item);
                int row = ExcludedPathsConfigurableForm.this.myExcludedPathsTable.convertRowIndexToView(modelIndex);
                ExcludedPathsConfigurableForm.this.myExcludedPathsTable.getSelectionModel().setSelectionInterval(row, row);
                ExcludedPathsConfigurableForm.this.myExcludedPathsTable.scrollRectToVisible(ExcludedPathsConfigurableForm.this.myExcludedPathsTable.getCellRect(row, 0, true));
                ExcludedPathsConfigurableForm.this.myExcludedPathsTable.editCellAt(row, 1);
                IdeFocusManager.getInstance((Project)ExcludedPathsConfigurableForm.this.myProject).requestFocus(ExcludedPathsConfigurableForm.this.myExcludedPathsTable.getEditorComponent(), true);
            }
        }
        this.myAddLocalPathButton.addActionListener(new AddPathActionListener(true));
        this.myAddRemotePathButton.addActionListener(new AddPathActionListener(false));
        this.myRemoveExcludedPathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExcludedPathsConfigurableForm.this.myExcludedPathsTable.stopEditing();
                int minSelectedIndex = ExcludedPathsConfigurableForm.this.myExcludedPathsTable.getSelectionModel().getMinSelectionIndex();
                if (minSelectedIndex == -1) {
                    return;
                }
                int[] selectedIndices = ExcludedPathsConfigurableForm.this.myExcludedPathsTable.getSelectedRows();
                NavigableSet<Integer> modelIndices = new TreeSet();
                for (int selectedIndex : selectedIndices) {
                    int modelIndex = ExcludedPathsConfigurableForm.this.myExcludedPathsTable.convertRowIndexToModel(selectedIndex);
                    modelIndices.add(modelIndex);
                }
                modelIndices = modelIndices.descendingSet();
                ListTableModel model = ExcludedPathsConfigurableForm.this.myExcludedPathsTable.getListTableModel();
                for (Integer entry : modelIndices) {
                    model.removeRow(entry.intValue());
                }
                int index = Math.min(minSelectedIndex, ExcludedPathsConfigurableForm.this.myExcludedPathsTable.getRowCount() - 1);
                if (index != -1) {
                    ExcludedPathsConfigurableForm.this.myExcludedPathsTable.setRowSelectionInterval(index, index);
                }
            }
        });
        this.myMessageLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.myMessageLabel.setVisible(false);
        this.myExcludedPathsLegendLabel.setText(WDBundle.message("excluded.settings.legend", new Object[0]));
    }

    private void updateMessage() {
        for (ExcludedPath path : this.myExcludedPathsTable.getItems()) {
            if (!path.isLocal()) continue;
            String pathName = path.getPath().replace(File.separatorChar, '/');
            if (!FileUtil.isAbsolute((String)pathName)) {
                this.myMessageLabel.setText(WDBundle.message("path.is.not.absolute", path.getPath()));
                this.myMessageLabel.setVisible(true);
                return;
            }
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(pathName);
            if (file == null) {
                this.myMessageLabel.setText(WDBundle.message("local.item.not.found", path.getPath()));
                this.myMessageLabel.setVisible(true);
                return;
            }
            if (this.myFileIndex.getContentRootForFile(file) != null) continue;
            this.myMessageLabel.setText(WDBundle.message("item.is.out.of.project", path.getPath()));
            this.myMessageLabel.setVisible(true);
            return;
        }
        this.myMessageLabel.setVisible(false);
    }

    public void addItemPresentationChangeListener(final DeploymentConfigurableTab.ItemPresentationChangeListener listener, Disposable parentDisposable) {
        this.mySharedData.addDefaultServerListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                listener.presentationChanged(((ExcludedPathsConfigurableForm)ExcludedPathsConfigurableForm.this).mySharedData.getDefaultServerIdAndName().first == ExcludedPathsConfigurableForm.this.myServerStateProvider.getServerId());
            }
        }, parentDisposable);
    }

    private void updateRemoveExcludedPathButton() {
        this.myRemoveExcludedPathButton.setEnabled(this.myExcludedPathsTable.getSelectedRow() != -1);
    }

    public JComponent getContentPane() {
        return this.myContentPane;
    }

    public boolean isModified() {
        List<ExcludedPath> oldExcludedPaths;
        List currentExcludedPaths = this.myExcludedPathsTable.getItems();
        if (this.myExcludedPathsTable.getCellEditor() != null) {
            ExcludedPath original = (ExcludedPath)currentExcludedPaths.get(this.myExcludedPathsTable.getEditingRow());
            ExcludedPath override = original.clone();
            override.setPath((String)this.myExcludedPathsTable.getCellEditor().getCellEditorValue());
            if (!original.equals(override)) {
                return true;
            }
        }
        if ((oldExcludedPaths = this.getExcludedPaths()).size() != currentExcludedPaths.size()) {
            return true;
        }
        for (int i = 0; i < currentExcludedPaths.size(); ++i) {
            if (((ExcludedPath)currentExcludedPaths.get(i)).equals(oldExcludedPaths.get(i))) continue;
            return true;
        }
        return false;
    }

    public void apply() {
        this.applyTo(this.myServerStateProvider.getServerId());
    }

    public void applyTo(SettingsDeployable server) {
        this.applyTo(server.getId());
    }

    public void applyTo(String serverId) {
        this.myExcludedPathsTable.stopEditing();
        this.mySharedData.getExcludedPaths().put(serverId, PublishConfig.cloneExcludedPaths(this.myExcludedPathsTable.getItems()));
    }

    public void reset() {
        this.myExcludedPathsTable.stopEditing();
        List<ExcludedPath> excludedPaths = this.getExcludedPaths();
        this.myExcludedPathsTable.getListTableModel().setItems(PublishConfig.cloneExcludedPaths(excludedPaths));
        this.updateRemoveExcludedPathButton();
    }

    @NotNull
    private List<ExcludedPath> getExcludedPaths() {
        ArrayList<ExcludedPath> excludedPaths = this.mySharedData.getExcludedPaths().get(this.myServerStateProvider.getServerId());
        ArrayList<ExcludedPath> arrayList = excludedPaths == null ? new ArrayList<ExcludedPath>() : excludedPaths;
        if (arrayList == null) {
            ExcludedPathsConfigurableForm.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.myExcludedPathsTable.getRowCount() > 1) {
            return this.myExcludedPathsTable;
        }
        return this.myAddLocalPathButton;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/config/ExcludedPathsConfigurableForm", "getExcludedPaths"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JBLabel jBLabel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myContentPane = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.mySettingsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 3, 1, 0, 3, 3, 3, null, null, null));
        this.myExcludedPathsLegendLabel = jBLabel = new JBLabel();
        jBLabel.setText("");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        TableView<ExcludedPath> tableView = this.myExcludedPathsTable;
        jBScrollPane.setViewportView((Component)tableView);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAddLocalPathButton = jButton3 = new JButton();
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("messages/WDBundle").getString("add.local.excluded.path"));
        jPanel4.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myAddRemotePathButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messages/WDBundle").getString("add.remote.excluded.path"));
        jPanel4.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myRemoveExcludedPathButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/WDBundle").getString("remove.excluded.path"));
        jPanel4.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myLocalServerPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/WDBundle").getString("setting.is.not.available.for.local.server"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMessageLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel3.add((Component)jLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class PathIconColumnInfo
    extends ColumnInfo<ExcludedPath, ExcludedPath> {
        private PathIconColumnInfo() {
            super("");
        }

        public ExcludedPath valueOf(ExcludedPath item) {
            return item;
        }

        public boolean isCellEditable(ExcludedPath item) {
            return false;
        }

        public int getWidth(JTable table) {
            return PlatformIcons.FOLDER_ICON.getIconWidth() + 2;
        }

        public TableCellRenderer getRenderer(ExcludedPath excludedPath) {
            return new IconTableCellRenderer<ExcludedPath>(){

                protected boolean isCenterAlignment() {
                    return true;
                }

                public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focus, int row, int column) {
                    super.getTableCellRendererComponent(table, value, selected, focus, row, column);
                    this.setText("");
                    return this;
                }

                @Nullable
                protected Icon getIcon(@NotNull ExcludedPath value, JTable table, int row) {
                    if (value == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!value.isLocal()) {
                        return ((SettingsDeployable)ExcludedPathsConfigurableForm.this.myServerStateProvider.compute()).getIcon();
                    }
                    String pathName = value.getPath().replace(File.separatorChar, '/');
                    boolean warn = false;
                    if (!FileUtil.isAbsolute((String)pathName)) {
                        warn = true;
                    } else {
                        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(pathName);
                        if (file == null || ExcludedPathsConfigurableForm.this.myFileIndex.getContentRootForFile(file) == null) {
                            warn = true;
                        }
                    }
                    return warn ? WARNING_FOLDER_ICON : PlatformIcons.FOLDER_ICON;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/plugins/webDeployment/ui/config/ExcludedPathsConfigurableForm$PathIconColumnInfo$1", "getIcon"));
                }
            };
        }
    }

    private class ExcludedPathColumnInfo
    extends ColumnInfo<ExcludedPath, String> {
        private ExcludedPathColumnInfo() {
            super("   ");
        }

        public String valueOf(ExcludedPath item) {
            return item.getPath();
        }

        public boolean isCellEditable(ExcludedPath item) {
            return true;
        }

        public void setValue(ExcludedPath item, String value) {
            item.setPath(value);
            ExcludedPathsConfigurableForm.this.updateMessage();
        }

        @Nullable
        public Comparator<ExcludedPath> getComparator() {
            return EXCLUDED_PATH_COMPARATOR;
        }

        public TableCellEditor getEditor(final ExcludedPath path) {
            return new AbstractTableCellEditor(){
                CellEditorComponentWithBrowseButton<JTextField> myComponent;

                public Object getCellEditorValue() {
                    return ((JTextField)this.myComponent.getChildComponent()).getText();
                }

                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    if (path.isLocal()) {
                        TextFieldWithBrowseButton field = new TextFieldWithBrowseButton();
                        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor();
                        field.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>(null, "", (ComponentWithBrowseButton)field, ExcludedPathsConfigurableForm.this.myProject, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

                            @Nullable
                            protected VirtualFile getInitialFile() {
                                int pos;
                                String directoryName = this.getComponentText();
                                if (directoryName.length() == 0) {
                                    return null;
                                }
                                if (!FileUtil.isAbsolute((String)(directoryName = directoryName.replace(File.separatorChar, '/')))) {
                                    return null;
                                }
                                VirtualFile path = LocalFileSystem.getInstance().findFileByPath(directoryName);
                                while (path == null && directoryName.length() > 0 && (pos = directoryName.lastIndexOf(47)) > 0) {
                                    directoryName = directoryName.substring(0, pos);
                                    path = LocalFileSystem.getInstance().findFileByPath(directoryName);
                                }
                                return path;
                            }
                        });
                        this.myComponent = new CellEditorComponentWithBrowseButton((ComponentWithBrowseButton)field, (TableCellEditor)((Object)this));
                    } else {
                        ActionListener listener = new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                MappingsConfigurableForm.chooseRemotePath((JTextField)myComponent.getChildComponent(), false, WDBundle.message("choose.remote.excluded.path.title", new Object[0]), ExcludedPathsConfigurableForm.this.myServerStateProvider, ExcludedPathsConfigurableForm.this.myProject, ExcludedPathsConfigurableForm.this.myContentPane);
                            }
                        };
                        this.myComponent = new CellEditorComponentWithBrowseButton((ComponentWithBrowseButton)new TextFieldWithBrowseButton.NoPathCompletion(listener), (TableCellEditor)((Object)this));
                    }
                    ((JTextField)this.myComponent.getChildComponent()).setText((String)value);
                    return this.myComponent;
                }
            };
        }
    }
}

