/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.config.mappings;

import com.intellij.ProjectTopics;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ChangesTrackingTableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.LocalPathCellEditor;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.ServerBrowserDialog;
import com.jetbrains.plugins.webDeployment.ui.WarningIconCellRenderer;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableTab;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableTabProvider;
import com.jetbrains.plugins.webDeployment.ui.config.SettingsDeployable;
import com.jetbrains.plugins.webDeployment.ui.config.SharedDataHolder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MappingsConfigurableForm
implements Disposable {
    private JPanel myContentPane;
    private TableView<DeploymentPathMapping> myPathsTable;
    private JLabel myMessageLabel;
    private HyperlinkLabel myFixLink;
    private MultiLineLabel myLegendLabel;
    private JButton myUseAsDefaultButton;
    private JPanel myComplexViewPanel;
    private JPanel mySimpleViewPanel;
    private JTextField myWebPathField;
    private HoverHyperlinkLabel myUrlLabel;
    private TextFieldWithBrowseButton myLocalPathField;
    private TextFieldWithBrowseButton myDeployPathField;
    private JLabel myLocalPathLabel;
    private JLabel myDeployPathLabel;
    private JLabel myWebPathLabel;
    private JButton myAddAnotherMappingButton;
    private JPanel myTablePanel;
    private List<DeploymentPathMapping> myPathMappings;
    private final Project myProject;
    private final Map<DeploymentPathMapping, String> myWarnings;
    @Nullable
    private Runnable myFixRunnable;
    private final DeploymentConfigurableTabProvider.ServerStateProvider myServerStateProvider;
    private final SharedDataHolder mySharedData;

    @NotNull
    private static Comparator<DeploymentPathMapping> createComparator(ColumnInfo<DeploymentPathMapping, String> column) {
        Comparator comparator = (o1, o2) -> StringUtil.compare((String)((String)column.valueOf(o1)), (String)((String)column.valueOf(o2)), (boolean)false);
        if (comparator == null) {
            MappingsConfigurableForm.$$$reportNull$$$0(0);
        }
        return comparator;
    }

    private void createUIComponents() {
        this.myPathsTable = new ChangesTrackingTableView<DeploymentPathMapping>(){

            protected void onCellValueChanged(int row, int column, Object value) {
                DeploymentPathMapping mapping = (DeploymentPathMapping)MappingsConfigurableForm.this.myPathMappings.get(row);
                DeploymentPathMapping override = mapping.clone();
                ColumnInfo columnInfo = ((ListTableModel)MappingsConfigurableForm.this.myPathsTable.getModel()).getColumnInfos()[column];
                ((SetterColumn)columnInfo).doSetValue(override, (String)value);
                MappingsConfigurableForm.this.updateMessage(mapping, override);
            }

            protected void onEditingStopped() {
                MappingsConfigurableForm.this.updateMessage(null, null);
            }
        };
        this.myPathsTable.setRowHeight(Math.max(UIUtil.getBalloonWarningIcon().getIconHeight() + 2, new JTextField().getPreferredSize().height));
        this.myTablePanel = ToolbarDecorator.createDecorator(this.myPathsTable).setAddAction(button -> this.addMapping()).setRemoveAction(button -> {
            this.myPathsTable.stopEditing();
            int minSelectedIndex = this.myPathsTable.getSelectionModel().getMinSelectionIndex();
            if (minSelectedIndex == -1) {
                return;
            }
            int[] selectedIndices = this.myPathsTable.getSelectedRows();
            NavigableSet<Integer> modelIndices = new TreeSet();
            for (int selectedIndex : selectedIndices) {
                int modelIndex = this.myPathsTable.convertRowIndexToModel(selectedIndex);
                modelIndices.add(modelIndex);
            }
            modelIndices = modelIndices.descendingSet();
            ListTableModel model = this.myPathsTable.getListTableModel();
            for (Integer entry : modelIndices) {
                model.removeRow(entry.intValue());
            }
            this.updateUi();
            int index = Math.min(minSelectedIndex, this.myPathsTable.getRowCount() - 1);
            if (index != -1) {
                this.myPathsTable.setRowSelectionInterval(index, index);
            }
        }).disableUpDownActions().createPanel();
        this.myUrlLabel = new HoverHyperlinkLabel(null);
    }

    public MappingsConfigurableForm(Project project, DeploymentConfigurableTabProvider.ServerStateProvider serverStateProvider, SharedDataHolder sharedData, Disposable parentDisposable) {
        this.$$$setupUI$$$();
        this.myWarnings = new HashMap<DeploymentPathMapping, String>();
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myProject = project;
        this.myServerStateProvider = serverStateProvider;
        this.mySharedData = sharedData;
        this.mySharedData.addDefaultServerListener(e -> this.updateUseAsDefaultButton(), this);
        project.getMessageBus().connect((Disposable)project).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                if (MappingsConfigurableForm.this.myPathMappings == null) {
                    return;
                }
                MappingsConfigurableForm.this.updateMessage(null, null);
            }
        });
        this.myServerStateProvider.addListener(e -> {
            SettingsDeployable state = (SettingsDeployable)this.myServerStateProvider.compute();
            Pair<String, String> defaultServer = this.mySharedData.getDefaultServerIdAndName();
            if (StringUtil.equals((CharSequence)state.getId(), (CharSequence)((CharSequence)defaultServer.first))) {
                this.mySharedData.setDefaultServer(state.getId(), state.getName());
            }
            this.updateLegend(state);
            this.updateUi();
        }, this);
        this.myFixLink.setHyperlinkText(WDBundle.message("fix", new Object[0]));
        this.myFixLink.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && this.myFixRunnable != null) {
                this.myFixRunnable.run();
            }
        });
        this.myMessageLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.myUseAsDefaultButton.addActionListener(e -> {
            this.mySharedData.setDefaultServer(this.myServerStateProvider.getServerId(), this.myServerStateProvider.getServerName());
            this.updateUseAsDefaultButton();
        });
        this.myLocalPathLabel.setLabelFor((Component)this.myLocalPathField);
        this.myDeployPathLabel.setLabelFor((Component)this.myDeployPathField);
        this.myLocalPathField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent documentEvent) {
                if (MappingsConfigurableForm.this.myPathMappings.isEmpty()) {
                    MappingsConfigurableForm.this.myPathMappings.add(new DeploymentPathMapping());
                }
                ((DeploymentPathMapping)MappingsConfigurableForm.this.myPathMappings.get(0)).setLocalPath(MappingsConfigurableForm.this.myLocalPathField.getText());
                MappingsConfigurableForm.this.updateMessage(null, null);
            }
        });
        this.myDeployPathField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent documentEvent) {
                if (MappingsConfigurableForm.this.myPathMappings.isEmpty()) {
                    MappingsConfigurableForm.this.myPathMappings.add(new DeploymentPathMapping());
                }
                ((DeploymentPathMapping)MappingsConfigurableForm.this.myPathMappings.get(0)).setDeployPath(MappingsConfigurableForm.this.myDeployPathField.getText());
                MappingsConfigurableForm.this.updateMessage(null, null);
            }
        });
        this.myWebPathField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent documentEvent) {
                if (MappingsConfigurableForm.this.myPathMappings.isEmpty()) {
                    MappingsConfigurableForm.this.myPathMappings.add(new DeploymentPathMapping());
                }
                ((DeploymentPathMapping)MappingsConfigurableForm.this.myPathMappings.get(0)).setWebPath(MappingsConfigurableForm.this.myWebPathField.getText());
                MappingsConfigurableForm.this.updateMessage(null, null);
                MappingsConfigurableForm.this.updateUrl();
            }
        });
        this.myUrlLabel.addHyperlinkListener(e -> BrowserUtil.browse((String)this.myUrlLabel.getOriginalText()));
        this.myAddAnotherMappingButton.addActionListener(e -> this.addMapping());
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.myLocalPathField.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener(null, "", (ComponentWithBrowseButton)this.myLocalPathField, this.myProject, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT));
        this.myDeployPathField.addActionListener(e -> MappingsConfigurableForm.chooseRemotePath(this.myDeployPathField.getTextField(), true, WDBundle.message("choose.deployment.path", new Object[0]), this.myServerStateProvider, this.myProject, this.myContentPane));
    }

    private void addMapping() {
        this.myPathMappings.add(new DeploymentPathMapping());
        if (this.myPathMappings.size() == 1) {
            this.myPathMappings.add(new DeploymentPathMapping());
        }
        this.updateUi();
        if (this.myPathMappings.size() >= 2) {
            int row = this.myPathMappings.size() - 1;
            this.myPathsTable.getSelectionModel().setSelectionInterval(row, row);
            this.myPathsTable.scrollRectToVisible(this.myPathsTable.getCellRect(row, 0, true));
            if (StringUtil.isEmpty((String)this.myPathMappings.get(0).getLocalPath())) {
                this.myPathsTable.editCellAt(0, 1);
            } else {
                this.myPathsTable.editCellAt(row, 1);
            }
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus(this.myPathsTable.getEditorComponent(), true);
        }
    }

    private void updateUrl() {
        String url = DeploymentPathUtils.joinWebPath(((SettingsDeployable)this.myServerStateProvider.compute()).getUrl(), this.myWebPathField.getText());
        this.myUrlLabel.setText(url);
    }

    public void addItemPresentationChangeListener(DeploymentConfigurableTab.ItemPresentationChangeListener listener, Disposable parentDisposable) {
        this.mySharedData.addDefaultServerListener(e -> listener.presentationChanged(this.mySharedData.getDefaultServerIdAndName().first == this.myServerStateProvider.getServerId()), parentDisposable);
    }

    private void updateUi() {
        SettingsDeployable server = (SettingsDeployable)this.myServerStateProvider.compute();
        String serverName = this.myServerStateProvider.getServerName();
        if (this.myPathMappings.size() < 2) {
            this.mySimpleViewPanel.setVisible(true);
            this.myComplexViewPanel.setVisible(false);
            if (server != null && server.needsTransfer()) {
                this.myDeployPathLabel.setVisible(true);
                this.myDeployPathField.setVisible(true);
                String text = server.getAccessType() == AccessType.MOUNT ? WDBundle.message("mappings.deploy.path.label.mounted", StringUtil.isNotEmpty((String)serverName) ? "'" + serverName + "'" : "", FileUtil.toSystemDependentName((String)server.getMountedFolder())) : WDBundle.message("mappings.deploy.path.label.protocolbased", StringUtil.isNotEmpty((String)serverName) ? "'" + serverName + "'" : "");
                this.myDeployPathLabel.setText(text);
            } else {
                this.myDeployPathLabel.setVisible(false);
                this.myDeployPathField.setVisible(false);
            }
            this.myLocalPathField.setText(this.myPathMappings.isEmpty() ? null : this.myPathMappings.get(0).getLocalPath());
            this.myDeployPathField.setText(this.myPathMappings.isEmpty() ? null : this.myPathMappings.get(0).getDeployPath());
            this.myWebPathLabel.setText(WDBundle.message("mappings.web.path.label", StringUtil.isNotEmpty((String)serverName) ? "'" + serverName + "'" : ""));
            this.myWebPathField.setText(this.myPathMappings.isEmpty() ? null : this.myPathMappings.get(0).getWebPath());
            this.updateUrl();
            this.updateMessage(null, null);
        } else {
            if (this.myPathsTable.isEditing()) {
                this.myPathsTable.stopEditing();
            }
            this.mySimpleViewPanel.setVisible(false);
            this.myComplexViewPanel.setVisible(true);
            ColumnInfo[] columns = server != null && !server.needsTransfer() ? new ColumnInfo[]{new IconColumn(), new LocalPathColumn(), new WebPathColumn()} : new ColumnInfo[]{new IconColumn(), new LocalPathColumn(), new DeployPathColumn(), new WebPathColumn()};
            this.myPathsTable.setModelAndUpdateColumns(new ListTableModel(columns, this.myPathMappings, -1));
            this.updateMessage(null, null);
        }
    }

    public JComponent getContentPane() {
        return this.myContentPane;
    }

    public boolean isModified() {
        List<DeploymentPathMapping> configMappings;
        if (this.myPathsTable.getCellEditor() != null) {
            DeploymentPathMapping original = this.myPathMappings.get(this.myPathsTable.getEditingRow());
            DeploymentPathMapping override = original.clone();
            ColumnInfo columnInfo = ((ListTableModel)this.myPathsTable.getModel()).getColumnInfos()[this.myPathsTable.getEditingColumn()];
            ((SetterColumn)columnInfo).doSetValue(override, (String)this.myPathsTable.getCellEditor().getCellEditorValue());
            if (!original.equals(override)) {
                return true;
            }
        }
        if ((configMappings = this.mySharedData.getMappings().get(this.myServerStateProvider.getServerId())).size() != this.myPathMappings.size()) {
            return true;
        }
        for (int i = 0; i < this.myPathMappings.size(); ++i) {
            if (this.myPathMappings.get(i).equals(configMappings.get(i))) continue;
            return true;
        }
        return false;
    }

    public void apply() {
        this.applyTo(this.myServerStateProvider.getServerId());
    }

    public void applyTo(SettingsDeployable server) {
        this.applyTo(server.getId());
    }

    public void applyTo(String serverId) {
        this.myPathsTable.stopEditing();
        this.mySharedData.getMappings().put(serverId, PublishConfig.cloneMappings(this.myPathMappings, false));
    }

    public void reset() {
        this.myPathsTable.stopEditing();
        List<DeploymentPathMapping> mappings = this.mySharedData.getMappings().get(this.myServerStateProvider.getServerId());
        this.myPathMappings = PublishConfig.cloneMappings(mappings, false);
        this.updateUseAsDefaultButton();
        this.updateUi();
        this.updateLegend((SettingsDeployable)this.myServerStateProvider.compute());
    }

    private void updateUseAsDefaultButton() {
        this.myUseAsDefaultButton.setEnabled(this.mySharedData.getDefaultServerIdAndName().first != this.myServerStateProvider.getServerId());
    }

    private void updateLegend(@Nullable SettingsDeployable server) {
        String deployPathText;
        String accessType;
        String url;
        String host = server != null ? server.getHost() : null;
        String rootFolder = server != null ? server.getRootFolder() : null;
        String string = url = server != null ? server.getUrl() : null;
        if (server != null) {
            accessType = server.getAccessType().getTitle();
        } else {
            StringBuilder sb = new StringBuilder();
            for (AccessType p : AccessType.values()) {
                if (sb.length() > 0) {
                    sb.append("/");
                }
                sb.append(p.getTitle());
            }
            accessType = sb.toString();
        }
        if (server != null) {
            if (server.needsTransfer()) {
                if (server.getAccessType().isProtocolBased()) {
                    deployPathText = WDBundle.message("legend.deploy.path.text.remote", accessType, StringUtil.isNotEmpty((String)host) ? " '" + host + rootFolder + "'" : "");
                } else {
                    String mounted = server.getMountedFolder();
                    deployPathText = WDBundle.message("legend.deploy.path.text.mounted", StringUtil.isNotEmpty((String)mounted) ? " '" + mounted + "'" : "");
                }
            } else {
                deployPathText = "";
            }
        } else {
            deployPathText = WDBundle.message("legend.deploy.path.text.no.server", new Object[0]);
        }
        this.myLegendLabel.setText(WDBundle.message("legend.text", deployPathText, StringUtil.isNotEmpty((String)url) && !"http://".equals(url) ? ": " + url : ""));
    }

    private void updateMessage(@Nullable DeploymentPathMapping mapping, @Nullable DeploymentPathMapping override) {
        Pair<String, Runnable> messageAndFix = this.validate(mapping, override);
        if (messageAndFix != null) {
            this.myMessageLabel.setText((String)messageAndFix.first);
            this.myMessageLabel.setVisible(true);
            this.myFixRunnable = (Runnable)messageAndFix.second;
            this.myFixLink.setVisible(this.myFixRunnable != null);
        } else {
            this.myMessageLabel.setVisible(false);
            this.myFixLink.setVisible(false);
            this.myFixRunnable = null;
        }
        this.myPathsTable.repaint();
    }

    @Nullable
    private Pair<String, Runnable> validate(@Nullable DeploymentPathMapping original, @Nullable DeploymentPathMapping override) {
        if (this.myPathMappings == null || this.myProject.isDisposed()) {
            return null;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        HashSet<String> unmappedContentRoots = new HashSet<String>();
        for (VirtualFile contentRoot : ProjectRootManager.getInstance((Project)this.myProject).getContentRoots()) {
            unmappedContentRoots.add(contentRoot.getPresentableUrl());
        }
        SettingsDeployable server = (SettingsDeployable)this.myServerStateProvider.compute();
        HashMap<String, DeploymentPathMapping> existing = new HashMap<String, DeploymentPathMapping>();
        String mappingsMessage = null;
        List<DeploymentPathMapping> mappingsToValidate = this.myPathMappings.isEmpty() ? Collections.singletonList(new DeploymentPathMapping()) : this.myPathMappings;
        for (DeploymentPathMapping pathMapping : mappingsToValidate) {
            DeploymentPathMapping existingMapping;
            DeploymentPathMapping effective = pathMapping == original ? override : pathMapping;
            String message = MappingsConfigurableForm.validate(server, effective, index, unmappedContentRoots, mappingsToValidate.size() == 1);
            this.myWarnings.put(pathMapping, message);
            if (mappingsMessage == null) {
                mappingsMessage = message;
            }
            if (!StringUtil.isNotEmpty((String)effective.getLocalPath())) continue;
            String localPath = effective.getPresentableLocalPath();
            if (!SystemInfo.isFileSystemCaseSensitive) {
                localPath = localPath.toLowerCase();
            }
            if ((existingMapping = existing.put(localPath, pathMapping)) == null) continue;
            if (this.myWarnings.get(existingMapping) == null) {
                this.myWarnings.put(existingMapping, WDBundle.message("duplicate.local.path", new Object[0]));
            }
            if (this.myWarnings.get(pathMapping) != null) continue;
            this.myWarnings.put(pathMapping, WDBundle.message("duplicate.local.path", new Object[0]));
        }
        if (mappingsMessage != null) {
            return Pair.create(mappingsMessage, null);
        }
        if (!unmappedContentRoots.isEmpty()) {
            Runnable fix = () -> {
                if (this.myPathsTable.isEditing()) {
                    this.myPathsTable.stopEditing();
                }
                ArrayList<DeploymentPathMapping> missingMappings = new ArrayList<DeploymentPathMapping>(unmappedContentRoots.size());
                for (String contentRoot : unmappedContentRoots) {
                    DeploymentPathMapping mapping = new DeploymentPathMapping();
                    mapping.setLocalPath(contentRoot);
                    missingMappings.add(mapping);
                }
                this.myPathMappings.addAll(missingMappings);
                this.updateUi();
            };
            String message = unmappedContentRoots.size() == 1 ? WDBundle.message("content.root.is.not.mapped", unmappedContentRoots.iterator().next()) : WDBundle.message("content.roots.are.not.mapped", new Object[0]);
            return Pair.create((Object)message, (Object)fix);
        }
        return null;
    }

    @Nullable
    private static String validate(SettingsDeployable server, DeploymentPathMapping pathMapping, @NotNull ProjectFileIndex index, @Nullable Set<String> unmappedContentRoots, boolean single) {
        if (index == null) {
            MappingsConfigurableForm.$$$reportNull$$$0(1);
        }
        if (StringUtil.isEmpty((String)pathMapping.getLocalPath())) {
            return WDBundle.message("local.path.is.empty", new Object[0]);
        }
        if (PublishUtils.needsTransfer(server.getAccessType())) {
            if (StringUtil.isEmpty((String)pathMapping.getDeployPath())) {
                if (single) {
                    return WDBundle.message("deploy.path.is.empty", new Object[0]);
                }
                return WDBundle.message("deploy.path.is.empty.for", pathMapping.getPresentableLocalPath());
            }
            String s = DeploymentPathMapping.validateDeployPath(pathMapping.getDeployPath(), server.getAccessType().isProtocolBased());
            if (s != null) {
                return s;
            }
        }
        if (StringUtil.isEmpty((String)pathMapping.getWebPath())) {
            if (single) {
                return WDBundle.message("web.path.is.empty", new Object[0]);
            }
            return WDBundle.message("web.path.is.empty.for", pathMapping.getPresentableLocalPath());
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(pathMapping.getPresentableLocalPath());
        if (file == null) {
            return WDBundle.message("local.item.not.found", pathMapping.getPresentableLocalPath());
        }
        VirtualFile contentRoot = index.getContentRootForFile(file);
        if (contentRoot == null) {
            return WDBundle.message("item.is.out.of.project", pathMapping.getPresentableLocalPath());
        }
        if (unmappedContentRoots != null) {
            unmappedContentRoots.remove(contentRoot.getPresentableUrl());
        }
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.myPathMappings.size() > 1) {
            return this.myPathsTable;
        }
        if (StringUtil.isEmpty((String)this.myLocalPathField.getText())) {
            return this.myLocalPathField.getTextField();
        }
        if (StringUtil.isEmpty((String)this.myDeployPathField.getText())) {
            return this.myDeployPathField.getTextField();
        }
        if (StringUtil.isEmpty((String)this.myWebPathField.getText())) {
            return this.myWebPathField;
        }
        return this.myLocalPathField.getTextField();
    }

    public void dispose() {
    }

    public static void chooseRemotePath(JTextField textField, boolean foldersOnly, String title, DeploymentConfigurableTabProvider.ServerStateProvider serverStateProvider, Project project, JPanel contentPane) {
        SettingsDeployable server = (SettingsDeployable)serverStateProvider.compute();
        String error = server.validateFastInternal();
        if (error != null) {
            Messages.showErrorDialog((Component)contentPane, (String)WDBundle.message("server.invalid", serverStateProvider.getServerName(), error));
            return;
        }
        if (server.getAccessType().isProtocolBased()) {
            WebServerConfig.RemotePath path;
            WebServerConfig.RemotePath initialPath = new WebServerConfig.RemotePath(textField.getText());
            ServerBrowserDialog d = new ServerBrowserDialog(project, (Deployable)server, title, foldersOnly, FileTransferConfig.Origin.Default, initialPath);
            d.show();
            serverStateProvider.updatePassword(server);
            if (d.isOK() && (path = d.getPath()) != null) {
                textField.setText(path.path);
            }
        } else {
            VirtualFile file;
            final Ref mountedRoot = new Ref();
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> mountedRoot.set((Object)LocalFileSystem.getInstance().findFileByPath(server.getMountedFolder())), WDBundle.message("resolving.mounted.root", new Object[0]), false, project);
            if (mountedRoot.isNull() || !((VirtualFile)mountedRoot.get()).isValid()) {
                Messages.showErrorDialog((Component)contentPane, (String)WDBundle.message("mounted.folder.not.found", FileUtil.toSystemDependentName((String)server.getMountedFolder())));
                return;
            }
            FileChooserDescriptor d = new FileChooserDescriptor(false, true, false, true, false, false){

                public boolean isFileSelectable(VirtualFile file) {
                    return VfsUtilCore.isAncestor((VirtualFile)((VirtualFile)mountedRoot.get()), (VirtualFile)file, (boolean)false);
                }
            };
            d.setTitle(title);
            String relativePath = textField.getText();
            VirtualFile initialFile = VirtualFileManager.getInstance().findFileByUrl(((VirtualFile)mountedRoot.get()).getUrl() + "/" + relativePath);
            if (initialFile == null) {
                initialFile = (VirtualFile)mountedRoot.get();
            }
            if ((file = FileChooser.chooseFile((FileChooserDescriptor)d, (Component)textField, (Project)project, (VirtualFile)initialFile)) != null) {
                if (!d.isFileSelectable(file)) {
                    Messages.showWarningDialog((Project)project, (String)WDBundle.message("deployment.path.0.is.out.of.root.folder.1", file.getPath(), ((VirtualFile)mountedRoot.get()).getPath()), (String)WDBundle.message("deploy.path.column.name", new Object[0]));
                    return;
                }
                String newRelativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)((VirtualFile)mountedRoot.get()), (char)File.separatorChar);
                if (newRelativePath.length() == 0) {
                    newRelativePath = File.separator;
                }
                textField.setText(newRelativePath);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/config/mappings/MappingsConfigurableForm";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createComparator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/config/mappings/MappingsConfigurableForm";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JLabel jLabel;
        JTextField jTextField;
        JLabel jLabel2;
        JLabel jLabel3;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        MultiLineLabel multiLineLabel;
        JPanel jPanel2;
        JButton jButton2;
        HyperlinkLabel hyperlinkLabel;
        JLabel jLabel4;
        JPanel jPanel3;
        this.createUIComponents();
        this.myContentPane = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myMessageLabel = jLabel4 = new JLabel();
        jLabel4.setText("Label");
        jPanel4.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myFixLink = hyperlinkLabel = new HyperlinkLabel();
        jPanel4.add((Component)hyperlinkLabel, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myUseAsDefaultButton = jButton2 = new JButton();
        jButton2.setText("Use this server as default");
        jButton2.setMnemonic('U');
        jButton2.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myComplexViewPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myLegendLabel = multiLineLabel = new MultiLineLabel();
        multiLineLabel.setText("legend");
        jPanel2.add((Component)multiLineLabel, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        JPanel jPanel5 = this.myTablePanel;
        jPanel2.add((Component)jPanel5, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Paths:");
        jLabel5.setDisplayedMnemonic('P');
        jLabel5.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(478, 14), null));
        this.mySimpleViewPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(12, 3, new Insets(0, 0, 0, 0), 0, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myLocalPathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 0, 1, 3, 0, 1, 3, 3, null, null, null));
        this.myDeployPathLabel = jLabel3 = new JLabel();
        jLabel3.setText("Deployment path on server:");
        jLabel3.setDisplayedMnemonic('E');
        jLabel3.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jLabel3, new GridConstraints(4, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myWebPathLabel = jLabel2 = new JLabel();
        jLabel2.setText("Web path on server (open in browser):");
        jLabel2.setDisplayedMnemonic('W');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel2, new GridConstraints(7, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        TextFieldWithBrowseButton.NoPathCompletion noPathCompletion = new TextFieldWithBrowseButton.NoPathCompletion();
        this.myDeployPathField = noPathCompletion;
        jPanel.add((Component)noPathCompletion, new GridConstraints(5, 0, 1, 3, 0, 1, 3, 3, null, null, null));
        this.myWebPathField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(8, 0, 1, 3, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        HoverHyperlinkLabel hoverHyperlinkLabel = this.myUrlLabel;
        hoverHyperlinkLabel.setText("http://");
        jPanel.add((Component)hoverHyperlinkLabel, new GridConstraints(9, 1, 1, 1, 8, 0, 3, 3, null, null, null, 1));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Project URL:");
        jPanel.add((Component)jLabel6, new GridConstraints(9, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLocalPathLabel = jLabel = new JLabel();
        jLabel.setText("Local path:");
        jLabel.setDisplayedMnemonic('L');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(9, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(6, 2, 1, 1, 1, 0, 1, 0, null, new Dimension(-1, 5), null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(3, 2, 1, 1, 1, 0, 1, 0, null, new Dimension(-1, 5), null));
        Spacer spacer5 = new Spacer();
        jPanel.add((Component)spacer5, new GridConstraints(0, 2, 1, 1, 1, 0, 1, 0, null, new Dimension(-1, 5), null));
        this.myAddAnotherMappingButton = jButton = new JButton();
        jButton.setText("Add another mapping");
        jButton.setMnemonic('D');
        jButton.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jButton, new GridConstraints(10, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel3.add((Component)spacer6, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel2.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private class WebPathColumn
    extends ColumnInfo<DeploymentPathMapping, String>
    implements SetterColumn {
        private final Comparator<DeploymentPathMapping> COMPARATOR;

        private WebPathColumn() {
            super(WDBundle.message("web.path.column.name", new Object[0]));
            this.COMPARATOR = MappingsConfigurableForm.createComparator((ColumnInfo<DeploymentPathMapping, String>)this);
        }

        public String valueOf(DeploymentPathMapping item) {
            return item.getWebPath();
        }

        public boolean isCellEditable(DeploymentPathMapping item) {
            return true;
        }

        public void setValue(DeploymentPathMapping item, String value) {
            this.doSetValue(item, value);
            MappingsConfigurableForm.this.updateMessage(null, null);
        }

        @Override
        public void doSetValue(DeploymentPathMapping item, String value) {
            item.setWebPath(value);
        }

        public TableCellEditor getEditor(DeploymentPathMapping pathMapping) {
            return new AbstractTableCellEditor(){
                JTextField myComponent;

                public Object getCellEditorValue() {
                    return this.myComponent.getText();
                }

                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    this.myComponent = new JTextField();
                    this.myComponent.setText((String)value);
                    return this.myComponent;
                }
            };
        }

        @Nullable
        public Comparator<DeploymentPathMapping> getComparator() {
            return this.COMPARATOR;
        }
    }

    private class DeployPathColumn
    extends ColumnInfo<DeploymentPathMapping, String>
    implements SetterColumn {
        private final Comparator<DeploymentPathMapping> COMPARATOR;

        private DeployPathColumn() {
            super(WDBundle.message("deploy.path.column.name", new Object[0]));
            this.COMPARATOR = MappingsConfigurableForm.createComparator((ColumnInfo<DeploymentPathMapping, String>)this);
        }

        public String valueOf(DeploymentPathMapping item) {
            return item.getDeployPath();
        }

        public boolean isCellEditable(DeploymentPathMapping item) {
            return true;
        }

        public void setValue(DeploymentPathMapping item, String value) {
            this.doSetValue(item, value);
            MappingsConfigurableForm.this.updateMessage(null, null);
        }

        @Override
        public void doSetValue(DeploymentPathMapping item, String value) {
            item.setDeployPath(value);
        }

        public TableCellEditor getEditor(DeploymentPathMapping pathMapping) {
            return new LocalPathCellEditor(MappingsConfigurableForm.this.myProject){

                protected ActionListener createActionListener(JTable table) {
                    return e -> MappingsConfigurableForm.chooseRemotePath((JTextField)this.myComponent.getChildComponent(), true, WDBundle.message("choose.deployment.path", new Object[0]), MappingsConfigurableForm.this.myServerStateProvider, MappingsConfigurableForm.this.myProject, MappingsConfigurableForm.this.myContentPane);
                }
            };
        }

        @Nullable
        public Comparator<DeploymentPathMapping> getComparator() {
            return this.COMPARATOR;
        }
    }

    private class LocalPathColumn
    extends ColumnInfo<DeploymentPathMapping, String>
    implements SetterColumn {
        private final Comparator<DeploymentPathMapping> COMPARATOR;

        public LocalPathColumn() {
            super(WDBundle.message("local.path.column.name", new Object[0]));
            this.COMPARATOR = MappingsConfigurableForm.createComparator((ColumnInfo<DeploymentPathMapping, String>)this);
        }

        public String valueOf(DeploymentPathMapping item) {
            return item.getLocalPath();
        }

        public boolean isCellEditable(DeploymentPathMapping item) {
            return true;
        }

        public void setValue(DeploymentPathMapping item, String value) {
            this.doSetValue(item, value);
            MappingsConfigurableForm.this.updateMessage(null, null);
        }

        @Override
        public void doSetValue(DeploymentPathMapping item, String value) {
            item.setLocalPath(value);
        }

        public TableCellEditor getEditor(DeploymentPathMapping pathMapping) {
            return new LocalPathCellEditor(WDBundle.message("mappings.choose.local.path.title", new Object[0]), MappingsConfigurableForm.this.myProject);
        }

        @Nullable
        public Comparator<DeploymentPathMapping> getComparator() {
            return this.COMPARATOR;
        }
    }

    private class IconColumn
    extends ColumnInfo<DeploymentPathMapping, Object> {
        public IconColumn() {
            super(" ");
        }

        public String valueOf(DeploymentPathMapping item) {
            return null;
        }

        public int getWidth(JTable table) {
            return UIUtil.getBalloonWarningIcon().getIconWidth() + 2;
        }

        public TableCellRenderer getRenderer(DeploymentPathMapping pathMapping) {
            return new WarningIconCellRenderer((NullableComputable<String>)((NullableComputable)() -> (String)MappingsConfigurableForm.this.myWarnings.get(pathMapping)));
        }
    }

    private static interface SetterColumn {
        public void doSetValue(DeploymentPathMapping var1, String var2);
    }
}

