/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.groovy;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;

public class GroovycOutputParser {
    private static final String GROOVY_COMPILER_IN_OPERATION = "Groovy compiler in operation...";
    public static final String GRAPE_ROOT = "grape.root";
    private final List<OutputItem> myCompiledItems = new ArrayList<OutputItem>();
    private final List<CompilerMessage> compilerMessages = new ArrayList<CompilerMessage>();
    private final StringBuffer stdErr = new StringBuffer();
    private final ModuleChunk myChunk;
    private final CompileContext myContext;
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.groovy.GroovycOSProcessHandler");
    private int myExitCode;
    private final StringBuffer outputBuffer = new StringBuffer();

    public GroovycOutputParser(ModuleChunk chunk, CompileContext context) {
        this.myChunk = chunk;
        this.myContext = context;
    }

    public void notifyTextAvailable(String text, Key outputType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received from groovyc " + outputType + ": " + text);
        }
        if (outputType == ProcessOutputTypes.SYSTEM) {
            return;
        }
        if (outputType == ProcessOutputTypes.STDERR && !GroovycOutputParser.isSafeStderr(text)) {
            this.stdErr.append(StringUtil.convertLineSeparators((String)text));
            return;
        }
        this.parseOutput(text);
    }

    private static boolean isSafeStderr(String line) {
        return line.startsWith("SLF4J:") || line.startsWith("Picked up JAVA_TOOL_OPTIONS");
    }

    private void updateStatus(@NotNull String status) {
        if (status == null) {
            GroovycOutputParser.$$$reportNull$$$0(0);
        }
        this.myContext.processMessage((BuildMessage)new ProgressMessage(status + " [" + this.myChunk.getPresentableShortName() + "]"));
    }

    private void parseOutput(String text) {
        String trimmed = text.trim();
        if (trimmed.startsWith("@#$%@# Presentable:")) {
            this.updateStatus(trimmed.substring("@#$%@# Presentable:".length()));
            return;
        }
        if ("$@#$%^ CLEAR_PRESENTABLE".equals(trimmed)) {
            this.updateStatus(GROOVY_COMPILER_IN_OPERATION);
            return;
        }
        if (StringUtil.isNotEmpty((String)text)) {
            this.outputBuffer.append(text);
            if (this.outputBuffer.indexOf("%%c") != -1) {
                if (this.outputBuffer.indexOf("/%c") == -1) {
                    return;
                }
                String compiled = this.handleOutputBuffer("%%c", "/%c");
                List<String> list = GroovycOutputParser.splitAndTrim(compiled);
                String outputPath = list.get(0);
                String sourceFile = list.get(1);
                OutputItem item = new OutputItem(outputPath, sourceFile);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Output: " + item);
                }
                this.myCompiledItems.add(item);
            } else if (this.outputBuffer.indexOf("%%m") != -1) {
                BuildMessage.Kind kind;
                int columnInt;
                int lineInt;
                if (this.outputBuffer.indexOf("/%m") == -1) {
                    return;
                }
                text = this.handleOutputBuffer("%%m", "/%m");
                List<String> tokens = GroovycOutputParser.splitAndTrim(text);
                LOG.assertTrue(tokens.size() > 4, (Object)"Wrong number of output params");
                String category = tokens.get(0);
                String message = tokens.get(1);
                String url = tokens.get(2);
                String lineNum = tokens.get(3);
                String columnNum = tokens.get(4);
                try {
                    lineInt = Integer.parseInt(lineNum);
                    columnInt = Integer.parseInt(columnNum);
                }
                catch (NumberFormatException e) {
                    LOG.error((Throwable)e);
                    lineInt = 0;
                    columnInt = 0;
                }
                BuildMessage.Kind kind2 = category.equals("error") ? BuildMessage.Kind.ERROR : (kind = category.equals("warning") ? BuildMessage.Kind.WARNING : BuildMessage.Kind.INFO);
                if (StringUtil.isEmpty((String)url) || "null".equals(url)) {
                    url = null;
                    message = "While compiling " + this.myChunk.getPresentableShortName() + ": " + message;
                }
                CompilerMessage compilerMessage = new CompilerMessage("Groovyc", kind, message, url, -1L, -1L, -1L, (long)lineInt, (long)columnInt);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Message: " + compilerMessage);
                }
                this.addCompilerMessage(compilerMessage);
            }
        }
    }

    void addCompilerMessage(CompilerMessage compilerMessage) {
        this.compilerMessages.add(compilerMessage);
    }

    private String handleOutputBuffer(String startMarker, String endMarker) {
        int end;
        int start = this.outputBuffer.indexOf(startMarker);
        if (start > (end = this.outputBuffer.indexOf(endMarker))) {
            throw new AssertionError((Object)("Malformed Groovyc output: " + this.outputBuffer.toString()));
        }
        String text = this.outputBuffer.substring(start + startMarker.length(), end);
        this.outputBuffer.delete(start, end + endMarker.length());
        return text.trim();
    }

    private static List<String> splitAndTrim(String compiled) {
        return ContainerUtil.map((Collection)StringUtil.split((String)compiled, (String)"#%%#%%%#%%%%%%%%%#"), s -> s.trim());
    }

    public List<OutputItem> getSuccessfullyCompiled() {
        return this.myCompiledItems;
    }

    public boolean shouldRetry() {
        for (CompilerMessage message : this.compilerMessages) {
            String text = message.getMessageText();
            if (!text.contains("java.lang.NoClassDefFoundError") && !text.contains("java.lang.TypeNotPresentException") && !text.contains("unable to resolve class")) continue;
            LOG.debug("Resolve issue: " + message);
            return true;
        }
        return false;
    }

    public List<CompilerMessage> getCompilerMessages() {
        ArrayList<CompilerMessage> messages = new ArrayList<CompilerMessage>(this.compilerMessages);
        StringBuffer unparsedBuffer = this.getStdErr();
        if (unparsedBuffer.length() != 0) {
            String msg = unparsedBuffer.toString();
            if (msg.contains("Cannot compile Groovy files: no Groovy library is defined")) {
                messages.add(this.reportNoGroovy());
            } else {
                messages.add(new CompilerMessage("Groovyc", BuildMessage.Kind.INFO, "While compiling " + this.myChunk.getPresentableShortName() + ":" + msg));
            }
        }
        if (this.myExitCode != 0) {
            for (CompilerMessage message : messages) {
                if (message.getKind() != BuildMessage.Kind.ERROR) continue;
                return messages;
            }
            messages.add(new CompilerMessage("Groovyc", BuildMessage.Kind.ERROR, "Internal groovyc error: code " + this.myExitCode));
        }
        return messages;
    }

    @NotNull
    CompilerMessage reportNoGroovy() {
        String moduleName = this.myChunk.representativeTarget().getModule().getName();
        CompilerMessage compilerMessage = new CompilerMessage("", BuildMessage.Kind.ERROR, "Cannot compile Groovy files: no Groovy library is defined for module '" + moduleName + "'");
        if (compilerMessage == null) {
            GroovycOutputParser.$$$reportNull$$$0(1);
        }
        return compilerMessage;
    }

    public StringBuffer getStdErr() {
        return this.stdErr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File fillFileWithGroovycParameters(String outputDir, Collection<String> changedSources, Collection<String> finalOutputs, Map<String, String> class2Src, @Nullable String encoding, List<String> patchers, String classpath) throws IOException {
        File tempFile = FileUtil.createTempFile((String)"ideaGroovyToCompile", (String)".txt", (boolean)true);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(tempFile)));){
            writer.write(classpath);
            writer.write("\n");
            for (String string : changedSources) {
                writer.write("src_file\n");
                writer.write(string);
                writer.write("\n");
            }
            writer.write("class2src\n");
            for (Map.Entry entry : class2Src.entrySet()) {
                writer.write((String)entry.getKey() + "\n");
                writer.write((String)entry.getValue() + "\n");
            }
            writer.write("end\n");
            writer.write("patchers\n");
            for (String string : patchers) {
                writer.write(string + "\n");
            }
            writer.write("end\n");
            if (encoding != null) {
                writer.write("encoding\n");
                writer.write(encoding + "\n");
            }
            writer.write("outputpath\n");
            writer.write(outputDir);
            writer.write("\n");
            writer.write("final_outputpath\n");
            writer.write(StringUtil.join(finalOutputs, (String)File.pathSeparator));
            writer.write("\n");
        }
        return tempFile;
    }

    void notifyFinished(int exitCode) {
        this.myExitCode = exitCode;
    }

    public void onContinuation() {
        this.myCompiledItems.clear();
        this.compilerMessages.clear();
        this.stdErr.setLength(0);
        this.outputBuffer.setLength(0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/groovy/GroovycOutputParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/groovy/GroovycOutputParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "reportNoGroovy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateStatus";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class OutputItem {
        public final String outputPath;
        public final String sourcePath;

        public OutputItem(String outputPath, String sourceFileName) {
            this.outputPath = outputPath;
            this.sourcePath = sourceFileName;
        }

        public String toString() {
            return "OutputItem{outputPath='" + this.outputPath + '\'' + ", sourcePath='" + this.sourcePath + '\'' + '}';
        }
    }
}

