/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.codeInsight.daemon.impl.IdentifierHighlighterPass;
import com.intellij.javascript.JSDebuggerSupportUtils;
import com.intellij.javascript.debugger.ChromeEvaluator;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebuggerViewSupport$computeReceiverVariableUsingEvaluate$;
import com.intellij.javascript.debugger.JavaScriptDebuggerViewSupportKt;
import com.intellij.javascript.debugger.MemberFilterVisitor;
import com.intellij.javascript.debugger.NavigatableVariable;
import com.intellij.javascript.debugger.NavigatableVariableBackedPsiElement;
import com.intellij.javascript.debugger.scripts.ScriptsKt;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.css.impl.util.CssHighlighter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.ObsolescentConsumer;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.BasicDebuggerViewSupport;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.DebuggerSupportUtils;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.PresentationProvider;
import org.jetbrains.debugger.RejectErrorReporter;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.ScopeType;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableImpl;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.VariableViewKt;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.PrimitiveValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J0\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J(\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$H\u0016J0\u0010%\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020&2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J>\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020&2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\"0*H\u0014J$\u0010+\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010,\u001a\u00020-2\u0006\u0010\u001b\u001a\u00020.H\u0016J&\u0010/\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020.H\u0002J2\u00100\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0016J$\u00107\u001a\b\u0012\u0004\u0012\u0002080\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u0012J\u0016\u0010<\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J,\u0010=\u001a\u0004\u0018\u00010>2\b\u0010?\u001a\u0004\u0018\u00010\"2\u0006\u0010@\u001a\u00020\"2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020BH\u0016J,\u0010=\u001a\u0004\u0018\u00010>2\b\u0010?\u001a\u0004\u0018\u00010\"2\u0006\u00109\u001a\u00020:2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020BH\u0016J\u001c\u0010=\u001a\u0004\u0018\u00010>2\b\u00109\u001a\u0004\u0018\u00010:2\u0006\u00105\u001a\u00020-H\u0016J\u001a\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010F\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010G\u001a\u00020\u00122\u0006\u0010H\u001a\u00020>2\b\u00109\u001a\u0004\u0018\u00010:H\u0016J\u0010\u0010I\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010J\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001e\u0010K\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010L\u001a\u0004\u0018\u00010\"H\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R6\u0010\u0007\u001a*\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\f \n*\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b0\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006M"}, d2={"Lcom/intellij/javascript/debugger/JavaScriptDebuggerViewSupport;", "Lorg/jetbrains/debugger/BasicDebuggerViewSupport;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "(Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;)V", "getDebugProcess", "()Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "scopeToMemberFilter", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/debugger/Scope;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/debugger/MemberFilter;", "vm", "Lorg/jetbrains/debugger/Vm;", "getVm", "()Lorg/jetbrains/debugger/Vm;", "canNavigateToSource", "", "variable", "Lorg/jetbrains/debugger/Variable;", "context", "Lorg/jetbrains/debugger/VariableContext;", "computeArrayPresentation", "", "value", "Lorg/jetbrains/debugger/values/Value;", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "icon", "Ljavax/swing/Icon;", "computeInlineDebuggerData", "Lcom/intellij/util/ThreeState;", "name", "", "callback", "Lcom/intellij/xdebugger/frame/XInlineDebuggerDataCallback;", "computeObjectPresentation", "Lorg/jetbrains/debugger/values/ObjectValue;", "computeObjectSpecificPresentation", "objectValue", "propertiesToShow", "", "computeReceiverVariable", "callFrame", "Lorg/jetbrains/debugger/CallFrame;", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "computeReceiverVariableUsingEvaluate", "computeSourcePosition", "navigatable", "Lcom/intellij/xdebugger/frame/XNavigatable;", "createFrameEvaluator", "Lcom/intellij/javascript/debugger/ChromeEvaluator;", "frame", "Lorg/jetbrains/debugger/frame/CallFrameView;", "getFileByUrlOrVmSource", "Lcom/intellij/openapi/vfs/VirtualFile;", "script", "Lorg/jetbrains/debugger/Script;", "tryToResolveByUrl", "getMemberFilter", "getSourceInfo", "Lorg/jetbrains/debugger/SourceInfo;", "functionName", "scriptUrl", "line", "", "column", "getVariable", "Lcom/intellij/lang/javascript/psi/JSVariable;", "variableSourceName", "isInLibraryContent", "sourceInfo", "isMemberVisible", "rawNameToSource", "transformErrorOnGetUsedReferenceValue", "error", "JavaScriptDebugger"})
public class JavaScriptDebuggerViewSupport
extends BasicDebuggerViewSupport {
    private final ConcurrentMap<Scope, Promise<MemberFilter>> scopeToMemberFilter;
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;

    @Nullable
    public Vm getVm() {
        return this.debugProcess.getMainVm();
    }

    public boolean isInLibraryContent(@NotNull SourceInfo sourceInfo, @Nullable Script script) {
        Intrinsics.checkParameterIsNotNull((Object)sourceInfo, (String)"sourceInfo");
        return this.debugProcess.isLibraryFile(script, sourceInfo);
    }

    @NotNull
    public Promise<MemberFilter> getMemberFilter(@NotNull VariableContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Scope scope = context.getScope();
        if (scope == null || Intrinsics.areEqual((Object)scope.getType(), (Object)ScopeType.LOCAL) ^ true || !(context.getParent() instanceof CallFrameView)) {
            return this.getDefaultMemberFilterPromise();
        }
        VariableContext variableContext = context.getParent();
        if (variableContext == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.frame.CallFrameView");
        }
        CallFrameView callFrameView = (CallFrameView)variableContext;
        SourceInfo sourceInfo = callFrameView.getSourcePosition();
        if (sourceInfo == null) {
            return this.getDefaultMemberFilterPromise();
        }
        SourceInfo position = sourceInfo;
        Promise<MemberFilter> result = (Promise<MemberFilter>)this.scopeToMemberFilter.get(scope);
        if (result != null) {
            return result;
        }
        result = new MemberFilterVisitor(this, callFrameView).compute((XSourcePosition)position, (Promise<MemberFilter>)this.getDefaultMemberFilterPromise());
        Promise<MemberFilter> promise = this.scopeToMemberFilter.putIfAbsent(scope, result);
        if (promise == null) {
            promise = result;
        }
        return promise;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ThreeState computeInlineDebuggerData(@NotNull String name, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XInlineDebuggerDataCallback callback) {
        void status;
        PsiElement it;
        PsiElement psiElement;
        CharSequence charSequence;
        ValueType valueType;
        Value value;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        Value value2 = value = variable.getValue();
        Object object = valueType = value2 != null ? value2.getType() : null;
        if (value instanceof ObjectValue && ((charSequence = (CharSequence)((ObjectValue)value).getClassName()) == null || charSequence.length() == 0) && ((charSequence = (CharSequence)value.getValueString()) == null || charSequence.length() == 0) && JavaScriptDebuggerViewSupportKt.access$getPropertiesToShow().isEmpty()) {
            return ThreeState.NO;
        }
        if (!(variable instanceof NavigatableVariable)) {
            if (Intrinsics.areEqual((Object)valueType, (Object)ValueType.FUNCTION)) {
                return ThreeState.NO;
            }
            JSVariable jSVariable = this.getVariable(name, context);
            if (jSVariable != null) {
                charSequence = jSVariable;
                CharSequence it2 = charSequence;
                PsiElement navigationElement = it2.getNavigationElement();
                VirtualFile file = navigationElement.getContainingFile().getVirtualFile();
                VirtualFile virtualFile = file;
                if (virtualFile != null) {
                    VirtualFile virtualFile2;
                    VirtualFile it3 = virtualFile2 = virtualFile;
                    virtualFile = FileDocumentManager.getInstance().getDocument(it3);
                    if (virtualFile != null) {
                        it3 = virtualFile2 = virtualFile;
                        callback.computed(XDebuggerUtil.getInstance().createPositionByOffset(file, navigationElement.getTextOffset()));
                        return ThreeState.YES;
                    }
                }
            }
            return ThreeState.NO;
        }
        NavigatableVariableBackedPsiElement navigatableVariable = (NavigatableVariableBackedPsiElement)variable;
        Ref.ObjectRef it2 = new Ref.ObjectRef();
        it2.element = ThreeState.NO;
        PsiElement psiElement2 = navigatableVariable.getUnresolvedReferences();
        if (psiElement2 != null) {
            it = psiElement = psiElement2;
            for (SmartPsiElementPointer<JSReferenceExpression> ref : it) {
                Segment psiRange = ref.getPsiRange();
                if (psiRange == null) continue;
                callback.computed(XDebuggerUtil.getInstance().createPositionByOffset(ref.getVirtualFile(), psiRange.getStartOffset()));
                status.element = ThreeState.YES;
            }
        }
        PsiElement psiElement3 = navigatableVariable.getElementPointer().getElement();
        if (psiElement3 != null) {
            void document;
            it = psiElement = psiElement3;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            VirtualFile virtualFile = navigatableVariable.getElementPointer().getVirtualFile();
            Collection usages = (Collection)ApplicationManager.getApplication().runReadAction(new Computable<T>(it, virtualFile, (Ref.ObjectRef)document, navigatableVariable, callback, (Ref.ObjectRef)status){
                final /* synthetic */ PsiElement $it$inlined;
                final /* synthetic */ VirtualFile $virtualFile$inlined;
                final /* synthetic */ Ref.ObjectRef $document$inlined;
                final /* synthetic */ NavigatableVariableBackedPsiElement $navigatableVariable$inlined;
                final /* synthetic */ XInlineDebuggerDataCallback $callback$inlined;
                final /* synthetic */ Ref.ObjectRef $status$inlined;
                {
                    this.$it$inlined = psiElement;
                    this.$virtualFile$inlined = virtualFile;
                    this.$document$inlined = objectRef;
                    this.$navigatableVariable$inlined = navigatableVariableBackedPsiElement;
                    this.$callback$inlined = xInlineDebuggerDataCallback;
                    this.$status$inlined = objectRef2;
                }

                public final T compute() {
                    Collection collection;
                    PsiElement targetElement;
                    PsiElement psiElement = targetElement = this.$it$inlined instanceof PsiPolyVariantReference ? JSDebuggerSupportUtils.resolve((PsiPolyVariantReference)((PsiPolyVariantReference)this.$it$inlined)) : this.$it$inlined;
                    if (targetElement == null) {
                        this.$callback$inlined.computed(XDebuggerUtil.getInstance().createPositionByElement(this.$it$inlined));
                        this.$status$inlined.element = ThreeState.YES;
                        collection = null;
                    } else {
                        Collection usages = IdentifierHighlighterPass.getUsages((PsiElement)targetElement, (PsiElement)((PsiElement)this.$it$inlined.getContainingFile()), (boolean)true);
                        if (usages.isEmpty()) {
                            collection = usages;
                        } else {
                            Document document = FileDocumentManager.getInstance().getDocument(this.$virtualFile$inlined);
                            if (document != null) {
                                Document document2;
                                Document it = document2 = document;
                                this.$document$inlined.element = it;
                                collection = usages;
                            } else {
                                collection = null;
                            }
                        }
                    }
                    return (T)collection;
                }
            });
            if (usages == null) {
                ThreeState cfr_ignored_1 = (ThreeState)status.element;
            } else {
                for (TextRange usage : usages) {
                    int offset = usage.getStartOffset();
                    Document document2 = (Document)document.element;
                    if (document2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (offset > document2.getTextLength()) continue;
                    VirtualFile virtualFile3 = virtualFile;
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"virtualFile");
                    Document document3 = (Document)document.element;
                    if (document3 == null) {
                        Intrinsics.throwNpe();
                    }
                    callback.computed((XSourcePosition)new SourceInfo(virtualFile3, document3.getLineNumber(offset), 0, offset, null, null, 52, null));
                }
                return ThreeState.YES;
            }
        }
        return (ThreeState)status.element;
    }

    @Nullable
    public SourceInfo getSourceInfo(@Nullable Script script, @NotNull CallFrame frame) {
        SourceInfo sourceInfo;
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        Script script2 = script;
        if (script2 != null) {
            Script script3;
            Script it = script3 = script2;
            sourceInfo = this.getSourceInfo(frame.getFunctionName(), it, frame.getLine(), frame.getColumn());
        } else {
            sourceInfo = null;
        }
        return sourceInfo;
    }

    @Nullable
    public SourceInfo getSourceInfo(@Nullable String functionName, @NotNull String scriptUrl, int line, int column) {
        SourceInfo sourceInfo;
        Intrinsics.checkParameterIsNotNull((Object)scriptUrl, (String)"scriptUrl");
        Vm vm = this.getVm();
        if (vm != null && (vm = vm.getScriptManager()) != null && (vm = vm.findScriptByUrl(scriptUrl)) != null) {
            Vm vm2;
            Vm it = vm2 = vm;
            sourceInfo = this.getSourceInfo(functionName, (Script)it, line, column);
        } else {
            sourceInfo = null;
        }
        return sourceInfo;
    }

    @Nullable
    public SourceInfo getSourceInfo(@Nullable String functionName, @NotNull Script script, int line, int column) {
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        return this.debugProcess.getSourceInfo(functionName, script, line, column);
    }

    public boolean isMemberVisible(@NotNull Variable variable) {
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        return super.isMemberVisible(variable) && JavaScriptDebuggerViewSupportKt.isVariableVisible(variable);
    }

    /*
     * WARNING - void declaration
     */
    public void computeObjectPresentation(@NotNull ObjectValue value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
        if (value instanceof PresentationProvider && ((PresentationProvider)value).computePresentation(node, icon)) {
            return;
        }
        if (Intrinsics.areEqual((Object)value.getType(), (Object)ValueType.NODE)) {
            String string = value.getValueString();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String string2 = string;
            node.setPresentation(icon, new XValuePresentation(string2){
                final /* synthetic */ String $string;

                public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
                    Intrinsics.checkParameterIsNotNull((Object)renderer, (String)"renderer");
                    int index = StringsKt.indexOf$default((CharSequence)this.$string, (char)'#', (int)0, (boolean)false, (int)6, null);
                    if (index > 0) {
                        String string = this.$string;
                        int n = 0;
                        XValuePresentation.XValueTextRenderer xValueTextRenderer = renderer;
                        String string2 = string;
                        if (string2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string3 = string2.substring(n, index);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        String string4 = string3;
                        xValueTextRenderer.renderComment(string4);
                        string = this.$string;
                        xValueTextRenderer = renderer;
                        String string5 = string;
                        if (string5 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string6 = string5.substring(index);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
                        string4 = string6;
                        xValueTextRenderer.renderValue(string4, CssHighlighter.CSS_IDENT);
                    } else {
                        renderer.renderComment(this.$string);
                    }
                }
                {
                    this.$string = $captured_local_variable$0;
                }
            }, true);
            return;
        }
        if (Intrinsics.areEqual((Object)value.getClassName(), (Object)value.getValueString()) ^ true) {
            VariableView.Companion.setObjectPresentation(value, icon, node);
            return;
        }
        List propertiesToShow = JavaScriptDebuggerViewSupportKt.access$getPropertiesToShow();
        if (this.computeObjectSpecificPresentation(value, variable, context, node, icon, propertiesToShow)) {
            return;
        }
        if (propertiesToShow.isEmpty() || Intrinsics.areEqual((Object)value.hasProperties(), (Object)ThreeState.NO)) {
            VariableView.Companion.setObjectPresentation(value, icon, node);
            return;
        }
        Promise promise = value.getProperties(propertiesToShow, context.getEvaluateContext(), (Obsolescent)node);
        Promise promise2 = $receiver$iv.done((Consumer)new ObsolescentConsumer<List<? extends Variable>>((Obsolescent)node, (Obsolescent)node, node, value, icon){
            final /* synthetic */ Obsolescent $node;
            final /* synthetic */ XValueNode $node$inlined;
            final /* synthetic */ ObjectValue $value$inlined;
            final /* synthetic */ Icon $icon$inlined;
            {
                this.$node = $captured_local_variable$1;
                this.$node$inlined = xValueNode;
                this.$value$inlined = objectValue;
                this.$icon$inlined = icon;
                super($super_call_param$2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public void consume(Object param) {
                List it = (List)param;
                JavaScriptDebuggerViewSupportKt.doSetObjectPresentation(this.$node$inlined, it, this.$value$inlined, this.$icon$inlined);
            }
        });
        XDebugSession xDebugSession = this.debugProcess.getSession();
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"debugProcess.session");
        promise2.rejected((Consumer)new RejectErrorReporter(xDebugSession, null, 2, null));
    }

    protected boolean computeObjectSpecificPresentation(@NotNull ObjectValue objectValue, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon, @NotNull List<String> propertiesToShow) {
        Intrinsics.checkParameterIsNotNull((Object)objectValue, (String)"objectValue");
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
        Intrinsics.checkParameterIsNotNull(propertiesToShow, (String)"propertiesToShow");
        return false;
    }

    public void computeArrayPresentation(@NotNull Value value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
        VariableView.Companion.setArrayPresentation(value, context, icon, node);
    }

    @NotNull
    public ChromeEvaluator createFrameEvaluator(@NotNull CallFrameView frame) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        return new ChromeEvaluator((VariableContext)frame);
    }

    @Nullable
    public Value transformErrorOnGetUsedReferenceValue(@Nullable Value value, @Nullable String error) {
        return value instanceof ObjectValue && (Intrinsics.areEqual((Object)((ObjectValue)value).getClassName(), (Object)"TypeError") || Intrinsics.areEqual((Object)((ObjectValue)value).getClassName(), (Object)"ReferenceError")) ? (Value)PrimitiveValue.UNDEFINED : super.transformErrorOnGetUsedReferenceValue(value, error);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canNavigateToSource(@NotNull Variable variable, @NotNull VariableContext context) {
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (variable instanceof NavigatableVariable) {
            return ((NavigatableVariable)variable).hasSourcePosition();
        }
        Scope scope = context.getScope();
        if (scope == null) return false;
        if (!Intrinsics.areEqual((Object)scope.getType(), (Object)ScopeType.LOCAL) && !Intrinsics.areEqual((Object)scope.getType(), (Object)ScopeType.CLOSURE)) {
            if (!Intrinsics.areEqual((Object)scope.getType(), (Object)ScopeType.CATCH)) return false;
        }
        if (!(context.getParent() instanceof CallFrameView)) return false;
        VariableContext variableContext = context.getParent();
        if (variableContext == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.frame.CallFrameView");
        }
        if (((CallFrameView)variableContext).getSourcePosition() == null) return false;
        return true;
    }

    public void computeSourcePosition(@NotNull String name, @Nullable Value value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XNavigatable navigatable) {
        block1: {
            JSVariable jSVariable;
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)navigatable, (String)"navigatable");
            if (variable instanceof NavigatableVariable) {
                navigatable.setSourcePosition(((NavigatableVariable)variable).getSourcePosition());
                return;
            }
            JSVariable jSVariable2 = this.getVariable(name, context);
            if (jSVariable2 == null) break block1;
            JSVariable it = jSVariable = jSVariable2;
            navigatable.setSourcePosition(DebuggerSupportUtils.calcSourcePosition((PsiElement)((PsiElement)it)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final JSVariable getVariable(String variableSourceName, VariableContext context) {
        void result;
        CallFrameView callFrameView;
        VariableContext variableContext = context.getParent();
        if (!(variableContext instanceof CallFrameView)) {
            variableContext = null;
        }
        if ((callFrameView = (CallFrameView)variableContext) == null || (callFrameView = callFrameView.getSourcePosition()) == null) {
            return null;
        }
        CallFrameView sourcePosition2 = callFrameView;
        VirtualFile virtualFile = sourcePosition2.getFile();
        int n = sourcePosition2.getOffset();
        Project project = this.debugProcess.getSession().getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"debugProcess.session.project");
        PsiElement psiElement = JavaScriptDebuggerViewSupportKt.getContextElement(virtualFile, n, project);
        if (psiElement == null) {
            return null;
        }
        PsiElement contextElement = psiElement;
        JSFunction jSFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)contextElement, JSFunction.class);
        PsiElement psiElement2 = jSFunction != null ? (PsiElement)jSFunction : (PsiElement)contextElement.getContainingFile();
        if (psiElement2 == null) {
            return null;
        }
        PsiElement host = psiElement2;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        host.accept((PsiElementVisitor)new JSElementVisitor((Ref.ObjectRef)result, variableSourceName){
            final /* synthetic */ Ref.ObjectRef $result;
            final /* synthetic */ String $variableSourceName;

            public void visitElement(@NotNull PsiElement node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                if ((JSVariable)this.$result.element == null) {
                    node.acceptChildren((PsiElementVisitor)this);
                }
            }

            public void visitJSParameter(@NotNull JSParameter node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                if (Intrinsics.areEqual((Object)this.$variableSourceName, (Object)node.getName())) {
                    this.$result.element = (JSVariable)node;
                } else {
                    super.visitJSParameter(node);
                }
            }

            public void visitJSVariable(@NotNull JSVariable node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                if (Intrinsics.areEqual((Object)this.$variableSourceName, (Object)node.getName())) {
                    this.$result.element = node;
                } else {
                    super.visitJSVariable(node);
                }
            }
            {
                this.$result = $captured_local_variable$0;
                this.$variableSourceName = $captured_local_variable$1;
            }
        });
        return (JSVariable)result.element;
    }

    @NotNull
    public String rawNameToSource(@NotNull Variable variable) {
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        String string = variable.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variable.name");
        return this.debugProcess.normalizeMemberName(string);
    }

    @NotNull
    public final Promise<VirtualFile> getFileByUrlOrVmSource(@NotNull Vm vm, @NotNull Script script, boolean tryToResolveByUrl) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        Promise<VirtualFile> promise = ScriptsKt.getCachedActualFile(script, vm);
        if (promise != null) {
            Promise<VirtualFile> promise2;
            Promise<VirtualFile> it = promise2 = promise;
            return it;
        }
        Url url = script.getUrl();
        if (tryToResolveByUrl && !StringsKt.endsWith$default((String)url.getPath(), (String)"!transpiled", (boolean)false, (int)2, null)) {
            VirtualFile virtualFile;
            Function1<VirtualFile, VirtualFile> checkFile$ = new Function1<VirtualFile, VirtualFile>(script){
                final /* synthetic */ Script $script;

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final VirtualFile invoke(@NotNull VirtualFile $receiver) {
                    void var3_4;
                    void $receiver$iv;
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    byte[] byArray = $receiver.contentsToByteArray();
                    int n = this.$script.getEndLine();
                    int count$iv = 0;
                    for (int i = 0; i < ((void)$receiver$iv).length; ++i) {
                        void element$iv = $receiver$iv[i];
                        void it = element$iv;
                        if (!(it == (byte)10)) continue;
                        ++count$iv;
                    }
                    void var10_8 = var3_4;
                    return n > var10_8 + 2 ? null : $receiver;
                }
                {
                    this.$script = script;
                    super(1);
                }
            };
            VirtualFile virtualFile2 = JavaScriptDebugProcess.findFile$default(this.debugProcess, url, false, 2, null);
            if (virtualFile2 != null && (virtualFile2 = checkFile$.invoke(virtualFile2)) != null) {
                VirtualFile virtualFile3;
                VirtualFile it = virtualFile3 = virtualFile2;
                return Promises.resolvedPromise((Object)it);
            }
            if (url.isInLocalFileSystem() && (virtualFile = LocalFileSystem.getInstance().findFileByPath(url.getPath())) != null && (virtualFile = checkFile$.invoke(virtualFile)) != null) {
                VirtualFile virtualFile4;
                VirtualFile it = virtualFile4 = virtualFile;
                return Promises.resolvedPromise((Object)it);
            }
        }
        Promise promise3 = ScriptsKt.getResolvedFile(script, vm).done((Consumer)new Consumer<VirtualFile>(this, url){
            final /* synthetic */ JavaScriptDebuggerViewSupport this$0;
            final /* synthetic */ Url $url;

            public final void consume(VirtualFile it) {
                JavaScriptDebugProcess<?> javaScriptDebugProcess = this.this$0.getDebugProcess();
                VirtualFile virtualFile = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"it");
                javaScriptDebugProcess.saveResolvedFile(this.$url, virtualFile);
            }
            {
                this.this$0 = javaScriptDebuggerViewSupport;
                this.$url = url;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise3, (String)"getResolvedFile(script, \u2026veResolvedFile(url, it) }");
        return promise3;
    }

    @NotNull
    public Promise<?> computeReceiverVariable(@NotNull VariableContext context, @NotNull CallFrame callFrame, @NotNull XCompositeNode node) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)callFrame, (String)"callFrame");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        if (!Registry.is((String)"js.debugger.use.vm.receiver", (boolean)false)) {
            Promise<?> promise = this.computeReceiverVariableUsingEvaluate(callFrame, context, node);
            if (promise != null) {
                Promise<?> promise2;
                Promise<?> it = promise2 = promise;
                return it;
            }
        }
        return super.computeReceiverVariable(context, callFrame, node);
    }

    private final Promise<?> computeReceiverVariableUsingEvaluate(CallFrame callFrame, VariableContext context, XCompositeNode node) {
        CallFrameView callFrameView;
        VariableContext parent;
        for (parent = context; parent != null && !(parent instanceof CallFrameView); parent = parent.getParent()) {
        }
        VariableContext variableContext = parent;
        if (!(variableContext instanceof CallFrameView)) {
            variableContext = null;
        }
        if ((callFrameView = (CallFrameView)variableContext) == null || (callFrameView = callFrameView.getSourcePosition()) == null || (callFrameView = callFrameView.getFile()) == null) {
            return null;
        }
        CallFrameView file = callFrameView;
        return (Promise)ApplicationManager.getApplication().runReadAction(new Computable<T>(this, (VirtualFile)file, callFrame, node, context){
            final /* synthetic */ JavaScriptDebuggerViewSupport this$0;
            final /* synthetic */ VirtualFile $file$inlined;
            final /* synthetic */ CallFrame $callFrame$inlined;
            final /* synthetic */ XCompositeNode $node$inlined;
            final /* synthetic */ VariableContext $context$inlined;
            {
                this.this$0 = javaScriptDebuggerViewSupport;
                this.$file$inlined = virtualFile;
                this.$callFrame$inlined = callFrame;
                this.$node$inlined = xCompositeNode;
                this.$context$inlined = variableContext;
            }

            public final T compute() {
                Promise promise;
                block6: {
                    Project project = this.this$0.getDebugProcess().getSession().getProject();
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(this.$file$inlined);
                    if (psiFile == null) {
                        promise = null;
                    } else {
                        block7: {
                            PsiFile psiFile2 = psiFile;
                            try {
                                Promise $receiver$iv;
                                Document document;
                                Document document2 = document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile2);
                                if (document2 == null) {
                                    Intrinsics.throwNpe();
                                }
                                int offset = document2.getLineStartOffset(this.$callFrame$inlined.getLine()) + this.$callFrame$inlined.getColumn();
                                PsiElement psiElement = psiFile2.findElementAt(offset);
                                if (psiElement == null) {
                                    promise = null;
                                    break block6;
                                }
                                PsiElement elementAtOffset = psiElement;
                                PsiElement executionScope = JSPsiImplUtils.getExecutionScope((PsiElement)elementAtOffset);
                                if (!(executionScope instanceof JSFunction) || !JSPsiImplUtils.isArrowFunction((JSFunction)((JSFunction)executionScope))) break block7;
                                Promise promise2 = EvaluateContext.DefaultImpls.evaluate$default((EvaluateContext)this.$callFrame$inlined.getEvaluateContext(), (String)"this", null, (boolean)false, (int)6, null);
                                Obsolescent node$iv = (Obsolescent)this.$node$inlined;
                                $receiver$iv = $receiver$iv.done((Consumer)new ObsolescentConsumer<EvaluateResult>(node$iv, node$iv, this){
                                    final /* synthetic */ Obsolescent $node;
                                    final /* synthetic */ computeReceiverVariableUsingEvaluate$$inlined$runReadAction$1 this$0;
                                    {
                                        this.$node = $captured_local_variable$1;
                                        this.this$0 = var3_3;
                                        super($super_call_param$2);
                                    }

                                    /*
                                     * Ignored method signature, as it can't be verified against descriptor
                                     */
                                    public void consume(Object param) {
                                        EvaluateResult it = (EvaluateResult)param;
                                        this.this$0.$node$inlined.addChildren(XValueChildrenList.singleton((XNamedValue)((XNamedValue)VariableViewKt.VariableView((Variable)((Variable)new VariableImpl("this", it.getValue())), (VariableContext)this.this$0.$context$inlined))), true);
                                    }
                                });
                                node$iv = (Obsolescent)this.$node$inlined;
                                promise = $receiver$iv.rejected((Consumer)new ObsolescentConsumer<Throwable>(node$iv, node$iv, this){
                                    final /* synthetic */ Obsolescent $node;
                                    final /* synthetic */ computeReceiverVariableUsingEvaluate$$inlined$runReadAction$1 this$0;
                                    {
                                        this.$node = $captured_local_variable$1;
                                        this.this$0 = var3_3;
                                        super($super_call_param$2);
                                    }

                                    public void consume(@NotNull Throwable param) {
                                        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
                                        Throwable it = param;
                                        this.this$0.$node$inlined.addChildren(XValueChildrenList.EMPTY, true);
                                    }
                                });
                                break block6;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        promise = null;
                    }
                }
                return (T)promise;
            }
        });
    }

    @NotNull
    public final JavaScriptDebugProcess<?> getDebugProcess() {
        return this.debugProcess;
    }

    public JavaScriptDebuggerViewSupport(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        this.debugProcess = debugProcess;
        this.scopeToMemberFilter = ContainerUtil.newConcurrentMap();
        this.debugProcess.getConnection().addDebugListener(new DebugEventListener(){

            public void resumed(@NotNull Vm vm) {
                Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
                this.clear();
            }

            public void navigated(@NotNull String newUrl) {
                Intrinsics.checkParameterIsNotNull((Object)newUrl, (String)"newUrl");
                this.clear();
            }

            private final void clear() {
                scopeToMemberFilter.clear();
            }
        });
    }
}

