/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.execution;

import com.intellij.ide.browsers.BrowserSelector;
import com.intellij.ide.browsers.StartBrowserPanel;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JavaScriptDebugEngine;
import com.intellij.javascript.debugger.JavaScriptDebugEngineKt;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.io.URLUtil;
import com.intellij.util.ui.tree.AbstractFileTreeTable;
import com.intellij.xdebugger.XDebuggerManager;
import gnu.trove.THashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.SourceResolver;
import org.jetbrains.io.LocalFileFinder;

public class JavaScriptDebugSettingsEditor
extends SettingsEditor<JavaScriptDebugConfiguration> {
    public static final Condition<WebBrowser> BROWSER_CONDITION = browser -> {
        if (browser == null) {
            return true;
        }
        for (JavaScriptDebugEngine engine : JavaScriptDebugEngineKt.getEngines()) {
            if (!engine.isBrowserSupported((WebBrowser)browser)) continue;
            return true;
        }
        return false;
    };
    protected final Project project;
    private JPanel mainPanel;
    private TextFieldWithBrowseButton uriField;
    private JComponent browserCombobox;
    private JLabel browserLabel;
    @Nullable
    private final AbstractFileTreeTable<String> mappingTree;
    private JPanel localFilesMappingPanel;
    private JPanel mappingTreePanel;
    private BrowserSelector browserSelector;

    public JavaScriptDebugSettingsEditor(@NotNull Project project) {
        if (project == null) {
            JavaScriptDebugSettingsEditor.$$$reportNull$$$0(0);
        }
        this.project = project;
        this.$$$setupUI$$$();
        this.mappingTree = project.isDefault() ? null : new AbstractFileTreeTable(project, String.class, JSDebuggerBundle.message("column.title.remote.url", new Object[0]), (VirtualFileFilter)new VisibleNodeFileFilter(DirectoryIndex.getInstance((Project)project)), true, false);
    }

    private static void addAndSelectBrowserByInvalidEngine(@NotNull BrowserSelector browserSelector, @NotNull String id) {
        JavaScriptDebugEngine engine;
        WebBrowser browser;
        if (browserSelector == null) {
            JavaScriptDebugSettingsEditor.$$$reportNull$$$0(1);
        }
        if (id == null) {
            JavaScriptDebugSettingsEditor.$$$reportNull$$$0(2);
        }
        WebBrowser webBrowser = browser = (engine = JavaScriptDebugEngineKt.findByBrowserIdOrNameOrEngineId(id)) == null ? null : engine.getBrowser();
        if (browser == null) {
            return;
        }
        browserSelector.addAndSelect(browser);
    }

    protected void resetEditorFrom(@NotNull JavaScriptDebugConfiguration configuration) {
        boolean allowConfigureMappings;
        String text;
        if (configuration == null) {
            JavaScriptDebugSettingsEditor.$$$reportNull$$$0(3);
        }
        String id = configuration.getEngineId();
        JavaScriptDebugSettingsEditor.resetBrowserSelectorFromId(this.browserSelector, id);
        String url = configuration.getUri();
        if (url == null) {
            text = "";
            allowConfigureMappings = false;
        } else {
            int index = url.indexOf("://");
            if (index < 0 || !url.startsWith("file://")) {
                text = url;
                allowConfigureMappings = index <= 0 || JavaScriptDebugSettingsEditor.isConfigureMappingsAllowed(url);
            } else {
                allowConfigureMappings = false;
                int offset = index + "://".length();
                if (SystemInfo.isWindows && url.charAt(offset) == '/') {
                    ++offset;
                }
                text = FileUtilRt.toSystemDependentName((String)url.substring(offset));
            }
        }
        this.uriField.setText(text);
        if (!allowConfigureMappings) {
            this.localFilesMappingPanel.setVisible(false);
        } else if (this.mappingTree != null) {
            THashMap map = new THashMap();
            VirtualFile toSelect = null;
            for (RemoteUrlMappingBean bean : configuration.getMappings()) {
                VirtualFile file = LocalFileFinder.findFile((String)bean.localFilePath);
                if (file == null) continue;
                map.put(file, bean.getRemoteUrl());
                if (toSelect != null && !VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)toSelect, (boolean)false)) continue;
                toSelect = file;
            }
            this.mappingTree.reset((Map)map);
            this.mappingTree.select(toSelect);
        }
        this.uriField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                JavaScriptDebugSettingsEditor.this.localFilesMappingPanel.setVisible(JavaScriptDebugSettingsEditor.isConfigureMappingsAllowed(JavaScriptDebugSettingsEditor.this.uriField.getText()));
            }
        });
    }

    public static void resetBrowserSelectorFromId(@NotNull BrowserSelector selector, @Nullable String browserId) {
        WebBrowser browser;
        if (selector == null) {
            JavaScriptDebugSettingsEditor.$$$reportNull$$$0(4);
        }
        if ((browser = WebBrowserManager.getInstance().findBrowserById(browserId)) != null) {
            selector.setSelected(browser);
        } else if (browserId != null) {
            JavaScriptDebugSettingsEditor.addAndSelectBrowserByInvalidEngine(selector, browserId);
        }
    }

    private static boolean isConfigureMappingsAllowed(@NotNull String url) {
        int index;
        if (url == null) {
            JavaScriptDebugSettingsEditor.$$$reportNull$$$0(5);
        }
        if ((index = url.indexOf("://")) > 0) {
            return !url.startsWith("file://");
        }
        return url.isEmpty() || url.charAt(0) != '/';
    }

    protected void applyEditorTo(@NotNull JavaScriptDebugConfiguration configuration) throws ConfigurationException {
        WebBrowser browser;
        if (configuration == null) {
            JavaScriptDebugSettingsEditor.$$$reportNull$$$0(6);
        }
        configuration.setEngineId((browser = this.browserSelector.getSelected()) == null ? null : browser.getId().toString());
        String text = this.uriField.getText();
        if (StringUtil.isEmpty((String)text)) {
            configuration.setUri(null);
            return;
        }
        String url = URLUtil.containsScheme((String)text) ? text : (!SourceResolver.Companion.isAbsolute(text) ? VirtualFileManager.constructUrl((String)"http", (String)text) : VirtualFileManager.constructUrl((String)"file", (String)FileUtilRt.toSystemIndependentName((String)FileUtil.expandUserHome((String)text))));
        configuration.setUri(url);
        if (this.mappingTree != null) {
            List<RemoteUrlMappingBean> mappings = configuration.getMappings();
            mappings.clear();
            for (Map.Entry mapping : this.mappingTree.getValues().entrySet()) {
                String remote = (String)mapping.getValue();
                if (remote.isEmpty()) continue;
                if (!URLUtil.containsScheme((String)remote)) {
                    remote = "http://" + remote;
                }
                mappings.add(new RemoteUrlMappingBean(((VirtualFile)mapping.getKey()).getPath(), remote));
            }
            for (JavaScriptDebugProcess process : XDebuggerManager.getInstance((Project)this.mappingTree.getProject()).getDebugProcesses(JavaScriptDebugProcess.class)) {
                if (process.getSession().getRunProfile() != configuration) continue;
                process.updateRemoteUrlMappings(mappings);
            }
        }
    }

    @NotNull
    protected JComponent createEditor() {
        StartBrowserPanel.setupUrlField((TextFieldWithBrowseButton)this.uriField, (Project)this.project);
        if (this.mappingTree != null) {
            this.mappingTreePanel.add(ScrollPaneFactory.createScrollPane(this.mappingTree));
        } else {
            this.localFilesMappingPanel.setVisible(false);
        }
        JPanel jPanel = this.mainPanel;
        if (jPanel == null) {
            JavaScriptDebugSettingsEditor.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    private void createUIComponents() {
        this.browserSelector = new BrowserSelector(BROWSER_CONDITION);
        this.browserCombobox = this.browserSelector.getMainComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browserSelector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/debugger/execution/JavaScriptDebugSettingsEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/debugger/execution/JavaScriptDebugSettingsEditor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addAndSelectBrowserByInvalidEngine";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resetBrowserSelectorFromId";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isConfigureMappingsAllowed";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JLabel jLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel3;
        this.createUIComponents();
        this.mainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.uriField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/JSDebuggerBundle").getString("javascript.debugger.settings.url"));
        jPanel4.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.browserLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/JSDebuggerBundle").getString("label.text.browser"));
        jPanel4.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComponent jComponent = this.browserCombobox;
        jPanel4.add((Component)jComponent, new GridConstraints(1, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        this.localFilesMappingPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/JSDebuggerBundle").getString("label.text.remote.urls.of.local.files"));
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mappingTreePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jLabel.setLabelFor(jComponent);
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static class VisibleNodeFileFilter
    implements VirtualFileFilter {
        private final DirectoryIndex directoryIndex;

        public VisibleNodeFileFilter(@NotNull DirectoryIndex directoryIndex) {
            if (directoryIndex == null) {
                VisibleNodeFileFilter.$$$reportNull$$$0(0);
            }
            this.directoryIndex = directoryIndex;
        }

        public boolean accept(VirtualFile file) {
            if (file.isDirectory()) {
                DirectoryInfo info = this.directoryIndex.getInfoForFile(file);
                return info.isInProject(file) || info.isExcluded(file);
            }
            return file.isDirectory() || JsFileUtil.isHtmlOrJavaScript(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryIndex", "com/intellij/javascript/debugger/execution/JavaScriptDebugSettingsEditor$VisibleNodeFileFilter", "<init>"));
        }
    }
}

