/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.settings;

import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.settings.CustomObjectPresentationState;
import com.intellij.javascript.debugger.settings.JavaScriptDebuggerSettings;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class JavaScriptDataViewsConfigurableUi
implements ConfigurableUi<JavaScriptDebuggerSettings> {
    private JPanel panel;
    private JCheckBox myEnableAlternativeObjectView;
    private JPanel propertiesPanel;
    private SortedListModel<String> propertiesListModel;

    public JavaScriptDataViewsConfigurableUi() {
        this.$$$setupUI$$$();
        this.myEnableAlternativeObjectView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaScriptDataViewsConfigurableUi.this.updatePropertiesListPanel();
            }
        });
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.panel;
        if (jPanel == null) {
            JavaScriptDataViewsConfigurableUi.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    public boolean isModified(@NotNull JavaScriptDebuggerSettings settings) {
        if (settings == null) {
            JavaScriptDataViewsConfigurableUi.$$$reportNull$$$0(1);
        }
        return this.myEnableAlternativeObjectView.isSelected() != settings.getObjectPresentation().isEnabled() || !this.propertiesListModel.getItems().equals(settings.getObjectPresentation().getPropertiesToShow());
    }

    public void apply(@NotNull JavaScriptDebuggerSettings settings) {
        if (settings == null) {
            JavaScriptDataViewsConfigurableUi.$$$reportNull$$$0(2);
        }
        CustomObjectPresentationState objectPresentation = settings.getObjectPresentation();
        objectPresentation.setEnabled(this.myEnableAlternativeObjectView.isSelected());
        objectPresentation.setPropertiesToShow(this.propertiesListModel.getItems());
        JavaScriptDebuggerSettings.onSettingsChanged(true, false);
    }

    public void reset(@NotNull JavaScriptDebuggerSettings settings) {
        if (settings == null) {
            JavaScriptDataViewsConfigurableUi.$$$reportNull$$$0(3);
        }
        CustomObjectPresentationState objectPresentation = settings.getObjectPresentation();
        this.myEnableAlternativeObjectView.setSelected(objectPresentation.isEnabled());
        this.propertiesListModel.setAll(objectPresentation.getPropertiesToShow());
        this.updatePropertiesListPanel();
    }

    private void updatePropertiesListPanel() {
        GuiUtils.enableChildren((boolean)this.myEnableAlternativeObjectView.isSelected(), (Component[])new Component[]{this.propertiesPanel});
    }

    private void createUIComponents() {
        JBList list = new JBList();
        this.propertiesListModel = new SortedListModel(String.CASE_INSENSITIVE_ORDER);
        list.setModel(this.propertiesListModel);
        this.propertiesPanel = ToolbarDecorator.createDecorator((JList)list).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                String name = Messages.showInputDialog((Component)JavaScriptDataViewsConfigurableUi.this.panel, (String)JSDebuggerBundle.message("label.text.specify.property.name", new Object[0]), (String)JSDebuggerBundle.message("dialog.title.add.property", new Object[0]), null);
                if (name != null) {
                    JavaScriptDataViewsConfigurableUi.this.propertiesListModel.add((Object)name);
                }
            }
        }).disableUpAction().disableDownAction().createPanel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/debugger/settings/JavaScriptDataViewsConfigurableUi";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/debugger/settings/JavaScriptDataViewsConfigurableUi";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.createUIComponents();
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myEnableAlternativeObjectView = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/JSDebuggerBundle").getString("checkbox.text.show.the.following.properties.for.object.node"));
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel2 = this.propertiesPanel;
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

