/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.StepDefinitionCreator;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;

public abstract class AbstractStepDefinitionCreator
implements StepDefinitionCreator {
    @Override
    @NotNull
    public String getStepDefinitionFilePath(@NotNull PsiFile psiFile) {
        String name;
        if (psiFile == null) {
            AbstractStepDefinitionCreator.$$$reportNull$$$0(0);
        }
        VirtualFile file = psiFile.getVirtualFile();
        assert (file != null);
        VirtualFile parent = file.getParent();
        if (parent != null && "step_definitions".equals(parent.getName())) {
            String string = file.getName();
            if (string == null) {
                AbstractStepDefinitionCreator.$$$reportNull$$$0(1);
            }
            return string;
        }
        ArrayList<String> dirsReversed = new ArrayList<String>();
        while (parent != null && !"step_definitions".equals(name = parent.getName())) {
            dirsReversed.add(name);
            parent = parent.getParent();
        }
        StringBuilder buf = new StringBuilder();
        for (int i = dirsReversed.size() - 1; i >= 0; --i) {
            buf.append((String)dirsReversed.get(i)).append(File.separatorChar);
        }
        buf.append(file.getName());
        String string = buf.toString();
        if (string == null) {
            AbstractStepDefinitionCreator.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public PsiDirectory getDefaultStepDefinitionFolder(@NotNull GherkinStep step) {
        PsiFile featureFile;
        PsiDirectory dir;
        if (step == null) {
            AbstractStepDefinitionCreator.$$$reportNull$$$0(3);
        }
        if ((dir = AbstractStepDefinitionCreator.findStepDefinitionDirectory(featureFile = step.getContainingFile())) == null) {
            final PsiDirectory featureParentDir = featureFile.getParent();
            assert (featureParentDir != null);
            final Ref dirRef = new Ref();
            new WriteCommandAction.Simple(step.getProject(), CucumberBundle.message("cucumber.quick.fix.create.step.command.name.add", new Object[0]), new PsiFile[0]){

                protected void run() throws Throwable {
                    dirRef.set((Object)featureParentDir.createSubdirectory("step_definitions"));
                }
            }.execute();
            PsiDirectory psiDirectory = (PsiDirectory)dirRef.get();
            if (psiDirectory == null) {
                AbstractStepDefinitionCreator.$$$reportNull$$$0(4);
            }
            return psiDirectory;
        }
        PsiDirectory psiDirectory = dir;
        if (psiDirectory == null) {
            AbstractStepDefinitionCreator.$$$reportNull$$$0(5);
        }
        return psiDirectory;
    }

    @Nullable
    private static PsiDirectory findStepDefinitionDirectory(@NotNull PsiFile featureFile) {
        VirtualFile stepsDir;
        VirtualFile featureDir;
        if (featureFile == null) {
            AbstractStepDefinitionCreator.$$$reportNull$$$0(6);
        }
        PsiDirectory psiFeatureDir = featureFile.getContainingDirectory();
        assert (psiFeatureDir != null);
        VirtualFile contentRoot = ProjectRootManager.getInstance((Project)featureFile.getProject()).getFileIndex().getContentRootForFile(featureDir);
        for (featureDir = psiFeatureDir.getVirtualFile(); featureDir != null && !Comparing.equal((Object)featureDir, (Object)contentRoot) && featureDir.findChild("step_definitions") == null; featureDir = featureDir.getParent()) {
        }
        if (featureDir != null && (stepsDir = featureDir.findChild("step_definitions")) != null) {
            return featureFile.getManager().findDirectory(stepsDir);
        }
        return null;
    }

    protected void closeActiveTemplateBuilders(PsiFile file) {
        Project project = file.getProject();
        VirtualFile vFile = (VirtualFile)ObjectUtils.assertNotNull((Object)file.getVirtualFile());
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, vFile);
        FileEditorManager.getInstance((Project)project).getAllEditors(vFile);
        FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        assert (editor != null);
        TemplateManager templateManager = TemplateManager.getInstance((Project)file.getProject());
        TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)editor);
        Template template = templateManager.getActiveTemplate(editor);
        if (templateState != null && template != null) {
            templateState.gotoEnd(false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/AbstractStepDefinitionCreator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/AbstractStepDefinitionCreator";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStepDefinitionFilePath";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultStepDefinitionFolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStepDefinitionFilePath";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultStepDefinitionFolder";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findStepDefinitionDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

