/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.inspections.ui;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.inspections.model.CreateStepDefinitionFileModel;
import org.jetbrains.plugins.cucumber.inspections.model.FileTypeComboboxItem;
import org.jetbrains.plugins.cucumber.steps.CucumberStepsIndex;

public class CreateStepDefinitionFileDialog
extends DialogWrapper {
    private JTextField myFileNameTextField;
    private JComboBox myFileTypeCombobox;
    private JPanel myContentPanel;
    private TextFieldWithBrowseButton myDirectoryTextField;
    private InputValidator myValidator;
    private CreateStepDefinitionFileModel myModel;

    public CreateStepDefinitionFileDialog(@NotNull Project project, final @NotNull CreateStepDefinitionFileModel model, @NotNull InputValidator validator) {
        if (project == null) {
            CreateStepDefinitionFileDialog.$$$reportNull$$$0(0);
        }
        if (model == null) {
            CreateStepDefinitionFileDialog.$$$reportNull$$$0(1);
        }
        if (validator == null) {
            CreateStepDefinitionFileDialog.$$$reportNull$$$0(2);
        }
        super(project);
        this.myModel = model;
        this.myValidator = validator;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(CucumberBundle.message("cucumber.quick.fix.create.step.choose.new.file.dialog.title", objectArray));
        this.init();
        this.myFileTypeCombobox.setModel(model.getFileTypeModel());
        this.myFileTypeCombobox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FileTypeComboboxItem newItem = (FileTypeComboboxItem)CreateStepDefinitionFileDialog.this.myFileTypeCombobox.getSelectedItem();
                FileTypeComboboxItem oldItem = (FileTypeComboboxItem)e.getItem();
                if (oldItem.getDefaultFileName().equals(CreateStepDefinitionFileDialog.this.myFileNameTextField.getText())) {
                    CreateStepDefinitionFileDialog.this.myFileNameTextField.setText(newItem.getDefaultFileName());
                    CreateStepDefinitionFileDialog.this.myModel.setFileName(newItem.getDefaultFileName());
                }
                CreateStepDefinitionFileDialog.this.myDirectoryTextField.setText(FileUtil.toSystemDependentName((String)model.getDefaultDirectory().getVirtualFile().getPath()));
            }
        });
        this.myFileNameTextField.setText(model.getFileName());
        FileNameKeyListener keyListener = new FileNameKeyListener();
        this.myFileNameTextField.addKeyListener(keyListener);
        String folderChooserTitle = CucumberBundle.message("cucumber.quick.fix.create.step.folder.chooser.title", new Object[0]);
        FileChooserDescriptor folderChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        folderChooserDescriptor.setTitle(folderChooserTitle);
        folderChooserDescriptor.setRoots(new VirtualFile[]{model.getDirectory().getVirtualFile()});
        folderChooserDescriptor.withTreeRootVisible(true);
        folderChooserDescriptor.setShowFileSystemRoots(false);
        folderChooserDescriptor.setHideIgnored(true);
        this.myDirectoryTextField.addBrowseFolderListener(folderChooserTitle, null, project, folderChooserDescriptor);
        this.myDirectoryTextField.getTextField().addKeyListener(keyListener);
        this.myDirectoryTextField.setText(FileUtil.toSystemDependentName((String)model.getDefaultDirectory().getVirtualFile().getPath()));
        this.validateAll();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myFileNameTextField;
    }

    protected void doOKAction() {
        String fileName = this.myFileNameTextField.getText();
        if (this.myValidator == null) {
            this.close(0);
        } else if (this.myValidator.checkInput(fileName) && this.myValidator.canClose(fileName)) {
            this.myModel.setFileName(this.myFileNameTextField.getText());
            this.close(0);
        }
    }

    protected JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return CreateStepDefinitionFileDialog.class.getName();
    }

    protected boolean validateAll() {
        if (this.validateFileName()) {
            return this.validateDirectoryPath();
        }
        return false;
    }

    protected boolean validateFileName() {
        boolean fileNameIsOk;
        String fileName = this.myFileNameTextField.getText();
        Project project = this.myModel.getDirectory().getProject();
        boolean bl = fileNameIsOk = fileName != null && CucumberStepsIndex.getInstance(project).validateNewStepDefinitionFileName(this.myModel.getDirectory(), fileName, this.myModel.getSelectedFileType());
        if (!fileNameIsOk) {
            this.setErrorText(CucumberBundle.message("cucumber.quick.fix.create.step.file.error.incorrect.file.name", new Object[0]), this.myFileNameTextField);
        } else {
            VirtualFile vFile;
            PsiFile file = this.myModel.getDirectory().findFile(this.myModel.getFileNameWithExtension());
            VirtualFile virtualFile = vFile = file != null ? file.getVirtualFile() : null;
            if (vFile != null) {
                fileNameIsOk = false;
                this.setErrorText(CucumberBundle.message("cucumber.quick.fix.create.step.file.error.file.exists", this.myModel.getFileNameWithExtension()), this.myFileNameTextField);
            }
        }
        return fileNameIsOk;
    }

    protected boolean validateDirectoryPath() {
        boolean directoryIsOk;
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(this.myDirectoryTextField.getText());
        boolean bl = directoryIsOk = vFile != null && vFile.exists();
        if (!directoryIsOk) {
            this.setErrorText(CucumberBundle.message("cucumber.quick.fix.create.step.file.error.directory.doesnt.exist", new Object[0]), (JComponent)this.myDirectoryTextField);
        } else {
            this.setErrorText(null);
        }
        this.setOKActionEnabled(directoryIsOk);
        return directoryIsOk;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "model";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "validator";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/cucumber/inspections/ui/CreateStepDefinitionFileDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JComboBox jComboBox;
        JTextField jTextField;
        JPanel jPanel;
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new FormLayout("fill:87px:noGrow,left:4dlu:noGrow,fill:max(p;100px):grow,left:4dlu:noGrow,fill:57px:noGrow,left:4dlu:noGrow,fill:max(m;106px):noGrow", "center:25px:noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow"));
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalAlignment(10);
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/jetbrains/plugins/cucumber/CucumberBundle").getString("cucumber.quick.fix.create.step.choose.new.file.dialog.label.file.name"));
        jPanel.add((Component)jLabel, new CellConstraints(1, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myFileNameTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new CellConstraints(3, 1, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("org/jetbrains/plugins/cucumber/CucumberBundle").getString("cucumber.quick.fix.create.step.choose.new.file.dialog.label.file.type"));
        jPanel.add((Component)jLabel2, new CellConstraints(5, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myFileTypeCombobox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new CellConstraints(7, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myDirectoryTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new CellConstraints(3, 3, 5, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("org/jetbrains/plugins/cucumber/CucumberBundle").getString("cucumber.quick.fix.create.step.choose.new.file.dialog.label.file.location"));
        jPanel.add((Component)jLabel3, new CellConstraints(1, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        jLabel.setLabelFor(jTextField);
        jLabel2.setLabelFor(jComboBox);
        jLabel3.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    class FileNameKeyListener
    implements KeyListener {
        FileNameKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            PsiDirectory psiDirectory;
            CreateStepDefinitionFileDialog.this.myModel.setFileName(CreateStepDefinitionFileDialog.this.myFileNameTextField.getText());
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(CreateStepDefinitionFileDialog.this.myDirectoryTextField.getText());
            if (vFile != null && (psiDirectory = PsiManager.getInstance((Project)CreateStepDefinitionFileDialog.this.myModel.getProject()).findDirectory(vFile)) != null) {
                CreateStepDefinitionFileDialog.this.myModel.setDirectory(psiDirectory);
            }
            CreateStepDefinitionFileDialog.this.validateAll();
        }
    }
}

