/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.psi.GherkinElementTypes;
import org.jetbrains.plugins.cucumber.psi.GherkinStepsHolder;
import org.jetbrains.plugins.cucumber.psi.GherkinTokenTypes;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinExamplesBlockImpl;

public class GherkinFoldingBuilder
implements FoldingBuilder,
DumbAware {
    private static final TokenSet BLOCKS_TO_FOLD = TokenSet.create((IElementType[])new IElementType[]{GherkinElementTypes.SCENARIO, GherkinElementTypes.SCENARIO_OUTLINE, GherkinElementTypes.EXAMPLES_BLOCK, GherkinTokenTypes.PYSTRING});

    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull ASTNode node, @NotNull Document document) {
        if (node == null) {
            GherkinFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (document == null) {
            GherkinFoldingBuilder.$$$reportNull$$$0(1);
        }
        ArrayList<FoldingDescriptor> descriptors = new ArrayList<FoldingDescriptor>();
        this.appendDescriptors(node, descriptors);
        FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(new FoldingDescriptor[descriptors.size()]);
        if (foldingDescriptorArray == null) {
            GherkinFoldingBuilder.$$$reportNull$$$0(2);
        }
        return foldingDescriptorArray;
    }

    private void appendDescriptors(ASTNode node, List<FoldingDescriptor> descriptors) {
        if (BLOCKS_TO_FOLD.contains(node.getElementType()) && node.getTextRange().getLength() >= 2) {
            descriptors.add(new FoldingDescriptor(node, node.getTextRange()));
        }
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            this.appendDescriptors(child, descriptors);
        }
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            GherkinFoldingBuilder.$$$reportNull$$$0(3);
        }
        if (node.getPsi() instanceof GherkinStepsHolder || node.getPsi() instanceof GherkinExamplesBlockImpl) {
            return ((NavigationItem)node.getPsi()).getPresentation().getPresentableText();
        }
        return "...";
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            GherkinFoldingBuilder.$$$reportNull$$$0(4);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/psi/GherkinFoldingBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/psi/GherkinFoldingBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

