/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi.refactoring.rename;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.refactoring.rename.CucumberStepRenameDialog;

public class GherkinStepRenameHandler
extends PsiElementRenameHandler {
    public boolean isAvailableOnDataContext(DataContext dataContext) {
        GherkinStep element = this.getGherkinStep(dataContext);
        return element != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        GherkinStep step;
        if (project == null) {
            GherkinStepRenameHandler.$$$reportNull$$$0(0);
        }
        if ((step = this.getGherkinStep(dataContext)) == null) {
            return;
        }
        if (!step.isRenameAllowed(null)) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)GherkinStep.RENAME_DISABLED_MESSAGE, (String)"", null);
            return;
        }
        CucumberStepRenameDialog dialog = new CucumberStepRenameDialog(project, step, null, editor);
        Disposer.register((Disposable)project, (Disposable)dialog.getDisposable());
        RenameDialog.showRenameDialog((DataContext)dataContext, (RenameDialog)dialog);
    }

    public boolean isRenaming(DataContext dataContext) {
        GherkinStep element = this.getGherkinStep(dataContext);
        return element != null;
    }

    @Nullable
    public GherkinStep getGherkinStep(@Nullable DataContext context) {
        PsiFile psiFile;
        PsiElement element = null;
        if (context == null) {
            return null;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        if (editor != null && (psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(context)) != null) {
            element = psiFile.findElementAt(editor.getCaretModel().getOffset());
        }
        if (element == null) {
            element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
        }
        return element instanceof GherkinStep ? (GherkinStep)element : (GherkinStep)PsiTreeUtil.getParentOfType((PsiElement)element, GherkinStep.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/cucumber/psi/refactoring/rename/GherkinStepRenameHandler", "invoke"));
    }
}

