/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.DefaultFileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.DirectoryFileSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshotVisitor;
import org.gradle.api.internal.changedetection.state.MissingFileSnapshot;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.RegularFileSnapshot;
import org.gradle.api.internal.changedetection.state.SnapshotNormalizationStrategy;
import org.gradle.api.internal.changedetection.state.TaskFilePropertyCompareStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCollectionSnapshotBuilder
implements FileSnapshotVisitor {
    private final Map<String, NormalizedFileSnapshot> snapshots = Maps.newLinkedHashMap();
    private final SnapshotNormalizationStrategy snapshotNormalizationStrategy;
    private final StringInterner stringInterner;
    private final TaskFilePropertyCompareStrategy compareStrategy;

    public FileCollectionSnapshotBuilder(TaskFilePropertyCompareStrategy compareStrategy, SnapshotNormalizationStrategy snapshotNormalizationStrategy, StringInterner stringInterner) {
        this.snapshotNormalizationStrategy = snapshotNormalizationStrategy;
        this.stringInterner = stringInterner;
        this.compareStrategy = compareStrategy;
    }

    @Override
    public void visitFileTreeSnapshot(List<FileSnapshot> descendants) {
        for (FileSnapshot fileSnapshot : descendants) {
            this.collectFileSnapshot(fileSnapshot);
        }
    }

    @Override
    public void visitDirectorySnapshot(DirectoryFileSnapshot directory) {
        this.collectFileSnapshot(directory);
    }

    @Override
    public void visitFileSnapshot(RegularFileSnapshot file) {
        this.collectFileSnapshot(file);
    }

    @Override
    public void visitMissingFileSnapshot(MissingFileSnapshot missingFile) {
        this.collectFileSnapshot(missingFile);
    }

    protected void collectFileSnapshot(FileSnapshot fileSnapshot) {
        String absolutePath = fileSnapshot.getPath();
        if (!this.snapshots.containsKey(absolutePath)) {
            NormalizedFileSnapshot normalizedSnapshot = this.snapshotNormalizationStrategy.getNormalizedSnapshot(fileSnapshot, this.stringInterner);
            this.collectNormalizedFileSnapshot(absolutePath, normalizedSnapshot);
        }
    }

    public void collectNormalizedFileSnapshot(String absolutePath, NormalizedFileSnapshot normalizedSnapshot) {
        if (normalizedSnapshot != null && !this.snapshots.containsKey(absolutePath)) {
            this.snapshots.put(absolutePath, normalizedSnapshot);
        }
    }

    public FileCollectionSnapshot build() {
        if (this.snapshots.isEmpty()) {
            return FileCollectionSnapshot.EMPTY;
        }
        return new DefaultFileCollectionSnapshot(this.snapshots, this.compareStrategy, this.snapshotNormalizationStrategy.isPathAbsolute());
    }
}

