/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Task;
import org.gradle.api.internal.ExceptionAnalyser;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.configuration.BuildConfigurer;
import org.gradle.execution.BuildConfigurationActionExecuter;
import org.gradle.execution.BuildExecuter;
import org.gradle.execution.TaskGraphExecuter;
import org.gradle.initialization.BuildCompletionListener;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.InitScriptHandler;
import org.gradle.initialization.ModelConfigurationListener;
import org.gradle.initialization.ReportedException;
import org.gradle.initialization.SettingsLoader;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.progress.BuildOperationDescriptor;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.service.scopes.BuildScopeServices;
import org.gradle.internal.taskgraph.CalculateTaskGraphBuildOperationType;
import org.gradle.internal.work.WorkerLeaseService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGradleLauncher
implements GradleLauncher {
    private final InitScriptHandler initScriptHandler;
    private final SettingsLoader settingsLoader;
    private final BuildConfigurer buildConfigurer;
    private final ExceptionAnalyser exceptionAnalyser;
    private final BuildListener buildListener;
    private final ModelConfigurationListener modelConfigurationListener;
    private final BuildCompletionListener buildCompletionListener;
    private final BuildOperationExecutor buildOperationExecutor;
    private final BuildConfigurationActionExecuter buildConfigurationActionExecuter;
    private final BuildExecuter buildExecuter;
    private final BuildScopeServices buildServices;
    private final List<?> servicesToStop;
    private GradleInternal gradle;
    private SettingsInternal settings;
    private Stage stage;

    public DefaultGradleLauncher(GradleInternal gradle, InitScriptHandler initScriptHandler, SettingsLoader settingsLoader, BuildConfigurer buildConfigurer, ExceptionAnalyser exceptionAnalyser, BuildListener buildListener, ModelConfigurationListener modelConfigurationListener, BuildCompletionListener buildCompletionListener, BuildOperationExecutor operationExecutor, BuildConfigurationActionExecuter buildConfigurationActionExecuter, BuildExecuter buildExecuter, BuildScopeServices buildServices, List<?> servicesToStop) {
        this.gradle = gradle;
        this.initScriptHandler = initScriptHandler;
        this.settingsLoader = settingsLoader;
        this.buildConfigurer = buildConfigurer;
        this.exceptionAnalyser = exceptionAnalyser;
        this.buildListener = buildListener;
        this.modelConfigurationListener = modelConfigurationListener;
        this.buildOperationExecutor = operationExecutor;
        this.buildConfigurationActionExecuter = buildConfigurationActionExecuter;
        this.buildExecuter = buildExecuter;
        this.buildCompletionListener = buildCompletionListener;
        this.buildServices = buildServices;
        this.servicesToStop = servicesToStop;
    }

    @Override
    public GradleInternal getGradle() {
        return this.gradle;
    }

    @Override
    public SettingsInternal getSettings() {
        return this.settings;
    }

    @Override
    public BuildResult run() {
        return this.doBuild(Stage.Build);
    }

    @Override
    public BuildResult getBuildAnalysis() {
        return this.doBuild(Stage.Configure);
    }

    @Override
    public BuildResult load() throws ReportedException {
        return this.doBuild(Stage.Load);
    }

    private BuildResult doBuild(final Stage upTo) {
        final AtomicReference buildResult = new AtomicReference();
        WorkerLeaseService workerLeaseService = (WorkerLeaseService)this.buildServices.get(WorkerLeaseService.class);
        workerLeaseService.withLocks(new ResourceLock[]{workerLeaseService.getWorkerLease()}).execute(new Runnable(){

            public void run() {
                Throwable failure = null;
                try {
                    DefaultGradleLauncher.this.buildListener.buildStarted(DefaultGradleLauncher.this.gradle);
                    DefaultGradleLauncher.this.doBuildStages(upTo);
                }
                catch (Throwable t) {
                    failure = DefaultGradleLauncher.this.exceptionAnalyser.transform(t);
                }
                buildResult.set(new BuildResult(upTo.name(), DefaultGradleLauncher.this.gradle, failure));
                DefaultGradleLauncher.this.buildListener.buildFinished((BuildResult)buildResult.get());
                if (failure != null) {
                    throw new ReportedException(failure);
                }
            }
        });
        return (BuildResult)buildResult.get();
    }

    private void doBuildStages(Stage upTo) {
        if (this.stage == Stage.Build) {
            throw new IllegalStateException("Cannot build with GradleLauncher multiple times");
        }
        if (this.stage == null) {
            this.initScriptHandler.executeScripts(this.gradle);
            this.settings = this.settingsLoader.findAndLoadSettings(this.gradle);
            this.stage = Stage.Load;
        }
        if (upTo == Stage.Load) {
            return;
        }
        if (this.stage == Stage.Load) {
            this.buildOperationExecutor.run((RunnableBuildOperation)new ConfigureBuild());
            this.stage = Stage.Configure;
        }
        if (upTo == Stage.Configure) {
            return;
        }
        this.stage = Stage.Build;
        this.buildOperationExecutor.run((RunnableBuildOperation)new CalculateTaskGraph());
        this.buildOperationExecutor.run((RunnableBuildOperation)new ExecuteTasks());
    }

    @Override
    public void addListener(Object listener) {
        this.gradle.addListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            CompositeStoppable.stoppable((Object[])new Object[]{this.buildServices}).add(this.servicesToStop).stop();
        }
        finally {
            this.buildCompletionListener.completed();
        }
    }

    private boolean isConfigureOnDemand() {
        return this.gradle.getStartParameter().isConfigureOnDemand();
    }

    private void projectsEvaluated() {
        this.buildListener.projectsEvaluated(this.gradle);
    }

    private class ExecuteTasks
    implements RunnableBuildOperation {
        private ExecuteTasks() {
        }

        public void run(BuildOperationContext context) {
            DefaultGradleLauncher.this.buildExecuter.execute(DefaultGradleLauncher.this.gradle);
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)"Run tasks");
        }
    }

    private class CalculateTaskGraph
    implements RunnableBuildOperation {
        private CalculateTaskGraph() {
        }

        public void run(BuildOperationContext buildOperationContext) {
            DefaultGradleLauncher.this.buildConfigurationActionExecuter.select(DefaultGradleLauncher.this.gradle);
            if (DefaultGradleLauncher.this.isConfigureOnDemand()) {
                DefaultGradleLauncher.this.projectsEvaluated();
            }
            final TaskGraphExecuter taskGraph = DefaultGradleLauncher.this.gradle.getTaskGraph();
            buildOperationContext.setResult((Object)new CalculateTaskGraphBuildOperationType.Result(){

                @Override
                public List<String> getRequestedTaskPaths() {
                    return this.toTaskPaths(taskGraph.getRequestedTasks());
                }

                @Override
                public List<String> getExcludedTaskPaths() {
                    return this.toTaskPaths(taskGraph.getFilteredTasks());
                }

                private List<String> toTaskPaths(Set<Task> tasks) {
                    return ImmutableSortedSet.copyOf((Collection)Collections2.transform(tasks, (Function)new Function<Task, String>(){

                        public String apply(Task task) {
                            return task.getPath();
                        }
                    })).asList();
                }
            });
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)"Calculate task graph").details((Object)new CalculateTaskGraphBuildOperationType.Details(){});
        }
    }

    private class ConfigureBuild
    implements RunnableBuildOperation {
        private ConfigureBuild() {
        }

        public void run(BuildOperationContext context) {
            DefaultGradleLauncher.this.buildConfigurer.configure(DefaultGradleLauncher.this.gradle);
            if (!DefaultGradleLauncher.this.isConfigureOnDemand()) {
                DefaultGradleLauncher.this.projectsEvaluated();
            }
            DefaultGradleLauncher.this.modelConfigurationListener.onConfigure(DefaultGradleLauncher.this.gradle);
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)"Configure build");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Stage {
        Load,
        Configure,
        Build;

    }
}

