/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cleanup;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.io.File;
import java.util.Collection;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.file.delete.Deleter;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.FileUtils;
import org.gradle.internal.cleanup.BuildOutputDeleter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBuildOutputDeleter
implements BuildOutputDeleter {
    public static final String STALE_OUTPUT_MESSAGE = "Gradle is removing stale outputs from a previous version of Gradle.";
    private final Logger logger = Logging.getLogger(DefaultBuildOutputDeleter.class);
    private final Deleter deleter;

    public DefaultBuildOutputDeleter(Deleter deleter) {
        this.deleter = deleter;
    }

    @Override
    public void delete(Iterable<File> outputs) {
        Collection roots = Collections2.filter((Collection)FileUtils.calculateRoots(outputs), (Predicate)new Predicate<File>(){

            public boolean apply(File file) {
                return file.exists();
            }
        });
        if (!roots.isEmpty()) {
            this.logger.info(STALE_OUTPUT_MESSAGE);
            for (File output : roots) {
                this.deleteOutput(output);
            }
        }
    }

    private void deleteOutput(File output) {
        try {
            if (output.isDirectory()) {
                this.deleter.delete(output);
                this.logger.info("Deleted directory '{}'", (Object)output);
            } else if (output.isFile()) {
                this.deleter.delete(output);
                this.logger.info("Deleted file '{}'", (Object)output);
            }
        }
        catch (UncheckedIOException e) {
            this.logger.warn("Unable to delete '{}'", (Object)output);
        }
    }
}

