/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence;

import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesFileProcessor;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.PersistenceMessages;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JdbcPropertiesDataSourceDetector
extends DataSourceDetector {
    public void collectDataSources(@NotNull Project project, final @NotNull DataSourceDetector.Builder builder) {
        if (project == null) {
            JdbcPropertiesDataSourceDetector.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            JdbcPropertiesDataSourceDetector.$$$reportNull$$$0(1);
        }
        PropertiesReferenceManager.getInstance((Project)project).processAllPropertiesFiles(new PropertiesFileProcessor(){

            public boolean process(String baseName, PropertiesFile propertiesFile) {
                builder.withName(propertiesFile.getVirtualFile().getNameWithoutExtension());
                JdbcPropertiesDataSourceDetector.collect(builder, DataSourceDetector.Property.DRIVER_CLASS, propertiesFile, PersistenceMessages.message((String)"import.aliases.jdbc.driver", (Object[])new Object[0]));
                JdbcPropertiesDataSourceDetector.collect(builder, DataSourceDetector.Property.URL, propertiesFile, PersistenceMessages.message((String)"import.aliases.jdbc.url", (Object[])new Object[0]));
                JdbcPropertiesDataSourceDetector.collect(builder, DataSourceDetector.Property.USERNAME, propertiesFile, PersistenceMessages.message((String)"import.aliases.jdbc.user", (Object[])new Object[0]));
                JdbcPropertiesDataSourceDetector.collect(builder, DataSourceDetector.Property.PASSWORD, propertiesFile, PersistenceMessages.message((String)"import.aliases.jdbc.password", (Object[])new Object[0]));
                builder.commit("jdbc.properties", (Object)propertiesFile.getContainingFile());
                return true;
            }
        });
    }

    private static void collect(@NotNull DataSourceDetector.Builder b, @NotNull DataSourceDetector.Property p, @NotNull PropertiesFile propertiesFile, @NonNls String keys) {
        if (b == null) {
            JdbcPropertiesDataSourceDetector.$$$reportNull$$$0(2);
        }
        if (p == null) {
            JdbcPropertiesDataSourceDetector.$$$reportNull$$$0(3);
        }
        if (propertiesFile == null) {
            JdbcPropertiesDataSourceDetector.$$$reportNull$$$0(4);
        }
        for (String key : StringUtil.split((String)keys, (String)",", (boolean)true, (boolean)true)) {
            IProperty property = propertiesFile.findPropertyByKey(key);
            if (property == null) continue;
            b.with(p, property.getValue());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/persistence/JdbcPropertiesDataSourceDetector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectDataSources";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "collect";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

