/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.persistence.model.manipulators.ManipulatorsRegistry;
import com.intellij.persistence.model.manipulators.PersistenceAction;
import com.intellij.persistence.model.manipulators.PersistenceManipulator;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.ModelMerger;
import com.intellij.util.xml.ModelMergerUtil;
import gnu.trove.THashSet;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ManipulatorsRegistryImpl
implements ManipulatorsRegistry {
    private final MultiValuesMap<Class, Function> myManipulatorsMap = new MultiValuesMap();
    private final ModelMerger myModelMerger = DomService.getInstance().createModelMerger();

    public ManipulatorsRegistryImpl() {
        Consumer[] extensions;
        for (Consumer extension : extensions = (Consumer[])Extensions.getExtensions((ExtensionPointName)EP_NAME)) {
            extension.consume((Object)this);
        }
        this.myModelMerger.addInvocationStrategy(PersistenceAction.class, (ModelMerger.InvocationStrategy)new ModelMerger.InvocationStrategy<PersistenceAction>(){

            public boolean accepts(Method method) {
                return PersistenceAction.class.equals(method.getDeclaringClass()) && Void.TYPE.equals(method.getReturnType());
            }

            public Object invokeMethod(JavaMethod method, PersistenceAction proxy, Object[] args, List<PersistenceAction> implementations) throws IllegalAccessException, InvocationTargetException {
                for (PersistenceAction implementation : implementations) {
                    if (!implementation.getPresentation().isEnabled()) continue;
                    method.invoke((Object)implementation, args);
                }
                return null;
            }
        });
        this.myModelMerger.addInvocationStrategy(PersistenceAction.class, (ModelMerger.InvocationStrategy)new ModelMerger.InvocationStrategy<PersistenceAction>(){

            public boolean accepts(Method method) {
                return PersistenceAction.class.equals(method.getDeclaringClass()) && Boolean.TYPE.equals(method.getReturnType());
            }

            public Object invokeMethod(JavaMethod method, PersistenceAction proxy, Object[] args, List<PersistenceAction> implementations) throws IllegalAccessException, InvocationTargetException {
                boolean result = true;
                for (PersistenceAction implementation : implementations) {
                    if (!implementation.getPresentation().isEnabled()) continue;
                    Object o = method.invoke((Object)implementation, args);
                    result = result && Boolean.TRUE.equals(o);
                }
                return result;
            }
        });
        this.myModelMerger.addMergingStrategy(PersistenceAction.class, (ModelMerger.MergingStrategy)new ModelMerger.MergingStrategy<PersistenceAction>(){

            public PersistenceAction mergeChildren(Class<PersistenceAction> type, List<PersistenceAction> implementations) {
                return (PersistenceAction)ManipulatorsRegistryImpl.this.myModelMerger.mergeModels(type, implementations);
            }
        });
    }

    public <N extends PersistenceManipulator> N getManipulator(Object element, Class<N> manipulatorClass) {
        THashSet manipulators = new THashSet();
        List implementations = ModelMergerUtil.getFilteredImplementations((Object)element);
        for (Object v : implementations) {
            this.getManipulatorsInternal(v, (Class)manipulatorClass, (Collection)manipulators);
        }
        return (N)(manipulators.isEmpty() ? null : (PersistenceManipulator)this.myModelMerger.mergeModels(manipulatorClass, (Collection)manipulators));
    }

    public <T> void registerManipulator(Class<? extends T> targetClass, Class<? extends PersistenceManipulator<T>> manipulatorClass) {
        class MyFactory<T>
        implements Function<T, PersistenceManipulator<T>> {
            private final Constructor<? extends PersistenceManipulator<T>> myConstructor;

            MyFactory(Class<? extends PersistenceManipulator<T>> clazz) {
                this.myConstructor = clazz.getConstructors()[0];
            }

            public PersistenceManipulator<T> fun(T t) {
                try {
                    return this.myConstructor.newInstance(t);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getTargetException();
                    ExceptionUtil.rethrowUnchecked((Throwable)cause);
                    assert (false) : cause;
                    return null;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    assert (false) : e;
                    return null;
                }
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                MyFactory myFactory = (MyFactory)o;
                return this.myConstructor.equals(myFactory.myConstructor);
            }

            public int hashCode() {
                return this.myConstructor.hashCode();
            }
        }
        this.myManipulatorsMap.put(targetClass, new MyFactory(manipulatorClass));
    }

    public PersistenceAction getMergedPersistenceAction(Collection<PersistenceAction> actions) {
        return (PersistenceAction)this.myModelMerger.mergeModels(PersistenceAction.class, actions);
    }

    private <T, V extends T> void getManipulatorsInternal(Object element, Class<V> manipulatorClass, Collection<T> manipulators) {
        Class<?> thisClass = element.getClass();
        for (Map.Entry entry : this.myManipulatorsMap.entrySet()) {
            if (!ReflectionUtil.isAssignable((Class)((Class)entry.getKey()), thisClass)) continue;
            for (Function function : (Collection)entry.getValue()) {
                Object o = function.fun(element);
                if (!ReflectionUtil.isAssignable(manipulatorClass, o.getClass())) continue;
                manipulators.add(o);
            }
        }
    }
}

