/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.view;

import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.j2ee.openapi.ex.DeploymentManagerEx;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentStatus;
import com.intellij.javaee.deployment.JavaeeDeploymentListener;
import com.intellij.javaee.oss.agent.DeploymentData;
import com.intellij.javaee.oss.server.JavaeeServerDeployExtension;
import com.intellij.javaee.oss.server.JavaeeServerExtension;
import com.intellij.javaee.oss.server.JavaeeServerInstance;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.run.execution.J2EEProcess;
import com.intellij.javaee.serverInstances.J2EEServerEvent;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.javaee.serverInstances.J2EEServerStateListener;
import com.intellij.javaee.view.ServerProcessState;
import com.intellij.javaee.view.ServersConfigManagerListener;
import com.intellij.javaee.view.tool.ArtifactSyncTracker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServersConfigManager {
    private static final int DEPLOYMENTS_POLL_DELAY = 1000;
    private final Project myProject;
    private final ArtifactSyncTracker myArtifactSyncTracker;
    private final Map<CommonModel, ServerData> myServer2Data = new HashMap<CommonModel, ServerData>();
    private final Alarm myAlarm = new Alarm();
    private ServersConfigManagerListener myListener = ServersConfigManagerListener.NULL;

    public static ServersConfigManager getInstance(@NotNull Project project) {
        if (project == null) {
            ServersConfigManager.$$$reportNull$$$0(0);
        }
        return (ServersConfigManager)project.getComponent(ServersConfigManager.class);
    }

    public ServersConfigManager(Project project) {
        this.myProject = project;
        this.myArtifactSyncTracker = new ArtifactSyncTracker(project);
        this.myProject.getMessageBus().connect().subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

            public void processStarting(@NotNull String executorId, @NotNull ExecutionEnvironment env) {
                if (executorId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (env == null) {
                    1.$$$reportNull$$$0(1);
                }
                new StateSetter().set(env, ServerProcessState.STARTING);
            }

            public void processNotStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env) {
                if (executorId == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (env == null) {
                    1.$$$reportNull$$$0(3);
                }
                new StateSetter().set(env, null);
            }

            public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, final @NotNull ProcessHandler handler) {
                if (executorId == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (env == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (handler == null) {
                    1.$$$reportNull$$$0(6);
                }
                new StateSetter(){

                    @Override
                    protected void onSet(CommonStrategy server, ServerData serverData) {
                        serverData.setProcessHandler(handler);
                        if (handler instanceof J2EEProcess) {
                            J2EEServerInstance serverInstance = ((J2EEProcess)handler).getServerInstance();
                            serverData.setInstance(serverInstance);
                            ServersConfigManager.this.startListeningServer(server, serverInstance);
                        }
                    }
                }.set(env, ServerProcessState.RUNNING);
            }

            public void processTerminating(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler) {
                if (executorId == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (env == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (handler == null) {
                    1.$$$reportNull$$$0(9);
                }
                new StateSetter().set(env, ServerProcessState.TERMINATING);
            }

            public void processTerminated(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler, int exitCode) {
                if (executorId == null) {
                    1.$$$reportNull$$$0(10);
                }
                if (env == null) {
                    1.$$$reportNull$$$0(11);
                }
                if (handler == null) {
                    1.$$$reportNull$$$0(12);
                }
                new StateSetter().set(env, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executorId";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 8: 
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "env";
                        break;
                    }
                    case 6: 
                    case 9: 
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "handler";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/javaee/view/ServersConfigManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processStarting";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processNotStarted";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processStarted";
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminating";
                        break;
                    }
                    case 10: 
                    case 11: 
                    case 12: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void startListeningServer(final CommonStrategy server, final J2EEServerInstance serverInstance) {
        serverInstance.addServerListener(new J2EEServerStateListener(){

            public void serverStateChanged(final J2EEServerEvent event) {
                new ServerDataUpdater(){

                    @Override
                    protected void doUpdate(ServerData serverData) {
                        boolean connected = event.isStateRunning();
                        serverData.setConnected(connected);
                        ServersConfigManager.this.myListener.serverConnectStateChanged(server);
                        if (connected) {
                            JavaeeServerExtension serverExtension = serverInstance instanceof JavaeeServerInstance ? ((JavaeeServerInstance)serverInstance).getExtension() : null;
                            serverData.setExtension(serverExtension);
                            if (serverExtension != null) {
                                ServersConfigManager.this.updateDeployments(server, serverInstance);
                            }
                        }
                    }
                }.update(server);
            }
        });
        DeploymentManagerEx.getInstanceEx((Project)this.myProject).addDeploymentListener(serverInstance, new JavaeeDeploymentListener(){

            public void deploymentStatusChanged(final DeploymentModel model, final DeploymentStatus newStatus, final CommonModel runConfiguration) {
                new ServerDataUpdater(){

                    @Override
                    protected void doUpdate(ServerData serverData) {
                        JavaeeServerDeployExtension serverExtension = ServersConfigManager.this.getServerExtension(runConfiguration);
                        DeploymentData[] deployments = serverData.getDeployments();
                        if (serverExtension != null && deployments != null) {
                            String deploymentName = serverExtension.getDeploymentName(model);
                            for (DeploymentData deployment : deployments) {
                                if (!deploymentName.equals(deployment.getName())) continue;
                                deployment.setStarted(DeploymentStatus.DEPLOYED.equals((Object)newStatus));
                                break;
                            }
                        }
                        CommonStrategy server = (CommonStrategy)runConfiguration;
                        ServersConfigManager.this.getArtifactSyncTracker().updateDeploymentSync(server, model, newStatus);
                        ServersConfigManager.this.myListener.deploymentStatusChangeNotified(server, model);
                    }
                }.update((CommonStrategy)runConfiguration);
            }
        });
    }

    public void updateDeployments(CommonStrategy server) {
        this.updateDeployments(server, null);
    }

    private void updateDeployments(final CommonStrategy server, final @Nullable J2EEServerInstance pollingServerInstance) {
        JavaeeServerDeployExtension serverExtension = this.getServerExtension((CommonModel)server);
        if (serverExtension != null) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                final DeploymentData[] deployments = serverExtension.getDeployments();
                new ServerDataUpdater(){

                    @Override
                    protected void doUpdate(ServerData serverData) {
                        serverData.setDeployments(deployments);
                        ServersConfigManager.this.myListener.serverDeploymentsQueued(server);
                        ServersConfigManager.this.myAlarm.addRequest(() -> {
                            if (pollingServerInstance != null && ServersConfigManager.this.isServerConnected((CommonModel)server) && ServersConfigManager.this.getServerInstance((CommonModel)server) == pollingServerInstance) {
                                ServersConfigManager.this.updateDeployments(server, pollingServerInstance);
                            }
                        }, 1000);
                    }
                }.update(server);
            });
        }
    }

    public void setListener(ServersConfigManagerListener listener) {
        this.myListener = listener;
    }

    @Nullable
    public ServerProcessState getServerProcessState(CommonModel server) {
        ServerData serverData = this.myServer2Data.get(server);
        return serverData == null ? null : serverData.getProcessState();
    }

    public boolean isServerConnected(CommonModel server) {
        ServerData serverData = this.myServer2Data.get(server);
        return serverData != null && serverData.isConnected();
    }

    @Nullable
    public JavaeeServerDeployExtension getServerExtension(CommonModel server) {
        ServerData serverData = this.myServer2Data.get(server);
        if (serverData == null) {
            return null;
        }
        JavaeeServerExtension extension = serverData.getExtension();
        return (JavaeeServerDeployExtension)ObjectUtils.tryCast((Object)extension, JavaeeServerDeployExtension.class);
    }

    @Nullable
    public DeploymentData[] getDeployments(CommonModel server) {
        ServerData serverData = this.myServer2Data.get(server);
        return serverData == null ? null : serverData.getDeployments();
    }

    @Nullable
    public J2EEServerInstance getServerInstance(CommonModel server) {
        ServerData serverData = this.myServer2Data.get(server);
        return serverData == null ? null : serverData.getInstance();
    }

    @Nullable
    public ProcessHandler getServerProcessHandler(CommonModel server) {
        ServerData serverData = this.myServer2Data.get(server);
        return serverData == null ? null : serverData.getProcessHandler();
    }

    public ArtifactSyncTracker getArtifactSyncTracker() {
        return this.myArtifactSyncTracker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/view/ServersConfigManager", "getInstance"));
    }

    private static class ServerData {
        private ServerProcessState myProcessState;
        private boolean myConnected = false;
        private DeploymentData[] myDeployments;
        private JavaeeServerExtension myExtension;
        private J2EEServerInstance myInstance;
        private ProcessHandler myProcessHandler;

        private ServerData() {
        }

        public ServerProcessState getProcessState() {
            return this.myProcessState;
        }

        public void setProcessState(ServerProcessState processState) {
            this.myProcessState = processState;
        }

        public boolean isConnected() {
            return this.myConnected;
        }

        public void setConnected(boolean connected) {
            this.myConnected = connected;
        }

        public DeploymentData[] getDeployments() {
            return this.myDeployments;
        }

        public void setDeployments(DeploymentData[] deployments) {
            this.myDeployments = deployments;
        }

        public JavaeeServerExtension getExtension() {
            return this.myExtension;
        }

        public void setExtension(JavaeeServerExtension extension) {
            this.myExtension = extension;
        }

        public J2EEServerInstance getInstance() {
            return this.myInstance;
        }

        public void setInstance(J2EEServerInstance instance) {
            this.myInstance = instance;
        }

        public ProcessHandler getProcessHandler() {
            return this.myProcessHandler;
        }

        public void setProcessHandler(ProcessHandler handler) {
            this.myProcessHandler = handler;
        }
    }

    private abstract class ServerDataUpdater {
        private ServerDataUpdater() {
        }

        public void update(CommonStrategy server) {
            SwingUtilities.invokeLater(() -> {
                ServerData serverData = (ServerData)ServersConfigManager.this.myServer2Data.get(server);
                if (serverData != null) {
                    this.doUpdate(serverData);
                }
            });
        }

        protected abstract void doUpdate(ServerData var1);
    }

    private class StateSetter {
        private StateSetter() {
        }

        public void set(ExecutionEnvironment env, @Nullable ServerProcessState state) {
            this.set(env.getRunProfile(), state);
        }

        public void set(RunProfile runProfile, @Nullable ServerProcessState state) {
            if (!(runProfile instanceof CommonStrategy)) {
                return;
            }
            CommonStrategy server = (CommonStrategy)runProfile;
            SwingUtilities.invokeLater(() -> {
                if (state == null) {
                    ServersConfigManager.this.myServer2Data.remove(server);
                } else {
                    ServerData serverData = (ServerData)ServersConfigManager.this.myServer2Data.get(server);
                    if (serverData == null) {
                        serverData = new ServerData();
                        ServersConfigManager.this.myServer2Data.put(server, serverData);
                    }
                    serverData.setProcessState(state);
                    this.onSet(server, serverData);
                }
                ServersConfigManager.this.myListener.serverProcessStateChanged(server);
            });
        }

        protected void onSet(CommonStrategy server, ServerData serverData) {
        }
    }
}

