/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.view.tool;

import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.oss.agent.DeploymentData;
import com.intellij.javaee.oss.server.JavaeeServerDeployExtension;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.javaee.view.ServerProcessState;
import com.intellij.javaee.view.ServersBundle;
import com.intellij.javaee.view.ServersConfigManager;
import com.intellij.javaee.view.tool.ArtifactNode;
import com.intellij.javaee.view.tool.ServerState;
import com.intellij.javaee.view.tool.action.DeploymentWorker;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServerNode;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeStructure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class AppServerNode
extends AbstractTreeNode<RunnerAndConfigurationSettings>
implements ServerNode {
    private static final Logger LOG = Logger.getInstance(AppServerNode.class);
    private Project myProject;

    public AppServerNode(Project project, RunnerAndConfigurationSettings settings) {
        super(project, (Object)settings);
        this.myProject = project;
    }

    public CommonStrategy getCommonStrategy() {
        return (CommonStrategy)((RunnerAndConfigurationSettings)this.getValue()).getConfiguration();
    }

    public boolean isConnected() {
        return this.getState() == ServerState.RUNNING && ServersConfigManager.getInstance(this.myProject).isServerConnected((CommonModel)this.getCommonStrategy());
    }

    public boolean isStopActionEnabled() {
        return this.getState() == ServerState.RUNNING;
    }

    public ServerState getState() {
        ServerProcessState processState = ServersConfigManager.getInstance(this.myProject).getServerProcessState((CommonModel)this.getCommonStrategy());
        if (processState == ServerProcessState.RUNNING) {
            return ServerState.RUNNING;
        }
        if (processState == ServerProcessState.STARTING) {
            return ServerState.STARTING;
        }
        if (processState == ServerProcessState.TERMINATING) {
            return ServerState.STOPPING;
        }
        return ServerState.STOPPED;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        CommonStrategy server = this.getCommonStrategy();
        JavaeeServerDeployExtension serverExtension = ServersConfigManager.getInstance(this.myProject).getServerExtension((CommonModel)server);
        Collection deploymentModels = server.getDeploymentModels();
        if (serverExtension != null) {
            TreeMap<String, ArtifactNode> deploymentName2Node = new TreeMap<String, ArtifactNode>();
            for (DeploymentData[] deploymentModel : deploymentModels) {
                String deploymentName = serverExtension.getDeploymentName((DeploymentModel)deploymentModel);
                deploymentName2Node.put(deploymentName, new ArtifactNode(this.myProject, deploymentName, (DeploymentModel)deploymentModel));
            }
            DeploymentData[] deployments = ServersConfigManager.getInstance(this.myProject).getDeployments((CommonModel)server);
            if (deployments != null) {
                for (DeploymentData deploymentData : deployments) {
                    String deploymentName = deploymentData.getName();
                    ArtifactNode artifactNode = (ArtifactNode)((Object)deploymentName2Node.get(deploymentName));
                    if (artifactNode == null) {
                        artifactNode = new ArtifactNode(this.myProject, deploymentName);
                        deploymentName2Node.put(deploymentName, artifactNode);
                    }
                    artifactNode.setStarted(deploymentData.isStarted());
                }
            }
            ArrayList arrayList = new ArrayList(deploymentName2Node.values());
            if (arrayList == null) {
                AppServerNode.$$$reportNull$$$0(0);
            }
            return arrayList;
        }
        ArrayList<ArtifactNode> result = new ArrayList<ArtifactNode>();
        for (DeploymentModel deploymentModel : deploymentModels) {
            result.add(new ArtifactNode(this.myProject, deploymentModel));
        }
        ArrayList<ArtifactNode> arrayList = result;
        if (arrayList == null) {
            AppServerNode.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    protected void update(PresentationData presentation) {
        ServerState state = this.getState();
        boolean isLocal = this.getCommonStrategy().isLocal();
        presentation.setPresentableText(ServersBundle.message("ServersTreeStructure.node.server", this.getCommonStrategy().getName(), isLocal ? ServersBundle.message("ServersTreeStructure.node.server.place.local", new Object[0]) : ServersBundle.message("ServersTreeStructure.node.server.place.remote", new Object[0])));
        Icon itemIcon = this.getCommonStrategy().getIcon();
        LOG.assertTrue(itemIcon != null, (Object)this.getCommonStrategy().getType());
        Icon statusIcon = state.getIcon();
        presentation.setIcon(ServersTreeStructure.getServerNodeIcon((Icon)itemIcon, (Icon)statusIcon));
    }

    public void stopServer() {
        ServersConfigManager configManager = ServersConfigManager.getInstance(this.myProject);
        ProcessHandler processHandler = configManager.getServerProcessHandler((CommonModel)this.getCommonStrategy());
        if (processHandler != null) {
            processHandler.destroyProcess();
        }
    }

    public boolean isStartActionEnabled(@NotNull Executor executor) {
        if (executor == null) {
            AppServerNode.$$$reportNull$$$0(2);
        }
        return this.getState() == ServerState.STOPPED && ProgramRunnerUtil.getRunner((String)executor.getId(), (RunnerAndConfigurationSettings)((RunnerAndConfigurationSettings)this.getValue())) != null;
    }

    public void startServer(@NotNull Executor executor) {
        if (executor == null) {
            AppServerNode.$$$reportNull$$$0(3);
        }
        ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)((RunnerAndConfigurationSettings)this.getValue()), (Executor)executor);
    }

    public boolean isDeployAllActionEnabled() {
        return this.isConnected();
    }

    public void deployAll() {
        CommonStrategy server;
        DeploymentWorker worker = new DeploymentWorker(this.myProject);
        ServersConfigManager configManager = ServersConfigManager.getInstance(this.myProject);
        J2EEServerInstance serverInstance = configManager.getServerInstance((CommonModel)(server = this.getCommonStrategy()));
        if (serverInstance != null) {
            for (DeploymentModel artifactDeploymentModel : server.getDeploymentModels()) {
                worker.addDeploymentItem(serverInstance, artifactDeploymentModel);
            }
        }
        worker.compileAndDeploy();
    }

    public void editConfiguration() {
        RunDialog.editConfiguration((Project)this.getProject(), (RunnerAndConfigurationSettings)((RunnerAndConfigurationSettings)this.getValue()), (String)ServersBundle.message("ServersToolWindowContent.action.edit.config.title", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/view/tool/AppServerNode";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/view/tool/AppServerNode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isStartActionEnabled";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "startServer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

