/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.i18n.GwtI18nManager;
import com.intellij.gwt.i18n.GwtI18nUtil;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.inspections.BaseGwtLocalQuickFix;
import com.intellij.gwt.rpc.GwtGenericsUtil;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class GwtDeprecatedPropertyKeyJavadocTagInspection
extends BaseGwtInspection {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.inspections.GwtDeprecatedPropertyKeyJavadocTagInspection");

    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        GwtFacet gwtFacet;
        if (aClass == null) {
            GwtDeprecatedPropertyKeyJavadocTagInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            GwtDeprecatedPropertyKeyJavadocTagInspection.$$$reportNull$$$0(1);
        }
        if ((gwtFacet = GwtDeprecatedPropertyKeyJavadocTagInspection.getFacet((PsiElement)aClass)) == null || !gwtFacet.getSdkVersion().isGenericsSupported()) {
            return null;
        }
        PropertiesFile[] files = GwtI18nManager.getInstance(manager.getProject()).getPropertiesFiles(aClass);
        if (files.length == 0) {
            return null;
        }
        return GwtDeprecatedPropertyKeyJavadocTagInspection.checkInterface(aClass, manager, isOnTheFly);
    }

    private static ProblemDescriptor[] checkInterface(PsiClass anInterface, InspectionManager manager, boolean isOnTheFly) {
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>();
        for (PsiMethod method : anInterface.getMethods()) {
            PsiDocTag tag;
            PsiDocComment comment = method.getDocComment();
            if (comment == null || (tag = comment.findTagByName("gwt.key")) == null) continue;
            ReplaceTagByAnnotationQuickFix fix = new ReplaceTagByAnnotationQuickFix(tag, method);
            String message = GwtBundle.message("problem.description.gwt.key.tag.is.deprecated.in.gwt.1.5", new Object[0]);
            problems.add(manager.createProblemDescriptor((PsiElement)tag, message, (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
        }
        return problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            GwtDeprecatedPropertyKeyJavadocTagInspection.$$$reportNull$$$0(2);
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public String getDisplayName() {
        String string = GwtBundle.message("inspection.name.deprecated.gwt.key.tag.in.javadoc.comments", new Object[0]);
        if (string == null) {
            GwtDeprecatedPropertyKeyJavadocTagInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("GwtDeprecatedPropertyKeyJavadocTag" == null) {
            GwtDeprecatedPropertyKeyJavadocTagInspection.$$$reportNull$$$0(4);
        }
        return "GwtDeprecatedPropertyKeyJavadocTag";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/inspections/GwtDeprecatedPropertyKeyJavadocTagInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/inspections/GwtDeprecatedPropertyKeyJavadocTagInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReplaceTagByAnnotationQuickFix
    extends BaseGwtLocalQuickFix {
        private static final String FAMILY_NAME = GwtBundle.message("quickfix.family.name.replace.gwt.key.tag.with.key.annotation", new Object[0]);
        private final PsiDocTag myTag;
        private final PsiMethod myMethod;

        public ReplaceTagByAnnotationQuickFix(PsiDocTag tag, PsiMethod method) {
            super(GwtBundle.message("quickfix.name.replace.gwt.key.tag.with.key.annotation.in.method.0", PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2)));
            this.myTag = tag;
            this.myMethod = method;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = FAMILY_NAME;
            if (string == null) {
                ReplaceTagByAnnotationQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                ReplaceTagByAnnotationQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ReplaceTagByAnnotationQuickFix.$$$reportNull$$$0(2);
            }
            String propertyName = this.myTag.getValueElement().getText();
            try {
                GwtI18nUtil.addKeyAnnotation(propertyName, this.myMethod, JavaPsiFacade.getInstance((Project)project).getElementFactory());
                GwtGenericsUtil.removeJavadocTags(this.myMethod, "gwt.key");
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/gwt/inspections/GwtDeprecatedPropertyKeyJavadocTagInspection$ReplaceTagByAnnotationQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/gwt/inspections/GwtDeprecatedPropertyKeyJavadocTagInspection$ReplaceTagByAnnotationQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

