/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.run;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.impl.ConfigurationSettingsEditorWrapper;
import com.intellij.execution.ui.CommonJavaParametersPanel;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JrePathEditor;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.run.ChooseGwtModulesDialog;
import com.intellij.gwt.run.GwtCommonParametersPanel;
import com.intellij.gwt.run.GwtDevModeServer;
import com.intellij.gwt.run.GwtDevModeServerProvider;
import com.intellij.gwt.run.GwtRunConfiguration;
import com.intellij.gwt.sdk.GwtVersion;
import com.intellij.gwt.web.GwtWebUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.browsers.BrowserSelector;
import com.intellij.ide.browsers.JavaScriptDebuggerStarter;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.javaee.DeploymentDescriptorsConstants;
import com.intellij.javaee.ui.packaging.ExplodedWarArtifactType;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.impl.run.BuildArtifactsBeforeRunTask;
import com.intellij.packaging.impl.run.BuildArtifactsBeforeRunTaskProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.AnchorableComponent;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtRunConfigurationEditor
extends SettingsEditor<GwtRunConfiguration>
implements PanelWithAnchor {
    private static final Comparator<List<String>> MODULES_LIST_COMPARATOR = (o1, o2) -> {
        if (o1.size() > o2.size()) {
            return -1;
        }
        if (o1.size() < o2.size()) {
            return 1;
        }
        return ContainerUtil.compareLexicographically((List)o1, (List)o2, (Comparator)String.CASE_INSENSITIVE_ORDER);
    };
    private SortedComboBoxModel<List<String>> myGwtModulesModel;
    private DefaultComboBoxModel myPagesModel;
    private CommonJavaParametersPanel myCommonProgramParameters;
    private ModulesComboBox myModulesBox;
    private JPanel myMainPanel;
    private ComboboxWithBrowseButton myHtmlPageBox;
    private JCheckBox myPatchWebXmlCheckBox;
    private TextFieldWithBrowseButton myWebXmlField;
    private ComboboxWithBrowseButton myGwtModuleComboBox;
    private JBLabel myGwtModuleLabel;
    private JBLabel myServerLabel;
    private JComboBox myServerComboBox;
    private JBCheckBox myOpenInBrowserCheckBox;
    private final BrowserSelector myBrowserSelector;
    private JPanel myBrowserSelectorPanel;
    private JCheckBox myUpdateResourcesOnFrameCheckBox;
    private JBCheckBox myUseSuperDevModeCheckBox;
    private JBLabel myStartPageLabel;
    private JCheckBox myStartJavaScriptDebuggerCheckBox;
    private JBLabel myModuleLabel;
    private JrePathEditor myJrePathEditor;
    private final Project myProject;
    private final GwtModulesManager myGwtModulesManager;
    private final Map<String, String> myHtmlPage2GwtModule;
    private List<String> myAllGwtModules;
    private JComponent myAnchor;

    public GwtRunConfigurationEditor(final Project project) {
        this.$$$setupUI$$$();
        this.myHtmlPage2GwtModule = new THashMap();
        this.myAllGwtModules = new ArrayList<String>();
        this.myProject = project;
        this.myGwtModulesManager = GwtModulesManager.getInstance(this.myProject);
        this.myBrowserSelector = new BrowserSelector();
        this.myGwtModuleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DumbService.isDumb((Project)project)) {
                    Messages.showErrorDialog((Component)GwtRunConfigurationEditor.this.myMainPanel, (String)("GWT Module chooser isn't available while " + ApplicationNamesInfo.getInstance().getProductName() + " is updating indices"));
                    return;
                }
                ChooseGwtModulesDialog dialog = new ChooseGwtModulesDialog(GwtRunConfigurationEditor.this.getSelectedModule(), GwtRunConfigurationEditor.this.getSelectedGwtModules());
                if (dialog.showAndGet()) {
                    GwtRunConfigurationEditor.this.setSelectedGwtModules(dialog.getSelectedModules());
                }
            }
        });
        this.myJrePathEditor.setDefaultJreSelector(DefaultJreSelector.fromModuleDependencies((ModulesComboBox)this.myModulesBox, (boolean)false));
        this.myAnchor = UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{this.myCommonProgramParameters, this.myJrePathEditor, GwtRunConfigurationEditor.convert((AnchorableComponent)this.myModuleLabel), GwtRunConfigurationEditor.convert((AnchorableComponent)this.myGwtModuleLabel), GwtRunConfigurationEditor.convert((AnchorableComponent)this.myServerLabel), GwtRunConfigurationEditor.convert((AnchorableComponent)this.myStartPageLabel), GwtRunConfigurationEditor.convert((AnchorableComponent)this.myOpenInBrowserCheckBox)});
    }

    public void resetEditorFrom(@NotNull GwtRunConfiguration configuration) {
        if (configuration == null) {
            GwtRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        this.myCommonProgramParameters.reset((CommonProgramRunConfigurationParameters)configuration);
        GwtRunConfiguration.GwtRunConfigurationState state = configuration.getState();
        this.myCommonProgramParameters.setVMParameters(state.VM_PARAMETERS);
        this.myUpdateResourcesOnFrameCheckBox.setSelected(state.UPDATE_RESOURCES_ON_FRAME_DEACTIVATION);
        this.myUseSuperDevModeCheckBox.setSelected(state.USE_SUPER_DEV_MODE);
        Module module = configuration.getModule();
        this.myModulesBox.setModules(configuration.getValidModules());
        this.myModulesBox.setSelectedModule(module);
        boolean customWebXml = state.CUSTOM_WEB_XML != null;
        this.myPatchWebXmlCheckBox.setSelected(customWebXml);
        this.myWebXmlField.setEnabled(customWebXml);
        if (customWebXml) {
            this.setCustomWebXml(state.CUSTOM_WEB_XML);
        }
        this.updateWebXmlPanel(module);
        this.fillPages(module);
        String pagePath = configuration.getPage();
        if (pagePath == null) {
            pagePath = "";
        }
        this.myHtmlPageBox.getComboBox().getEditor().setItem(pagePath);
        this.updateGwtModulesCombobox(module);
        this.myGwtModuleComboBox.getComboBox().setSelectedItem(null);
        List<String> gwtModules = state.getGwtModules();
        this.setSelectedGwtModules(gwtModules != null ? gwtModules : this.myAllGwtModules);
        for (int i = 0; i < this.myServerComboBox.getItemCount(); ++i) {
            GwtDevModeServer server = (GwtDevModeServer)this.myServerComboBox.getItemAt(i);
            if (!server.getId().equals(state.SERVER_ID)) continue;
            this.myServerComboBox.setSelectedIndex(i);
            break;
        }
        this.myOpenInBrowserCheckBox.setSelected(state.OPEN_IN_BROWSER);
        this.myStartJavaScriptDebuggerCheckBox.setSelected(state.START_JAVASCRIPT_DEBUGGER);
        this.myBrowserSelector.setSelected(WebBrowserManager.getInstance().findBrowserById(state.BROWSER));
        this.updateSuperDevModeCheckbox(module);
        this.updateOpenInBrowserSection();
        this.updateUpdateResourcesCheckbox();
        this.updateServerCombobox();
        this.updateStartPagePanel();
        this.myJrePathEditor.setPathOrName(state.ALTERNATIVE_JRE_PATH, true);
    }

    private void setSelectedGwtModules(@NotNull List<String> gwtModules) {
        if (gwtModules == null) {
            GwtRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        if (this.myGwtModulesModel.indexOf(gwtModules) == -1) {
            for (List list : new ArrayList(this.myGwtModulesModel.getItems())) {
                if (list.size() <= 1 || list.equals(this.myAllGwtModules)) continue;
                this.myGwtModulesModel.remove((Object)list);
            }
            this.myGwtModulesModel.add(gwtModules);
        }
        this.myGwtModuleComboBox.getComboBox().setSelectedItem(gwtModules);
    }

    private void updateStartPagePanel() {
        this.myStartPageLabel.setVisible(true);
        this.myHtmlPageBox.setVisible(true);
        this.myStartJavaScriptDebuggerCheckBox.setVisible(this.myUseSuperDevModeCheckBox.isSelected() && JavaScriptDebuggerStarter.Util.hasStarters());
    }

    private void updateGwtModulesCombobox(@Nullable Module module) {
        this.myAllGwtModules = new ArrayList<String>();
        this.myGwtModulesModel.clear();
        boolean enable = false;
        if (module != null) {
            for (GwtModule gwtModule : this.myGwtModulesManager.getCompilableGwtModules(module, false)) {
                String moduleName = gwtModule.getQualifiedName();
                this.myAllGwtModules.add(moduleName);
                this.myGwtModulesModel.add(Collections.singletonList(moduleName));
            }
            GwtFacet facet = GwtFacet.getInstance(module);
            if (facet != null) {
                enable = facet.getSdkVersion().isModulesToLoadSpecifiedInDevMode();
            }
        }
        Collections.sort(this.myAllGwtModules, String.CASE_INSENSITIVE_ORDER);
        this.setSelectedGwtModules(this.myAllGwtModules);
        this.myGwtModuleComboBox.setEnabled(enable);
        this.myGwtModuleLabel.setEnabled(enable);
    }

    private void setCustomWebXml(String url) {
        this.myWebXmlField.setText(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)url)));
    }

    @Nullable
    private VirtualFile getFileByPagePath(@Nullable Module module, @NotNull String pagePath) {
        int index;
        if (pagePath == null) {
            GwtRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        if ((index = pagePath.indexOf(47)) == -1) {
            return null;
        }
        GlobalSearchScope scope = module != null ? GlobalSearchScope.moduleWithDependenciesScope((Module)module) : GlobalSearchScope.allScope((Project)this.myProject);
        Collection<GwtModule> gwtModules = this.myGwtModulesManager.findGwtModulesByOutputName(pagePath.substring(0, index), scope);
        String name = pagePath.substring(index + 1);
        for (GwtModule gwtModule : gwtModules) {
            Collection<VirtualFile> publicRoots = gwtModule.getPublicRoots();
            for (VirtualFile root : publicRoots) {
                VirtualFile file = root.findFileByRelativePath(name);
                if (file == null) continue;
                return file;
            }
        }
        return null;
    }

    private void fillPages(Module module) {
        this.myPagesModel.removeAllElements();
        this.myHtmlPage2GwtModule.clear();
        if (module == null) {
            return;
        }
        for (GwtModule gwtModule : this.myGwtModulesManager.getCompilableGwtModules(module, false)) {
            Collection<VirtualFile> htmlFiles = this.myGwtModulesManager.getAllHtmlFiles(gwtModule);
            for (VirtualFile htmlFile : htmlFiles) {
                String path = this.myGwtModulesManager.getOutputPath(gwtModule, htmlFile);
                if (path == null) continue;
                this.myHtmlPage2GwtModule.put(path, gwtModule.getQualifiedName());
                this.myPagesModel.addElement(path);
            }
        }
    }

    public void applyEditorTo(@NotNull GwtRunConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            GwtRunConfigurationEditor.$$$reportNull$$$0(3);
        }
        configuration.setModule(this.getSelectedModule());
        String path = (String)this.myHtmlPageBox.getComboBox().getEditor().getItem();
        configuration.setPage(path);
        this.validateDevModeParameters();
        this.myCommonProgramParameters.applyTo((CommonProgramRunConfigurationParameters)configuration);
        GwtRunConfiguration.GwtRunConfigurationState state = configuration.getState();
        state.VM_PARAMETERS = this.myCommonProgramParameters.getVMParameters();
        state.UPDATE_RESOURCES_ON_FRAME_DEACTIVATION = this.myUpdateResourcesOnFrameCheckBox.isSelected();
        state.USE_SUPER_DEV_MODE = this.isUseSuperDevModeSelected();
        state.CUSTOM_WEB_XML = this.myPatchWebXmlCheckBox.isSelected() ? VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)this.myWebXmlField.getText())) : null;
        List<String> selectedGwtModules = this.getSelectedGwtModules();
        state.setGwtModules(selectedGwtModules.equals(this.myAllGwtModules) ? null : selectedGwtModules);
        state.SERVER_ID = ((GwtDevModeServer)this.myServerComboBox.getSelectedItem()).getId();
        state.OPEN_IN_BROWSER = this.myOpenInBrowserCheckBox.isSelected();
        state.START_JAVASCRIPT_DEBUGGER = this.myStartJavaScriptDebuggerCheckBox.isSelected();
        state.BROWSER = this.myBrowserSelector.getSelectedBrowserId();
        state.ALTERNATIVE_JRE_PATH = this.myJrePathEditor.getJrePathOrName();
    }

    private void validateDevModeParameters() throws ConfigurationException {
        int warIndex;
        String devModeParameters = ((RawCommandLineEditor)this.myCommonProgramParameters.getProgramParametersComponent().getComponent()).getText();
        ArrayList devModeParametersList = ContainerUtil.newArrayList((Object[])ParametersList.parse((String)devModeParameters));
        boolean noServer = devModeParametersList.contains("-noserver");
        boolean noStartServer = devModeParametersList.contains("-nostartServer");
        if ((noServer || noStartServer) && ((warIndex = 1 + devModeParametersList.indexOf("-war")) == 0 || warIndex == devModeParametersList.size() || '-' == ((String)devModeParametersList.get(warIndex)).charAt(0))) {
            String message = (noServer ? "-noserver" : "-nostartServer") + " parameter used without corresponding -war";
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)this.myMainPanel);
            ConfigurationSettingsEditorWrapper editorWrapper = (ConfigurationSettingsEditorWrapper)ConfigurationSettingsEditorWrapper.CONFIGURATION_EDITOR_KEY.getData(dataContext);
            if (editorWrapper != null) {
                SmartList artifacts = new SmartList();
                for (BeforeRunTask beforeRunTask : editorWrapper.getStepsBeforeLaunch()) {
                    if (beforeRunTask.getProviderId() != BuildArtifactsBeforeRunTaskProvider.ID) continue;
                    BuildArtifactsBeforeRunTask task = (BuildArtifactsBeforeRunTask)beforeRunTask;
                    for (ArtifactPointer pointer : task.getArtifactPointers()) {
                        Artifact artifact = pointer.getArtifact();
                        if (artifact == null || !(artifact.getArtifactType() instanceof ExplodedWarArtifactType)) continue;
                        artifacts.add(artifact);
                    }
                }
                if (artifacts.size() == 1) {
                    Artifact artifact = (Artifact)artifacts.get(0);
                    throw new RuntimeConfigurationWarning(message, () -> {
                        if (warIndex == 0) {
                            devModeParametersList.add("-war");
                            devModeParametersList.add(artifact.getOutputPath());
                        } else {
                            devModeParametersList.add(warIndex, artifact.getOutputPath());
                        }
                        ((RawCommandLineEditor)this.myCommonProgramParameters.getProgramParametersComponent().getComponent()).setText(ParametersList.join((List)devModeParametersList));
                    });
                }
            }
            throw new RuntimeConfigurationWarning(message);
        }
    }

    @NotNull
    private List<String> getSelectedGwtModules() {
        List list = (List)ObjectUtils.notNull((Object)this.myGwtModulesModel.getSelectedItem(), this.myAllGwtModules);
        if (list == null) {
            GwtRunConfigurationEditor.$$$reportNull$$$0(4);
        }
        return list;
    }

    private Module getSelectedModule() {
        return this.myModulesBox.getSelectedModule();
    }

    @NotNull
    public JComponent createEditor() {
        this.myPagesModel = new DefaultComboBoxModel();
        JComboBox comboBox = this.myHtmlPageBox.getComboBox();
        comboBox.setEditable(true);
        comboBox.setModel(this.myPagesModel);
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String page = (String)e.getItem();
                    String gwtModule = (String)GwtRunConfigurationEditor.this.myHtmlPage2GwtModule.get(page);
                    if (gwtModule != null) {
                        GwtRunConfigurationEditor.this.ensureGwtModuleIsSelected(gwtModule);
                    }
                }
            }
        });
        this.myServerComboBox.setRenderer(new ListCellRendererWrapper<GwtDevModeServer>(){

            public void customize(JList list, GwtDevModeServer value, int index, boolean selected, boolean hasFocus) {
                this.setText(value.getName());
                this.setIcon(value.getIcon());
            }
        });
        for (GwtDevModeServerProvider serverProvider : (GwtDevModeServerProvider[])GwtDevModeServerProvider.EP_NAME.getExtensions()) {
            for (GwtDevModeServer gwtDevModeServer : serverProvider.getServers()) {
                this.myServerComboBox.addItem(gwtDevModeServer);
            }
        }
        this.myPatchWebXmlCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GwtRunConfigurationEditor.this.myWebXmlField.setEnabled(GwtRunConfigurationEditor.this.myPatchWebXmlCheckBox.isSelected());
            }
        });
        this.myWebXmlField.addBrowseFolderListener(null, null, this.myProject, this.createWebXmlChooserDescriptor());
        this.myModulesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Module module = GwtRunConfigurationEditor.this.myModulesBox.getSelectedModule();
                GwtRunConfigurationEditor.this.updateSuperDevModeCheckbox(module);
                GwtRunConfigurationEditor.this.fillPages(module);
                GwtRunConfigurationEditor.this.updateWebXmlPanel(module);
                GwtRunConfigurationEditor.this.updateGwtModulesCombobox(module);
                GwtRunConfigurationEditor.this.updateOpenInBrowserSection();
                GwtRunConfigurationEditor.this.updateUpdateResourcesCheckbox();
            }
        });
        this.myUseSuperDevModeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GwtRunConfigurationEditor.this.updateSuperDevModeCheckbox(GwtRunConfigurationEditor.this.getSelectedModule());
                GwtRunConfigurationEditor.this.updateServerCombobox();
                GwtRunConfigurationEditor.this.updateWebXmlPanel(GwtRunConfigurationEditor.this.getSelectedModule());
                GwtRunConfigurationEditor.this.updateUpdateResourcesCheckbox();
                GwtRunConfigurationEditor.this.updateStartPagePanel();
            }
        });
        this.myBrowserSelectorPanel.add("Center", this.myBrowserSelector.getMainComponent());
        this.myOpenInBrowserCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GwtRunConfigurationEditor.this.updateOpenInBrowserSection();
            }
        });
        this.myHtmlPageBox.addActionListener((ActionListener)((Object)new HtmlPageActionListener()));
        this.myGwtModuleComboBox.getComboBox().setRenderer(new ListCellRendererWrapper<List<String>>(){

            public void customize(JList list, List<String> value, int index, boolean selected, boolean hasFocus) {
                String text = GwtRunConfigurationEditor.this.myAllGwtModules.equals(value) ? GwtBundle.message("text.gwt.modules.to.load.all", new Object[0]) : (value.size() > 1 ? value.get(0) + " and " + (value.size() == 2 ? "one more module" : value.size() - 1 + " more modules") : (value.size() == 1 ? value.get(0) : GwtBundle.message("text.gwt.modules.to.load.none", new Object[0])));
                this.setText(text);
            }
        });
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            GwtRunConfigurationEditor.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    private void ensureGwtModuleIsSelected(@NotNull String gwtModule) {
        List<String> modules;
        if (gwtModule == null) {
            GwtRunConfigurationEditor.$$$reportNull$$$0(6);
        }
        if (!(modules = this.getSelectedGwtModules()).contains(gwtModule)) {
            this.myGwtModuleComboBox.getComboBox().setSelectedItem(Collections.singletonList(gwtModule));
        }
    }

    private void updateServerCombobox() {
        boolean visible = this.myServerComboBox.getItemCount() >= 2;
        this.myServerComboBox.setVisible(visible);
        this.myServerLabel.setVisible(visible);
    }

    private boolean isUseSuperDevModeSelected() {
        return this.myUseSuperDevModeCheckBox.isVisible() && this.myUseSuperDevModeCheckBox.isSelected();
    }

    private void updateSuperDevModeCheckbox(@Nullable Module module) {
        GwtVersion version = GwtFacet.getGwtVersion(module);
        this.myUseSuperDevModeCheckBox.setVisible(version.isSuperDevModeSupported());
    }

    private void updateUpdateResourcesCheckbox() {
        this.myUpdateResourcesOnFrameCheckBox.setVisible(GwtFacet.getGwtVersion(this.getSelectedModule()).isOutOfProcessHostedModeSupported());
    }

    private void updateOpenInBrowserSection() {
        boolean visible = GwtFacet.getGwtVersion(this.getSelectedModule()).isOutOfProcessHostedModeSupported();
        this.myOpenInBrowserCheckBox.setVisible(visible);
        this.myBrowserSelector.getMainComponent().setVisible(visible);
        boolean enable = this.myOpenInBrowserCheckBox.isSelected();
        this.myBrowserSelector.getMainComponent().setEnabled(enable);
        this.myStartJavaScriptDebuggerCheckBox.setEnabled(enable);
    }

    private FileChooserDescriptor createWebXmlChooserDescriptor() {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return super.isFileVisible(file, showHiddenFiles) && (file.isDirectory() || file.getName().equals(DeploymentDescriptorsConstants.WEB_XML_META_DATA.getFileName()));
            }
        };
        this.setContentRoots(descriptor);
        return descriptor;
    }

    private void updateWebXmlPanel(@Nullable Module module) {
        boolean visible = this.updateWebXmlField(module);
        this.myWebXmlField.setVisible(visible);
        this.myPatchWebXmlCheckBox.setVisible(visible);
    }

    private boolean updateWebXmlField(@Nullable Module module) {
        if (module == null) {
            return false;
        }
        Collection webFacets = WebFacet.getInstances((Module)module);
        GwtFacet facet = GwtFacet.getInstance(module);
        if (webFacets.isEmpty() || facet == null || facet.getSdkVersion().isHostedModeRequiresWebXml()) {
            return false;
        }
        if (this.myWebXmlField.getText().trim().length() == 0) {
            ConfigFile descriptor;
            WebFacet webFacet = facet.getWebFacet();
            if (webFacet == null) {
                webFacet = (WebFacet)webFacets.iterator().next();
            }
            if ((descriptor = webFacet.getWebXmlDescriptor()) != null) {
                this.setCustomWebXml(descriptor.getUrl());
            }
        }
        return true;
    }

    private FileChooserDescriptor createHtmlFileChooserDescriptor() {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return super.isFileVisible(file, showHiddenFiles) && (file.isDirectory() || file.getFileType() == StdFileTypes.HTML);
            }
        };
        this.setContentRoots(descriptor);
        return descriptor;
    }

    private void setContentRoots(FileChooserDescriptor descriptor) {
        ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)this.myProject);
        descriptor.setRoots(rootManager.getContentRoots());
    }

    private void createUIComponents() {
        this.myCommonProgramParameters = new GwtCommonParametersPanel();
        this.myGwtModulesModel = new SortedComboBoxModel(MODULES_LIST_COMPARATOR);
        this.myGwtModuleComboBox = new ComboboxWithBrowseButton((JComboBox)new ComboBox(this.myGwtModulesModel));
    }

    public void setAnchor(JComponent anchor) {
        this.myAnchor = anchor;
        this.myCommonProgramParameters.setAnchor(anchor);
        this.myJrePathEditor.setAnchor(anchor);
        this.myModuleLabel.setAnchor(anchor);
        this.myGwtModuleLabel.setAnchor(anchor);
        this.myServerLabel.setAnchor(anchor);
        this.myStartPageLabel.setAnchor(anchor);
        this.myOpenInBrowserCheckBox.setAnchor(anchor);
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    private static PanelWithAnchor convert(final AnchorableComponent component) {
        return new PanelWithAnchor(){

            public JComponent getAnchor() {
                JComponent anchor = component.getAnchor();
                return anchor == null ? (JComponent)component : anchor;
            }

            public void setAnchor(@Nullable JComponent anchor) {
                component.setAnchor(anchor);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gwtModules";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pagePath";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/run/GwtRunConfigurationEditor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gwtModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/run/GwtRunConfigurationEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedGwtModules";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedGwtModules";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFileByPagePath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "ensureGwtModuleIsSelected";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JrePathEditor jrePathEditor;
        ComboboxWithBrowseButton comboboxWithBrowseButton;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JComboBox jComboBox;
        JCheckBox jCheckBox;
        JBCheckBox jBCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        JBCheckBox jBCheckBox2;
        JBLabel jBLabel3;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JCheckBox jCheckBox3;
        ModulesComboBox modulesComboBox;
        JBLabel jBLabel4;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(13, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myModuleLabel = jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, ResourceBundle.getBundle("com/intellij/gwt/GwtBundle").getString("label.choose.module.text"));
        jPanel2.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(12, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myModulesBox = modulesComboBox = new ModulesComboBox();
        jPanel2.add((Component)modulesComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 7, 0, null, null, null));
        this.myPatchWebXmlCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("com/intellij/gwt/GwtBundle").getString("checkbox.text.use.custom.web.xml"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(10, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myWebXmlField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(11, 0, 1, 2, 0, 1, 3, 0, null, null, null, 2));
        this.myGwtModuleLabel = jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, ResourceBundle.getBundle("com/intellij/gwt/GwtBundle").getString("label.text.gwt.module.to.load"));
        jPanel2.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton2 = this.myGwtModuleComboBox;
        jPanel2.add((Component)comboboxWithBrowseButton2, new GridConstraints(2, 1, 1, 1, 8, 1, 7, 0, null, null, null));
        this.myOpenInBrowserCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Open in browser:");
        jBCheckBox2.setMnemonic('B');
        jBCheckBox2.setDisplayedMnemonicIndex(8);
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(7, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBrowserSelectorPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(7, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        this.myUpdateResourcesOnFrameCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Update resources on frame deactivation");
        jCheckBox2.setMnemonic('U');
        jCheckBox2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jCheckBox2, new GridConstraints(9, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myUseSuperDevModeCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Use Super Dev Mode");
        jPanel2.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myStartJavaScriptDebuggerCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("with JavaScript debugger");
        jPanel2.add((Component)jCheckBox, new GridConstraints(8, 0, 1, 2, 8, 0, 3, 0, null, null, null, 1));
        CommonJavaParametersPanel commonJavaParametersPanel = this.myCommonProgramParameters;
        jPanel2.add((Component)commonJavaParametersPanel, new GridConstraints(3, 0, 1, 2, 0, 1, 2, 0, null, null, null));
        this.myServerComboBox = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(4, 1, 1, 1, 8, 1, 7, 0, null, null, null));
        this.myServerLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Server:");
        jBLabel2.setDisplayedMnemonic('R');
        jBLabel2.setDisplayedMnemonicIndex(2);
        jPanel2.add((Component)jBLabel2, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myStartPageLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("com/intellij/gwt/GwtBundle").getString("label.html.to.open.text"));
        jPanel2.add((Component)jBLabel, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHtmlPageBox = comboboxWithBrowseButton = new ComboboxWithBrowseButton();
        jPanel2.add((Component)comboboxWithBrowseButton, new GridConstraints(5, 1, 1, 1, 0, 1, 7, 3, null, null, null));
        this.myJrePathEditor = jrePathEditor = new JrePathEditor();
        jPanel2.add((Component)jrePathEditor, new GridConstraints(6, 0, 1, 2, 0, 1, 2, 0, null, null, null));
        jBLabel4.setLabelFor((Component)modulesComboBox);
        jBLabel3.setLabelFor((Component)comboboxWithBrowseButton2);
        jBLabel2.setLabelFor(jComboBox);
        jBLabel.setLabelFor((Component)comboboxWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class HtmlPageActionListener
    extends ComponentWithBrowseButton.BrowseFolderActionListener<JComboBox> {
        public HtmlPageActionListener() {
            super(null, null, (ComponentWithBrowseButton)GwtRunConfigurationEditor.this.myHtmlPageBox, GwtRunConfigurationEditor.this.myProject, GwtRunConfigurationEditor.this.createHtmlFileChooserDescriptor(), (TextComponentAccessor)new RunPageComponentAccessor());
        }

        protected void onFileChosen(@NotNull VirtualFile chosenFile) {
            if (chosenFile == null) {
                HtmlPageActionListener.$$$reportNull$$$0(0);
            }
            List<Pair<GwtModule, String>> pairs = GwtRunConfigurationEditor.this.myGwtModulesManager.findGwtModulesByPublicFile(chosenFile);
            Pair<GwtModule, String> pair = null;
            if (pairs.size() == 1) {
                pair = pairs.get(0);
            } else if (!pairs.isEmpty()) {
                String[] gwtModules = new String[pairs.size()];
                for (int i = 0; i < pairs.size(); ++i) {
                    gwtModules[i] = ((GwtModule)pairs.get(i).getFirst()).getQualifiedName();
                }
                int answer = Messages.showChooseDialog((Component)GwtRunConfigurationEditor.this.myMainPanel, (String)GwtBundle.message("choose.text.select.gwt.module", new Object[0]), (String)GwtBundle.message("dialog.title.choose.gwt.module", new Object[0]), (String[])gwtModules, (String)gwtModules[0], null);
                if (answer >= 0) {
                    pair = pairs.get(answer);
                }
            }
            if (pair != null) {
                GwtRunConfigurationEditor.this.myHtmlPageBox.getComboBox().getEditor().setItem(GwtWebUtil.getOutputPath((GwtModule)pair.getFirst(), (String)pair.getSecond()));
                GwtRunConfigurationEditor.this.ensureGwtModuleIsSelected(((GwtModule)pair.getFirst()).getQualifiedName());
            } else {
                String path = GwtWebUtil.getRelativeToWebRootPath(chosenFile, GwtRunConfigurationEditor.this.myProject);
                if (path != null) {
                    GwtRunConfigurationEditor.this.myHtmlPageBox.getComboBox().getEditor().setItem(path);
                } else {
                    Messages.showErrorDialog((Component)GwtRunConfigurationEditor.this.myMainPanel, (String)GwtBundle.message("error.message.0.is.not.under.public.roots.of.gwt.modules.nor.under.web.roots", chosenFile.getName()));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/intellij/gwt/run/GwtRunConfigurationEditor$HtmlPageActionListener", "onFileChosen"));
        }
    }

    private class RunPageComponentAccessor
    implements TextComponentAccessor<JComboBox> {
        private RunPageComponentAccessor() {
        }

        public String getText(JComboBox component) {
            String pagePath = component.getEditor().getItem().toString();
            VirtualFile file = GwtRunConfigurationEditor.this.getFileByPagePath(GwtRunConfigurationEditor.this.getSelectedModule(), pagePath);
            return file != null ? file.getPath() : "";
        }

        public void setText(JComboBox component, @NotNull String text) {
            if (text == null) {
                RunPageComponentAccessor.$$$reportNull$$$0(0);
            }
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/gwt/run/GwtRunConfigurationEditor$RunPageComponentAccessor", "setText"));
        }
    }
}

