/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.web;

import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.javaee.DeploymentDescriptorsConstants;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.descriptors.ConfigFileFactory;
import com.intellij.util.descriptors.ConfigFileMetaData;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtWebUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.web.GwtWebUtil");

    private GwtWebUtil() {
    }

    public static WebFacet createWebFacet(@NotNull GwtFacet facet, @NotNull VirtualFile root) {
        if (facet == null) {
            GwtWebUtil.$$$reportNull$$$0(0);
        }
        if (root == null) {
            GwtWebUtil.$$$reportNull$$$0(1);
        }
        Project project = facet.getModule().getProject();
        ConfigFileMetaData webXml = DeploymentDescriptorsConstants.WEB_XML_META_DATA;
        String webRootUrl = root.getUrl() + "/war";
        String webXmlUrl = webRootUrl + "/" + webXml.getDirectoryPath() + "/" + webXml.getFileName();
        FacetType webFacetType = FacetTypeRegistry.getInstance().findFacetType(WebFacet.ID);
        WebFacet webFacet = (WebFacet)FacetManager.getInstance((Module)facet.getModule()).addFacet(webFacetType, webFacetType.getDefaultFacetName(), null);
        webFacet.addWebRoot(webRootUrl, "/");
        ConfigFileFactory.getInstance().createFile(project, webXmlUrl, webXml.getDefaultVersion(), false);
        webFacet.getDescriptorsContainer().getConfiguration().replaceConfigFile(webXml, webXmlUrl);
        ((GwtFacetConfiguration)facet.getConfiguration()).setWebFacetName(webFacet.getName());
        return webFacet;
    }

    @NotNull
    public static String getOutputPath(@NotNull GwtModule gwtModule, @NotNull String relativePath) {
        if (gwtModule == null) {
            GwtWebUtil.$$$reportNull$$$0(2);
        }
        if (relativePath == null) {
            GwtWebUtil.$$$reportNull$$$0(3);
        }
        String string = gwtModule.getOutputName() + "/" + relativePath;
        if (string == null) {
            GwtWebUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public static String getRelativeToWebRootPath(@NotNull VirtualFile htmlFile, @NotNull Project project) {
        VirtualFile rootFile;
        WebRoot webRoot;
        WebFacet webFacet;
        if (htmlFile == null) {
            GwtWebUtil.$$$reportNull$$$0(5);
        }
        if (project == null) {
            GwtWebUtil.$$$reportNull$$$0(6);
        }
        if ((webFacet = WebUtil.findFacetByFileUnderWebRoot((VirtualFile)htmlFile, (Project)project)) != null && (webRoot = WebUtil.findParentWebRoot((VirtualFile)htmlFile, (List)webFacet.getWebRoots())) != null && (rootFile = webRoot.getFile()) != null) {
            return VfsUtilCore.getRelativePath((VirtualFile)htmlFile, (VirtualFile)rootFile, (char)'/');
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gwtModule";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/web/GwtWebUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/web/GwtWebUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createWebFacet";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOutputPath";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeToWebRootPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

