/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.ruleset;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.actions.ruleset.StyleCreatorWithFileChooser;
import com.intellij.psi.css.index.CssSupportedFileTypesProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExistingFileStyleCreatorWithChooser
extends StyleCreatorWithFileChooser {
    public ExistingFileStyleCreatorWithChooser(@NotNull PsiFile contextFile) {
        if (contextFile == null) {
            ExistingFileStyleCreatorWithChooser.$$$reportNull$$$0(0);
        }
        super(CssBundle.message((String)"css.inspections.create.style.existing.file", (Object[])new Object[0]), contextFile);
    }

    @Override
    @Nullable
    protected StylesheetFile chooseFile() {
        FileChooserDescriptor descriptor = this.createCssFileChooserDescriptor();
        Project project = this.myContextFile.getProject();
        Ref result = new Ref();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            FileChooserDialog chooser = FileChooserFactory.getInstance().createFileChooser(descriptor, project, null);
            VirtualFile[] cssFiles = chooser.choose(project, new VirtualFile[0]);
            if (cssFiles.length > 0) {
                VirtualFile cssFile = cssFiles[0];
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(cssFile);
                if (psiFile instanceof StylesheetFile) {
                    result.set((Object)((StylesheetFile)psiFile));
                }
            }
        });
        return (StylesheetFile)result.get();
    }

    @NotNull
    private FileChooserDescriptor createCssFileChooserDescriptor() {
        CssFileChooserDescriptor descriptor = new CssFileChooserDescriptor();
        Project project = this.myContextFile.getProject();
        descriptor.setRoots(ProjectRootManager.getInstance((Project)project).getContentRoots());
        descriptor.withTreeRootVisible(true);
        CssFileChooserDescriptor cssFileChooserDescriptor = descriptor;
        if (cssFileChooserDescriptor == null) {
            ExistingFileStyleCreatorWithChooser.$$$reportNull$$$0(1);
        }
        return cssFileChooserDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/actions/ruleset/ExistingFileStyleCreatorWithChooser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/actions/ruleset/ExistingFileStyleCreatorWithChooser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCssFileChooserDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CssFileChooserDescriptor
    extends FileChooserDescriptor {
        public CssFileChooserDescriptor() {
            super(true, false, false, false, false, false);
        }

        public boolean isFileVisible(@NotNull VirtualFile file, boolean showHiddenFiles) {
            if (file == null) {
                CssFileChooserDescriptor.$$$reportNull$$$0(0);
            }
            return super.isFileVisible(file, showHiddenFiles) || CssSupportedFileTypesProvider.isSupportedFileType(file.getFileType());
        }

        public boolean isFileSelectable(@NotNull VirtualFile file) {
            if (file == null) {
                CssFileChooserDescriptor.$$$reportNull$$$0(1);
            }
            return super.isFileSelectable(file) && CssSupportedFileTypesProvider.isSupportedFileType(file.getFileType());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "file";
            objectArray2[1] = "com/intellij/psi/css/actions/ruleset/ExistingFileStyleCreatorWithChooser$CssFileChooserDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isFileVisible";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isFileSelectable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

