/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.editor;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssMediaExpression;
import com.intellij.psi.css.CssMediaFeature;
import com.intellij.psi.css.CssMediumList;
import com.intellij.psi.css.CssOneLineStatement;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssMediaQueryImpl;
import com.intellij.psi.css.impl.CssTokenImpl;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssSelectioner
extends ExtendWordSelectionHandlerBase {
    public boolean canSelect(PsiElement e) {
        return e.getLanguage().isKindOf((Language)CSSLanguage.INSTANCE);
    }

    @Nullable
    public static TextRange getStatementWithSemicolonRange(PsiElement declaration) {
        PsiElement semicolon;
        for (semicolon = declaration; !(semicolon == null || semicolon instanceof LeafElement && ((LeafElement)semicolon).getElementType() == CssElementTypes.CSS_SEMICOLON); semicolon = semicolon.getNextSibling()) {
        }
        if (semicolon != null) {
            TextRange range = declaration.getTextRange();
            range = range.union(semicolon.getTextRange());
            return range;
        }
        return null;
    }

    private static TextRange getLineRange(CharSequence editorText, int cursorOffset) {
        int end;
        int start;
        for (start = cursorOffset; start > 0 && editorText.charAt(start - 1) != '\n' && editorText.charAt(start - 1) != '\r'; --start) {
        }
        for (end = cursorOffset; end < editorText.length() && editorText.charAt(end) != '\n' && editorText.charAt(end) != '\r'; ++end) {
        }
        return new TextRange(start, end);
    }

    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        CssRuleset ruleset;
        CssOneLineStatement statement;
        CssBlock block;
        if (!(e instanceof CssTokenImpl)) {
            return Collections.emptyList();
        }
        ArrayList<TextRange> l = new ArrayList<TextRange>();
        TextRange originalTextRange = e.getTextRange();
        l.add(originalTextRange);
        if (e.getNode().getElementType() == CssElementTypes.CSS_HASH && originalTextRange.getLength() > 1) {
            l.add(TextRange.create((int)(originalTextRange.getStartOffset() + 1), (int)originalTextRange.getEndOffset()));
        }
        if ((block = (CssBlock)PsiTreeUtil.getParentOfType((PsiElement)e, CssBlock.class)) != null) {
            l.add(block.getTextRange());
            ASTNode lbrace = block.getNode().findChildByType(CssElementTypes.CSS_LBRACE);
            ASTNode rbrace = block.getNode().findChildByType(CssElementTypes.CSS_RBRACE);
            if (lbrace != null && rbrace != null) {
                int start = CharArrayUtil.shiftForward((CharSequence)editorText, (int)lbrace.getTextRange().getEndOffset(), (String)" \n");
                int end = CharArrayUtil.shiftBackward((CharSequence)editorText, (int)start, (int)(rbrace.getTextRange().getStartOffset() - 1), (String)" \n");
                l.add(TextRange.create((int)start, (int)(end + 1)));
            }
        }
        if ((statement = (CssOneLineStatement)PsiTreeUtil.getParentOfType((PsiElement)e, CssOneLineStatement.class)) != null) {
            l.add(statement.getTextRange());
            TextRange declarationWithSemicolon = CssSelectioner.getStatementWithSemicolonRange((PsiElement)statement);
            if (declarationWithSemicolon != null) {
                l.add(declarationWithSemicolon);
            }
        }
        CssSelectioner.addParentRange(e, l, CssSelectorSuffix.class);
        CssSelectioner.addParentRange(e, l, CssSimpleSelector.class);
        CssSelectioner.addParentRange(e, l, CssSelector.class);
        CssSelectioner.addParentRange(e, l, CssSelectorList.class);
        CssSelectioner.addParentRange(e, l, CssMediaFeature.class);
        CssSelectioner.addParentRange(e, l, CssMediaExpression.class);
        CssSelectioner.addParentRange(e, l, CssMediumList.class);
        CssSelectioner.addParentRange(e, l, CssMediaQueryImpl.class);
        CssTermList termList = (CssTermList)PsiTreeUtil.getParentOfType((PsiElement)e, CssTermList.class);
        if (termList != null) {
            l.add(termList.getTextRange());
            termList = (CssTermList)PsiTreeUtil.getParentOfType((PsiElement)termList, CssTermList.class);
            if (termList != null) {
                l.add(termList.getTextRange());
            }
        }
        CssTerm term = (CssTerm)PsiTreeUtil.getParentOfType((PsiElement)e, CssTerm.class);
        LinkedList termRanges = ContainerUtil.newLinkedList();
        while (term != null) {
            ASTNode lastLeaf;
            PsiElement firstChild = term.getFirstChild();
            if (firstChild != null && firstChild.getNode().getElementType() == CssElementTypes.CSS_MINUS && (lastLeaf = TreeUtil.findLastLeaf((ASTNode)term.getNode())) != null && lastLeaf.getElementType() == CssElementTypes.CSS_IDENT) {
                l.add(TextRange.create((int)firstChild.getTextRange().getStartOffset(), (int)lastLeaf.getStartOffset()));
            }
            termRanges.add(term.getTextRange());
            term = (CssTerm)PsiTreeUtil.getParentOfType((PsiElement)term, CssTerm.class);
        }
        l.addAll(termRanges);
        CssString string = (CssString)PsiTreeUtil.getParentOfType((PsiElement)e, CssString.class);
        if (string != null) {
            TextRange range = string.getTextRange();
            if (range.getLength() > 2 && StringUtil.isQuotedString((String)string.getText())) {
                l.add(TextRange.create((int)(range.getStartOffset() + 1), (int)(range.getEndOffset() - 1)));
            }
            l.add(range);
        }
        if ((ruleset = (CssRuleset)PsiTreeUtil.getParentOfType((PsiElement)e, CssRuleset.class)) != null) {
            l.add(ruleset.getTextRange());
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)e, XmlAttributeValue.class) == null) {
            l.add(CssSelectioner.getLineRange(editorText, cursorOffset));
        }
        return l;
    }

    private static void addParentRange(@NotNull PsiElement currentElement, @NotNull List<TextRange> l, @NotNull Class<? extends PsiElement> parentClass) {
        PsiElement psiElement;
        if (currentElement == null) {
            CssSelectioner.$$$reportNull$$$0(0);
        }
        if (l == null) {
            CssSelectioner.$$$reportNull$$$0(1);
        }
        if (parentClass == null) {
            CssSelectioner.$$$reportNull$$$0(2);
        }
        if ((psiElement = PsiTreeUtil.getParentOfType((PsiElement)currentElement, parentClass)) != null) {
            l.add(psiElement.getTextRange());
        }
    }

    public int getMinimalTextRangeLength(@NotNull PsiElement element, @NotNull CharSequence text, int cursorOffset) {
        if (element == null) {
            CssSelectioner.$$$reportNull$$$0(3);
        }
        if (text == null) {
            CssSelectioner.$$$reportNull$$$0(4);
        }
        IElementType type = element.getNode().getElementType();
        PsiElement parent = element.getParent();
        if (WebEditorOptions.getInstance().isSelectWholeCssIdentifierOnDoubleClick()) {
            if (CssSelectioner.isId(type, parent)) {
                return element.getTextLength() - 1;
            }
            if (type == CssElementTypes.CSS_IDENT || type == CssElementTypes.CSS_FUNCTION_TOKEN) {
                return element.getTextLength();
            }
        }
        if (CssSelectioner.isColor(type, parent)) {
            return element.getTextLength() - 1;
        }
        if (CssSelectioner.isPropertyName(type, parent)) {
            return element.getTextLength();
        }
        return super.getMinimalTextRangeLength(element, text, cursorOffset);
    }

    private static boolean isColor(@Nullable IElementType type, @Nullable PsiElement parent) {
        return type == CssElementTypes.CSS_HASH && parent instanceof CssTerm;
    }

    private static boolean isPropertyName(@Nullable IElementType type, @Nullable PsiElement parent) {
        return type == CssElementTypes.CSS_IDENT && (parent instanceof CssDeclaration || parent instanceof CssMediaFeature);
    }

    private static boolean isId(@Nullable IElementType type, @Nullable PsiElement parent) {
        return type == CssElementTypes.CSS_HASH && parent instanceof CssSelectorSuffix;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/impl/util/editor/CssSelectioner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addParentRange";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getMinimalTextRangeLength";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

