/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.scheme;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssTermType;
import com.intellij.psi.css.descriptor.BrowserVersion;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import com.intellij.psi.css.descriptor.CssFunctionDescriptor;
import com.intellij.psi.css.descriptor.CssMediaGroup;
import com.intellij.psi.css.descriptor.CssMediaType;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueType;
import com.intellij.psi.css.impl.CssTermTypeImpl;
import com.intellij.psi.css.impl.descriptor.CssCommonDescriptorData;
import com.intellij.psi.css.impl.descriptor.CssFunctionDescriptorImpl;
import com.intellij.psi.css.impl.descriptor.CssMediaFeatureDescriptorImpl;
import com.intellij.psi.css.impl.descriptor.CssPropertyDescriptorImplEx;
import com.intellij.psi.css.impl.descriptor.CssPseudoClassDescriptorImpl;
import com.intellij.psi.css.impl.descriptor.CssPseudoElementDescriptorImpl;
import com.intellij.psi.css.impl.descriptor.value.CssAngleValue;
import com.intellij.psi.css.impl.descriptor.value.CssAnyValueImpl;
import com.intellij.psi.css.impl.descriptor.value.CssColorValue;
import com.intellij.psi.css.impl.descriptor.value.CssDecibelValue;
import com.intellij.psi.css.impl.descriptor.value.CssExpressionValue;
import com.intellij.psi.css.impl.descriptor.value.CssFlexValue;
import com.intellij.psi.css.impl.descriptor.value.CssFrequencyValue;
import com.intellij.psi.css.impl.descriptor.value.CssFunctionInvocationValue;
import com.intellij.psi.css.impl.descriptor.value.CssGroupValue;
import com.intellij.psi.css.impl.descriptor.value.CssIdValue;
import com.intellij.psi.css.impl.descriptor.value.CssInlineValue;
import com.intellij.psi.css.impl.descriptor.value.CssIntegerValue;
import com.intellij.psi.css.impl.descriptor.value.CssJavaScriptValue;
import com.intellij.psi.css.impl.descriptor.value.CssLengthValue;
import com.intellij.psi.css.impl.descriptor.value.CssNameValue;
import com.intellij.psi.css.impl.descriptor.value.CssNumberValue;
import com.intellij.psi.css.impl.descriptor.value.CssPercentageValue;
import com.intellij.psi.css.impl.descriptor.value.CssPositionValue;
import com.intellij.psi.css.impl.descriptor.value.CssPropertyReferenceValue;
import com.intellij.psi.css.impl.descriptor.value.CssResolutionValue;
import com.intellij.psi.css.impl.descriptor.value.CssSelectorValue;
import com.intellij.psi.css.impl.descriptor.value.CssSemitonesValue;
import com.intellij.psi.css.impl.descriptor.value.CssStringValue;
import com.intellij.psi.css.impl.descriptor.value.CssTextValue;
import com.intellij.psi.css.impl.descriptor.value.CssTimeValue;
import com.intellij.psi.css.impl.descriptor.value.CssUrangeValue;
import com.intellij.psi.css.impl.descriptor.value.CssUrlValue;
import com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorData;
import com.intellij.psi.css.impl.util.scheme.CssDescriptorsHolder;
import com.intellij.psi.css.impl.util.scheme.CssSchemeConstants;
import com.intellij.psi.css.impl.util.scheme.CssValueDescriptorModificator;
import com.intellij.psi.css.impl.util.table.CssElementDescriptorConstants;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssDescriptorsLoader {
    private final CssDescriptorsHolder myDescriptors = new CssDescriptorsHolder();
    private static final Logger LOG = Logger.getInstance(CssDescriptorsLoader.class);
    private static final Function<String, String> PROCESS_VALUE_PRESENTABLE_NAME = presentableName -> !Strings.isNullOrEmpty((String)presentableName) && !StringUtil.startsWithChar((CharSequence)presentableName, (char)'<') && presentableName.length() > 1 ? "<" + presentableName + ">" : presentableName;
    private static final Function<String, String> PROCESS_FUNCTION_PRESENTABLE_NAME = presentableName -> presentableName + "()";
    private static final CssContextType[] ANY_AT_RULE_TYPES = new CssContextType[]{CssContextType.ANY};
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',').omitEmptyStrings();
    private static final Pattern DOCUMENTATION_LINK_PATTERN = Pattern.compile("<see[\n\r ]+cref=\"([^:]*:([^\"]+))\"\\s*/>");
    @Nullable
    private final ProgressIndicator myProgressIndicator;

    public CssDescriptorsLoader(@Nullable ProgressIndicator progressIndicator) {
        this.myProgressIndicator = progressIndicator;
    }

    public void loadDescriptors(@NotNull URL resource) {
        if (resource == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(0);
        }
        try {
            Document document = JDOMUtil.loadDocument((URL)resource);
            for (Object child : document.getRootElement().getChildren()) {
                this.checkCancelled();
                if (!(child instanceof Element)) continue;
                Element element = (Element)child;
                String tagName = element.getName();
                if ("property".equals(tagName)) {
                    this.loadPropertyDescriptor(element);
                    continue;
                }
                if ("prefixed-property".equals(tagName)) {
                    this.loadPrefixedPropertyDescriptor(element);
                    continue;
                }
                if ("pseudo-element".equals(tagName)) {
                    this.loadPseudoElementDescriptor(element);
                    continue;
                }
                if ("pseudo-class".equals(tagName)) {
                    this.loadPseudoClassDescriptor(element);
                    continue;
                }
                if ("function".equals(tagName)) {
                    this.loadFunctionDescriptor(element);
                    continue;
                }
                if ("prefixed-function".equals(tagName)) {
                    this.loadPrefixedFunctionDescriptor(element);
                    continue;
                }
                if ("named-value".equals(tagName)) {
                    this.loadNamedValueDescriptor(element);
                    continue;
                }
                if (!"media-feature".equals(tagName)) continue;
                this.loadMediaFeatureDescriptor(element);
            }
        }
        catch (JDOMException e) {
            LOG.error("Error loading " + resource.getPath(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Error loading " + resource.getPath(), (Throwable)e);
        }
    }

    @NotNull
    public CssDescriptorsHolder getDescriptors() {
        CssDescriptorsHolder cssDescriptorsHolder = this.myDescriptors;
        if (cssDescriptorsHolder == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(1);
        }
        return cssDescriptorsHolder;
    }

    private void loadPropertyDescriptor(@NotNull Element element) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(2);
        }
        String name = element.getAttributeValue("id");
        CssMediaGroup[] mediaGroup = CssDescriptorsLoader.parseMediaGroups(element);
        String initialValue = element.getAttributeValue("initial");
        String appliesToValue = element.getAttributeValue("applies");
        String percentageValue = element.getAttributeValue("percentage");
        boolean inherited = CssDescriptorsLoader.parseBoolean(element, "inherited", false);
        this.myDescriptors.properties.putValue((Object)name.toLowerCase(Locale.US), (Object)new CssPropertyDescriptorImplEx(CssDescriptorsLoader.parseCommonDescriptorData(element), this.loadValueOfElement(element), initialValue, appliesToValue, percentageValue, inherited, mediaGroup));
    }

    private void loadPrefixedPropertyDescriptor(@NotNull Element element) {
        CssElementDescriptor.CssVersion cssVersion;
        String name;
        ArrayList descriptors;
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(3);
        }
        if ((descriptors = ContainerUtil.newArrayList((Iterable)this.myDescriptors.properties.get((Object)(name = element.getAttributeValue("id"))))).isEmpty()) {
            LOG.error("Property should be declared before using prefixed declaration.", new String[]{name});
            return;
        }
        CssPropertyDescriptor originalProperty = (CssPropertyDescriptor)ContainerUtil.getLastItem((List)descriptors);
        String prefix = element.getAttributeValue("prefix");
        String propertyName = "-" + prefix + "-" + name;
        BrowserVersion[] browserVersions = CssDescriptorsLoader.parseBrowsers(element);
        assert (originalProperty != null);
        String url = element.getAttributeValue("url");
        CssElementDescriptor.CssVersion cssVersion2 = cssVersion = url != null ? originalProperty.getCssVersion() : CssElementDescriptor.CssVersion.UNKNOWN;
        if (url == null) {
            url = originalProperty.getSpecificationUrl();
        }
        CssCommonDescriptorData commonDescriptorData = new CssCommonDescriptorData(propertyName, "-" + prefix + "-" + originalProperty.getPresentableName(), originalProperty.getAllowedContextTypes(), browserVersions, cssVersion, url, originalProperty.getDescription());
        this.myDescriptors.properties.putValue((Object)propertyName.toLowerCase(Locale.US), (Object)new CssPropertyDescriptorImplEx(commonDescriptorData, originalProperty.getValueDescriptor(), originalProperty.getInitialValue(), originalProperty.getAppliesToValue(), originalProperty.getPercentageValue(), originalProperty.isInherited(), originalProperty.getMediaGroups()));
    }

    private void loadFunctionDescriptor(@NotNull Element element) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(4);
        }
        String name = element.getAttributeValue("id");
        String returnTypeName = element.getAttributeValue("returnType");
        CssTermType returnType = StringUtil.isNotEmpty((String)returnTypeName) ? CssTermTypeImpl.find(returnTypeName) : CssTermType.UNKNOWN;
        this.myDescriptors.functions.putValue((Object)name.toLowerCase(Locale.US), (Object)new CssFunctionDescriptorImpl(CssDescriptorsLoader.parseCommonDescriptorData(element, "", PROCESS_FUNCTION_PRESENTABLE_NAME), this.loadValueOfElement(element), returnType));
    }

    private void loadPrefixedFunctionDescriptor(@NotNull Element element) {
        CssElementDescriptor.CssVersion cssVersion;
        String name;
        Collection descriptors;
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(5);
        }
        if ((descriptors = this.myDescriptors.functions.get((Object)(name = element.getAttributeValue("id")))).size() != 1) {
            LOG.error("Function should be declared before using prefixed declaration.", new String[]{name});
            return;
        }
        CssFunctionDescriptor originalFunction = (CssFunctionDescriptor)ContainerUtil.getFirstItem((Collection)descriptors);
        String prefix = element.getAttributeValue("prefix");
        String functionName = "-" + prefix + "-" + name;
        BrowserVersion[] browserVersions = CssDescriptorsLoader.parseBrowsers(element);
        assert (originalFunction != null);
        String url = element.getAttributeValue("url");
        CssElementDescriptor.CssVersion cssVersion2 = cssVersion = url != null ? originalFunction.getCssVersion() : CssElementDescriptor.CssVersion.UNKNOWN;
        if (url == null) {
            url = originalFunction.getSpecificationUrl();
        }
        CssCommonDescriptorData commonDescriptorData = new CssCommonDescriptorData(functionName, "-" + prefix + "-" + originalFunction.getPresentableName(), originalFunction.getAllowedContextTypes(), browserVersions, cssVersion, url, originalFunction.getDescription());
        this.myDescriptors.functions.putValue((Object)functionName.toLowerCase(Locale.US), (Object)new CssFunctionDescriptorImpl(commonDescriptorData, originalFunction.getValueDescriptor(), originalFunction.getType()));
    }

    private void loadMediaFeatureDescriptor(@NotNull Element element) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(6);
        }
        String name = element.getAttributeValue("id").toLowerCase(Locale.US);
        CssValueDescriptor valueDescriptor = this.loadValueOfElement(element);
        CssCommonDescriptorData commonDescriptorData = CssDescriptorsLoader.parseCommonDescriptorData(element);
        CssMediaGroup[] mediaGroups = CssDescriptorsLoader.parseMediaGroups(element);
        String appliesToValue = element.getAttributeValue("applies");
        this.myDescriptors.mediaFeatures.putValue((Object)name, (Object)new CssMediaFeatureDescriptorImpl(appliesToValue, mediaGroups, commonDescriptorData, valueDescriptor));
        boolean acceptsMinMaxPrefixed = CssDescriptorsLoader.parseBoolean(element, "min-max", false);
        if (acceptsMinMaxPrefixed) {
            this.myDescriptors.mediaFeatures.putValue((Object)("min-" + name), (Object)new CssMediaFeatureDescriptorImpl(appliesToValue, mediaGroups, commonDescriptorData.cloneWithPrefix("min-"), valueDescriptor));
            this.myDescriptors.mediaFeatures.putValue((Object)("max-" + name), (Object)new CssMediaFeatureDescriptorImpl(appliesToValue, mediaGroups, commonDescriptorData.cloneWithPrefix("max-"), valueDescriptor));
        }
    }

    private void loadNamedValueDescriptor(@NotNull Element element) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(7);
        }
        String name = element.getAttributeValue("id");
        CssValueDescriptor valueDescriptor = CssValueDescriptorModificator.withCommonData(this.loadValueOfElement(element), CssDescriptorsLoader.parseCommonDescriptorData(element));
        this.myDescriptors.namedValues.putValue((Object)name.toLowerCase(Locale.US), (Object)valueDescriptor);
    }

    private void loadPseudoClassDescriptor(@NotNull Element element) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(8);
        }
        boolean hasArguments = element.getChildren().size() > element.getChildren("description", CssSchemeConstants.NAMESPACE).size();
        String name = element.getAttributeValue("id");
        this.myDescriptors.pseudoSelectors.putValue((Object)name.toLowerCase(Locale.US), (Object)new CssPseudoClassDescriptorImpl(CssDescriptorsLoader.parseCommonDescriptorData(element), CssDescriptorsLoader.parseBoolean(element, "elementRequired", false), hasArguments));
    }

    private void loadPseudoElementDescriptor(@NotNull Element element) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(9);
        }
        String name = element.getAttributeValue("id");
        boolean hasArguments = element.getChildren().size() > element.getChildren("description", CssSchemeConstants.NAMESPACE).size();
        this.myDescriptors.pseudoSelectors.putValue((Object)name.toLowerCase(Locale.US), (Object)new CssPseudoElementDescriptorImpl(CssDescriptorsLoader.parseCommonDescriptorData(element), CssDescriptorsLoader.parseBoolean(element, "elementRequired", false), hasArguments));
    }

    private static boolean parseBoolean(@NotNull Element element, String attributeName, boolean defaultValue) {
        String attributeValue;
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(10);
        }
        return (attributeValue = element.getAttributeValue(attributeName)) != null ? "yes".equals(attributeValue) : defaultValue;
    }

    private static int parseInt(@NotNull Element element, String attributeName, int defaultValue) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(11);
        }
        try {
            Attribute attribute = element.getAttribute(attributeName);
            return attribute != null ? attribute.getIntValue() : defaultValue;
        }
        catch (DataConversionException e) {
            return defaultValue;
        }
    }

    @NotNull
    private static CssContextType[] parseContextTypes(@NotNull Element element) {
        String rules;
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(12);
        }
        if (Strings.isNullOrEmpty((String)(rules = element.getAttributeValue("rules")))) {
            if (ANY_AT_RULE_TYPES == null) {
                CssDescriptorsLoader.$$$reportNull$$$0(13);
            }
            return ANY_AT_RULE_TYPES;
        }
        TreeSet result = Sets.newTreeSet((Comparator)CssContextType.COMPARATOR);
        for (String rule : COMMA_SPLITTER.split((CharSequence)rules)) {
            result.add(CssContextType.fromString((String)rule));
        }
        CssContextType[] cssContextTypeArray = result.toArray(new CssContextType[result.size()]);
        if (cssContextTypeArray == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(14);
        }
        return cssContextTypeArray;
    }

    @NotNull
    private static CssElementDescriptor.CssVersion parseVersion(@NotNull Element element) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(15);
        }
        CssElementDescriptor.CssVersion cssVersion = CssElementDescriptor.CssVersion.fromString((String)element.getAttributeValue("declared-in"));
        if (cssVersion == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(16);
        }
        return cssVersion;
    }

    @Nullable
    private static CssElementDescriptor.CssVersion parseObsoleteVersion(@NotNull Element element) {
        String obsoleteInValue;
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(17);
        }
        return (obsoleteInValue = element.getAttributeValue("obsolete-in")) != null ? CssElementDescriptor.CssVersion.fromString((String)obsoleteInValue) : null;
    }

    @Nullable
    private static String parseDescription(@NotNull Element element) {
        Element descriptionTag;
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(18);
        }
        if ((descriptionTag = element.getChild("description", CssSchemeConstants.NAMESPACE)) != null) {
            return CssDescriptorsLoader.processDocumentation(descriptionTag.getTextTrim());
        }
        return CssDescriptorsLoader.processDocumentation(StringUtil.escapeXml((String)element.getAttributeValue("tooltip")));
    }

    @Nullable
    private static String processDocumentation(@Nullable String result) {
        if (result == null || result.isEmpty()) {
            return null;
        }
        Matcher matcher = DOCUMENTATION_LINK_PATTERN.matcher(result);
        if (matcher.find()) {
            result = matcher.replaceAll("<a href=\"psi_element://$1\">$2</a>");
        }
        return result;
    }

    private static BrowserVersion[] parseBrowsers(@NotNull Element element) {
        String browsers;
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(19);
        }
        if (Strings.isNullOrEmpty((String)(browsers = element.getAttributeValue("browsers")))) {
            return BrowserVersion.EMPTY_ARRAY;
        }
        TreeSet result = ContainerUtilRt.newTreeSet((Comparator)BrowserVersion.COMPARATOR);
        for (String browser : COMMA_SPLITTER.split((CharSequence)browsers)) {
            result.add(BrowserVersion.fromString((String)browser));
        }
        return result.toArray(new BrowserVersion[result.size()]);
    }

    @NotNull
    private CssValueDescriptor loadValueOfElement(@NotNull Element valueOwnerElement) {
        if (valueOwnerElement == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(20);
        }
        List children = valueOwnerElement.getChildren();
        for (Element child : children) {
            CssValueDescriptor valueDescriptor = this.parseValue(child, null);
            if (valueDescriptor == null) continue;
            CssValueDescriptor cssValueDescriptor = valueDescriptor;
            if (cssValueDescriptor == null) {
                CssDescriptorsLoader.$$$reportNull$$$0(21);
            }
            return cssValueDescriptor;
        }
        throw new IllegalArgumentException("Value cannot be empty");
    }

    @Nullable
    private CssValueDescriptor parseValue(@NotNull Element valueElement, @Nullable CssValueDescriptor parent) {
        if (valueElement == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(22);
        }
        this.checkCancelled();
        String name = valueElement.getName();
        if ("description".equalsIgnoreCase(name)) {
            return null;
        }
        CssValueType valueType = CssValueType.fromTag((String)name);
        if (valueType == null) {
            throw new IllegalArgumentException("Unknown value: " + valueElement.toString());
        }
        switch (valueType) {
            case GROUP: {
                return this.parseGroupValue(valueElement, parent);
            }
            case INLINE: {
                return this.parseInlineValue(valueElement, parent);
            }
            case URI: {
                return this.parseUriValue(valueElement, parent);
            }
            case STRING: {
                return this.parseStringValue(valueElement, parent);
            }
            case INTEGER: {
                return this.parseIntegerValue(valueElement, parent);
            }
            case PERCENTAGE: {
                return this.parsePercentageValue(valueElement, parent);
            }
            case NAME: {
                return this.parseNameValue(valueElement, parent);
            }
            case PROPERTY: {
                return this.parsePropertyReferenceValue(valueElement, parent);
            }
            case ANGLE: {
                return this.parseAngleValue(valueElement, parent);
            }
            case FREQUENCY: {
                return this.parseFrequencyValue(valueElement, parent);
            }
            case POSITION: {
                return this.parsePositionValue(valueElement, parent);
            }
            case RESOLUTION: {
                return this.parseResolutionValue(valueElement, parent);
            }
            case LENGTH: {
                return this.parseLengthValue(valueElement, parent);
            }
            case NUMBER: {
                return this.parseNumberValue(valueElement, parent);
            }
            case TIME: {
                return this.parseTimeValue(valueElement, parent);
            }
            case DECIBEL: {
                return this.parseDecibelValue(valueElement, parent);
            }
            case SEMITONES: {
                return this.parseSemitoneValue(valueElement, parent);
            }
            case FLEX: {
                return this.parseFlexValue(valueElement, parent);
            }
            case URANGE: {
                return this.parseUrangeValue(valueElement, parent);
            }
            case INVOKE: {
                return this.parseFunctionValue(valueElement, parent);
            }
            case TEXT: {
                return this.parseTextValue(valueElement, parent);
            }
            case COLOR: {
                return this.parseColorValue(valueElement, parent);
            }
            case EXPRESSION: {
                return this.parseExpressionValue(valueElement, parent);
            }
            case JAVASCRIPT: {
                return this.parseJavaScriptValue(valueElement, parent);
            }
            case SELECTOR: {
                return this.parseSelectorValue(valueElement, parent);
            }
            case ANY: {
                return this.parseAnyValue(valueElement, parent);
            }
        }
        throw new IllegalArgumentException("Unknown value: " + valueElement.toString());
    }

    private void checkCancelled() {
        if (this.myProgressIndicator != null) {
            this.myProgressIndicator.checkCanceled();
        }
    }

    @NotNull
    private CssValueDescriptor parseFunctionValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(23);
        }
        CssFunctionInvocationValue cssFunctionInvocationValue = new CssFunctionInvocationValue(element.getAttributeValue("name"), CssDescriptorsLoader.parseCommonDescriptorData(element, "", PROCESS_FUNCTION_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssFunctionInvocationValue == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(24);
        }
        return cssFunctionInvocationValue;
    }

    @NotNull
    private CssValueDescriptor parsePropertyReferenceValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(25);
        }
        String refId = element.getAttributeValue("id");
        assert (StringUtil.isNotEmpty((String)refId));
        CssPropertyReferenceValue cssPropertyReferenceValue = new CssPropertyReferenceValue(refId, CssDescriptorsLoader.parseCommonDescriptorData(element, refId, PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssPropertyReferenceValue == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(26);
        }
        return cssPropertyReferenceValue;
    }

    @NotNull
    private CssValueDescriptor parseNameValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(27);
        }
        String value = element.getAttributeValue("value");
        ContainerUtil.addIfNotNull(this.myDescriptors.valueIdentifiers, (Object)value);
        CssNameValue cssNameValue = new CssNameValue(value, false, CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"name.value.presentable.name", (Object[])new Object[0])), this.parseValueDescriptorData(element, parent));
        if (cssNameValue == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(28);
        }
        return cssNameValue;
    }

    @NotNull
    private CssValueDescriptor parseJavaScriptValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(29);
        }
        CssJavaScriptValue cssJavaScriptValue = new CssJavaScriptValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"java.script.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssJavaScriptValue == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(30);
        }
        return cssJavaScriptValue;
    }

    @NotNull
    private CssValueDescriptor parseAngleValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(31);
        }
        CssAngleValue cssAngleValue = new CssAngleValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"angle.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssAngleValue == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(32);
        }
        return cssAngleValue;
    }

    @NotNull
    private CssValueDescriptor parseFrequencyValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(33);
        }
        CssFrequencyValue cssFrequencyValue = new CssFrequencyValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"frequency.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssFrequencyValue == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(34);
        }
        return cssFrequencyValue;
    }

    @NotNull
    private CssValueDescriptor parsePositionValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(35);
        }
        CssPositionValue cssPositionValue = new CssPositionValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"position.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssPositionValue == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(36);
        }
        return cssPositionValue;
    }

    @NotNull
    private CssValueDescriptor parseResolutionValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(37);
        }
        CssResolutionValue cssResolutionValue = new CssResolutionValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"resolution.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssResolutionValue == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(38);
        }
        return cssResolutionValue;
    }

    @NotNull
    private CssValueDescriptor parseLengthValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(39);
        }
        CssLengthValue cssLengthValue = new CssLengthValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"length.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssLengthValue == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(40);
        }
        return cssLengthValue;
    }

    @NotNull
    private CssValueDescriptor parseNumberValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(41);
        }
        CssNumberValue cssNumberValue = new CssNumberValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"number.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssNumberValue == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(42);
        }
        return cssNumberValue;
    }

    @NotNull
    private CssValueDescriptor parseTimeValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(43);
        }
        CssTimeValue cssTimeValue = new CssTimeValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"time.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssTimeValue == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(44);
        }
        return cssTimeValue;
    }

    @NotNull
    private CssValueDescriptor parseDecibelValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(45);
        }
        CssDecibelValue cssDecibelValue = new CssDecibelValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"decibel.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssDecibelValue == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(46);
        }
        return cssDecibelValue;
    }

    @NotNull
    private CssValueDescriptor parseSemitoneValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(47);
        }
        CssSemitonesValue cssSemitonesValue = new CssSemitonesValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"semitones.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssSemitonesValue == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(48);
        }
        return cssSemitonesValue;
    }

    @NotNull
    private CssValueDescriptor parseFlexValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(49);
        }
        CssFlexValue cssFlexValue = new CssFlexValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"flex.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssFlexValue == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(50);
        }
        return cssFlexValue;
    }

    @NotNull
    private CssValueDescriptor parseUrangeValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(51);
        }
        CssUrangeValue cssUrangeValue = new CssUrangeValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"urange.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssUrangeValue == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(52);
        }
        return cssUrangeValue;
    }

    @NotNull
    private CssValueDescriptor parsePercentageValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(53);
        }
        CssPercentageValue cssPercentageValue = new CssPercentageValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"percentage.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssPercentageValue == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(54);
        }
        return cssPercentageValue;
    }

    @NotNull
    private CssValueDescriptor parseColorValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(55);
        }
        CssColorValue cssColorValue = new CssColorValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"color.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent), true);
        if (cssColorValue == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(56);
        }
        return cssColorValue;
    }

    @NotNull
    private CssValueDescriptor parseAnyValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(57);
        }
        CssAnyValueImpl cssAnyValueImpl = new CssAnyValueImpl(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"any.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssAnyValueImpl == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(58);
        }
        return cssAnyValueImpl;
    }

    @NotNull
    private CssValueDescriptor parseIntegerValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(59);
        }
        CssIntegerValue cssIntegerValue = new CssIntegerValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"integer.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssIntegerValue == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(60);
        }
        return cssIntegerValue;
    }

    @NotNull
    private CssValueDescriptor parseStringValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(61);
        }
        CssStringValue cssStringValue = new CssStringValue(element.getAttributeValue("value"), CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"string.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssStringValue == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(62);
        }
        return cssStringValue;
    }

    @NotNull
    private CssValueDescriptor parseTextValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(63);
        }
        String value = element.getAttributeValue("value");
        ContainerUtil.addIfNotNull(this.myDescriptors.valueIdentifiers, (Object)value);
        CssTextValue cssTextValue = new CssTextValue(value, CssDescriptorsLoader.parseCommonDescriptorData(element), this.parseValueDescriptorData(element, parent));
        if (cssTextValue == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(64);
        }
        return cssTextValue;
    }

    @NotNull
    private CssValueDescriptor parseExpressionValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(65);
        }
        CssExpressionValue cssExpressionValue = new CssExpressionValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"expression.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssExpressionValue == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(66);
        }
        return cssExpressionValue;
    }

    @NotNull
    private CssValueDescriptor parseSelectorValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(67);
        }
        CssSelectorValue cssSelectorValue = new CssSelectorValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"selector.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssSelectorValue == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(68);
        }
        return cssSelectorValue;
    }

    @NotNull
    private CssValueDescriptor parseUriValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(69);
        }
        CssUrlValue cssUrlValue = new CssUrlValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"url.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (cssUrlValue == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(70);
        }
        return cssUrlValue;
    }

    @NotNull
    private CssValueDescriptor parseInlineValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(71);
        }
        boolean inline = CssDescriptorsLoader.parseBoolean(element, "inline", false);
        String name = element.getAttributeValue("id");
        if ("id".equalsIgnoreCase(name)) {
            CssIdValue cssIdValue = new CssIdValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message((String)"id.value.presentable.name", (Object[])new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
            if (cssIdValue == null) {
                CssDescriptorsLoader.$$$reportNull$$$0(72);
            }
            return cssIdValue;
        }
        CssInlineValue inlineValue = new CssInlineValue(name, CssDescriptorsLoader.parseCommonDescriptorData(element, name, PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (inline) {
            CssValueDescriptor namedValue;
            Collection namedValues = this.myDescriptors.namedValues.get((Object)name);
            if (namedValues.size() == 1 && (namedValue = (CssValueDescriptor)ContainerUtil.getFirstItem((Collection)namedValues)) != null) {
                CssValueDescriptor result = CssValueDescriptorModificator.withParent(namedValue, parent);
                if (inlineValue.isCommaSeparated() || inlineValue.getMinOccur() != 1 || inlineValue.getMaxOccur() != 1) {
                    CssValueDescriptor cssValueDescriptor = CssValueDescriptorModificator.withQuantifiers(result, inlineValue.getMinOccur(), inlineValue.getMaxOccur(), inlineValue.isCommaSeparated());
                    if (cssValueDescriptor == null) {
                        CssDescriptorsLoader.$$$reportNull$$$0(73);
                    }
                    return cssValueDescriptor;
                }
                CssValueDescriptor cssValueDescriptor = result;
                if (cssValueDescriptor == null) {
                    CssDescriptorsLoader.$$$reportNull$$$0(74);
                }
                return cssValueDescriptor;
            }
            LOG.error("Named value should be declared before inlining.", new String[]{name});
        }
        CssInlineValue cssInlineValue = inlineValue;
        if (cssInlineValue == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(75);
        }
        return cssInlineValue;
    }

    @NotNull
    private CssValueDescriptor parseGroupValue(@NotNull Element valueElement, @Nullable CssValueDescriptor parent) {
        if (valueElement == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(76);
        }
        CssGroupValue cssGroupValue = CssGroupValue.create(CssDescriptorsLoader.parseCommonDescriptorData(valueElement, "", PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(valueElement, parent), CssDescriptorsLoader.parseBoolean(valueElement, "ignoreWhitespaces", true), this.parseSeparator(valueElement), CssDescriptorsLoader.parseGroupType(valueElement));
        for (Element child : valueElement.getChildren()) {
            CssValueDescriptor descriptor;
            if ("separator".equals(child.getName()) || (descriptor = this.parseValue(child, cssGroupValue)) == null) continue;
            cssGroupValue.addChild(descriptor);
        }
        CssGroupValue cssGroupValue2 = cssGroupValue;
        if (cssGroupValue2 == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(77);
        }
        return cssGroupValue2;
    }

    @Nullable
    private CssValueDescriptor parseSeparator(@NotNull Element element) {
        Element separatorTag;
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(78);
        }
        return (separatorTag = element.getChild("separator", CssSchemeConstants.NAMESPACE)) != null ? this.loadValueOfElement(separatorTag) : null;
    }

    @Nullable
    private CssValueDescriptor parseExclusion(@NotNull Element element) {
        Element exclusionTag;
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(79);
        }
        return (exclusionTag = element.getChild("exclusion", CssSchemeConstants.NAMESPACE)) != null ? this.loadValueOfElement(exclusionTag) : null;
    }

    @NotNull
    private static CssGroupValue.Type parseGroupType(@NotNull Element element) {
        String typeAttributeValue;
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(80);
        }
        CssGroupValue.Type type = Strings.isNullOrEmpty((String)(typeAttributeValue = element.getAttributeValue("type"))) ? CssGroupValue.Type.ALL : CssGroupValue.Type.valueOf(typeAttributeValue.toUpperCase(Locale.US));
        if (type == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(81);
        }
        return type;
    }

    @NotNull
    private CssValueDescriptorData parseValueDescriptorData(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(82);
        }
        boolean commaSeparated = CssDescriptorsLoader.parseBoolean(element, "comma-separated", false);
        int minOccur = CssDescriptorsLoader.parseInt(element, "min", 1);
        int maxOccur = CssDescriptorsLoader.parseInt(element, "max", commaSeparated ? -1 : 1);
        if (maxOccur != -1 && maxOccur < minOccur) {
            maxOccur = minOccur;
        }
        CssValueDescriptorData cssValueDescriptorData = new CssValueDescriptorData(CssDescriptorsLoader.parseBoolean(element, "completion", true), minOccur, maxOccur, CssDescriptorsLoader.parseObsoleteVersion(element), CssDescriptorsLoader.processDocumentation(StringUtil.escapeXml((String)element.getAttributeValue("obsolete-tooltip"))), parent, this.parseExclusion(element), commaSeparated);
        if (cssValueDescriptorData == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(83);
        }
        return cssValueDescriptorData;
    }

    @NotNull
    private static CssCommonDescriptorData parseCommonDescriptorData(@NotNull Element element) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(84);
        }
        CssCommonDescriptorData cssCommonDescriptorData = CssDescriptorsLoader.parseCommonDescriptorData(element, "", (Function<String, String>)Functions.id());
        if (cssCommonDescriptorData == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(85);
        }
        return cssCommonDescriptorData;
    }

    @NotNull
    private static CssCommonDescriptorData parseCommonDescriptorData(@NotNull Element element, @NotNull String defaultPresentableName) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(86);
        }
        if (defaultPresentableName == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(87);
        }
        CssCommonDescriptorData cssCommonDescriptorData = CssDescriptorsLoader.parseCommonDescriptorData(element, defaultPresentableName, (Function<String, String>)Functions.id());
        if (cssCommonDescriptorData == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(88);
        }
        return cssCommonDescriptorData;
    }

    @NotNull
    private static CssCommonDescriptorData parseCommonDescriptorData(@NotNull Element element, @NotNull String defaultPresentableName, @NotNull Function<String, String> processPresentableName) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(89);
        }
        if (defaultPresentableName == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(90);
        }
        if (processPresentableName == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(91);
        }
        String id = element.getAttributeValue("id", defaultPresentableName);
        String valueAttribute = element.getAttributeValue("value", id);
        String presentableName = (String)processPresentableName.fun((Object)element.getAttributeValue("name", valueAttribute));
        CssCommonDescriptorData cssCommonDescriptorData = new CssCommonDescriptorData(id, presentableName, CssDescriptorsLoader.parseContextTypes(element), CssDescriptorsLoader.parseBrowsers(element), CssDescriptorsLoader.parseVersion(element), element.getAttributeValue("url"), Strings.nullToEmpty((String)CssDescriptorsLoader.parseDescription(element)));
        if (cssCommonDescriptorData == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(92);
        }
        return cssCommonDescriptorData;
    }

    @NotNull
    private static CssMediaGroup[] parseMediaGroups(Element element) {
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        for (String s : StringUtil.split((String)element.getAttributeValue("media", "all").toUpperCase(Locale.US), (String)" ")) {
            try {
                result.add(CssMediaGroup.valueOf((String)s.trim()));
            }
            catch (IllegalArgumentException e) {
                Collections.addAll(result, CssMediaType.valueOf((String)s.trim()).getSupportedGroups());
            }
        }
        CssMediaGroup[] cssMediaGroupArray = !result.isEmpty() ? result.toArray(new CssMediaGroup[result.size()]) : CssElementDescriptorConstants.EMPTY_MEDIA_GROUP;
        if (cssMediaGroupArray == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(93);
        }
        return cssMediaGroupArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 16: 
            case 21: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 81: 
            case 83: 
            case 85: 
            case 88: 
            case 92: 
            case 93: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 16: 
            case 21: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 81: 
            case 83: 
            case 85: 
            case 88: 
            case 92: 
            case 93: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 16: 
            case 21: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 81: 
            case 83: 
            case 85: 
            case 88: 
            case 92: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 55: 
            case 57: 
            case 59: 
            case 61: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 71: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 84: 
            case 86: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueOwnerElement";
                break;
            }
            case 22: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueElement";
                break;
            }
            case 87: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultPresentableName";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptors";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "parseContextTypes";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "parseVersion";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "loadValueOfElement";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "parseFunctionValue";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePropertyReferenceValue";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "parseNameValue";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "parseJavaScriptValue";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAngleValue";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "parseFrequencyValue";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePositionValue";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "parseResolutionValue";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "parseLengthValue";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "parseNumberValue";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTimeValue";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDecibelValue";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSemitoneValue";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "parseFlexValue";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "parseUrangeValue";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePercentageValue";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "parseColorValue";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAnyValue";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "parseIntegerValue";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "parseStringValue";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTextValue";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "parseExpressionValue";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSelectorValue";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "parseUriValue";
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "parseInlineValue";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "parseGroupValue";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "parseGroupType";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "parseValueDescriptorData";
                break;
            }
            case 85: 
            case 88: 
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "parseCommonDescriptorData";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "parseMediaGroups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptors";
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 16: 
            case 21: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 81: 
            case 83: 
            case 85: 
            case 88: 
            case 92: 
            case 93: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadPropertyDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadPrefixedPropertyDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadFunctionDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadPrefixedFunctionDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadMediaFeatureDescriptor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadNamedValueDescriptor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadPseudoClassDescriptor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadPseudoElementDescriptor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseBoolean";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseInt";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseContextTypes";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseVersion";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parseObsoleteVersion";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "parseDescription";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "parseBrowsers";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "loadValueOfElement";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "parseValue";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "parseFunctionValue";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "parsePropertyReferenceValue";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "parseNameValue";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "parseJavaScriptValue";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "parseAngleValue";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "parseFrequencyValue";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "parsePositionValue";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "parseResolutionValue";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "parseLengthValue";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "parseNumberValue";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "parseTimeValue";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "parseDecibelValue";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "parseSemitoneValue";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "parseFlexValue";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "parseUrangeValue";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "parsePercentageValue";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "parseColorValue";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "parseAnyValue";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "parseIntegerValue";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "parseStringValue";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "parseTextValue";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "parseExpressionValue";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "parseSelectorValue";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "parseUriValue";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "parseInlineValue";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "parseGroupValue";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "parseSeparator";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "parseExclusion";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "parseGroupType";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "parseValueDescriptorData";
                break;
            }
            case 84: 
            case 86: 
            case 87: 
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "parseCommonDescriptorData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 16: 
            case 21: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 81: 
            case 83: 
            case 85: 
            case 88: 
            case 92: 
            case 93: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

