/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.index;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lexer.FilterLexer;
import com.intellij.lexer.HtmlHighlightingLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.XHtmlHighlightingLexer;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.CssHighlighterLexer;
import com.intellij.psi.css.impl.util.scheme.CssElementDescriptorFactory2;
import com.intellij.psi.css.index.CssIndexValue;
import com.intellij.psi.css.index.CssSupportedFileTypesProvider;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.TIntArrayList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssIndex
extends FileBasedIndexExtension<String, TIntArrayList> {
    public static final ID<String, TIntArrayList> CSS_INDEX = ID.create((String)"CssIndex");
    private final DataExternalizer<TIntArrayList> myValueExternalizer = new DataExternalizer<TIntArrayList>(){

        public void save(@NotNull DataOutput out, TIntArrayList values) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            int size = values.size();
            DataInputOutputUtil.writeINT((DataOutput)out, (int)size);
            for (int i = 0; i < size; ++i) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)values.getQuick(i));
            }
        }

        public TIntArrayList read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            int count = DataInputOutputUtil.readINT((DataInput)in);
            TIntArrayList result = new TIntArrayList(count);
            for (int i = 0; i < count; ++i) {
                result.add(DataInputOutputUtil.readINT((DataInput)in));
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/css/index/CssIndex$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public static boolean isSupportedTemplateLanguage(FileType fileType) {
        Language language;
        return fileType instanceof LanguageFileType && (language = ((LanguageFileType)fileType).getLanguage()) instanceof TemplateLanguage && LanguageParserDefinitions.INSTANCE.forLanguage(language) != null;
    }

    public static boolean isFontOrFontFamily(String s) {
        return s.equalsIgnoreCase("font-family") || s.equalsIgnoreCase("font");
    }

    @NotNull
    public ID<String, TIntArrayList> getName() {
        ID<String, TIntArrayList> iD = CSS_INDEX;
        if (iD == null) {
            CssIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, TIntArrayList, FileContent> getIndexer() {
        DataIndexer<String, TIntArrayList, FileContent> dataIndexer = new DataIndexer<String, TIntArrayList, FileContent>(){

            @NotNull
            public Map<String, TIntArrayList> map(@NotNull FileContent inputData) {
                FileViewProvider provider;
                if (inputData == null) {
                    2.$$$reportNull$$$0(0);
                }
                final Map result = FactoryMap.create(key -> new TIntArrayList());
                FileType fileType = inputData.getFileType();
                if (!(fileType instanceof LanguageFileType)) {
                    Map map = result;
                    if (map == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return map;
                }
                Language language = ((LanguageFileType)fileType).getLanguage();
                if (language instanceof TemplateLanguage && (provider = inputData.getPsiFile().getViewProvider()) instanceof TemplateLanguageFileViewProvider) {
                    language = ((TemplateLanguageFileViewProvider)provider).getTemplateDataLanguage();
                }
                final boolean indexingCss = language == CSSLanguage.INSTANCE;
                CssIndex.this.indexValues(language, inputData.getContentAsText(), new CssIndexCallback(){

                    @Override
                    public void index(int offset, CssIndexValue type, @NotNull String value) {
                        if (value == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        this.addValue(offset, (CssIndexValue)((Object)ObjectUtils.notNull((Object)((Object)type), (Object)((Object)CssIndexValue.COLOR))), value, type);
                    }

                    private void addValue(int offset, CssIndexValue type, String value, CssIndexValue originalValueType) {
                        TIntArrayList list = (TIntArrayList)result.get(type.indexKey(value));
                        if (indexingCss && (originalValueType == null || originalValueType == CssIndexValue.ANIMATION) && !list.isEmpty()) {
                            return;
                        }
                        list.add(offset);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/index/CssIndex$2$1", "index"));
                    }
                });
                Map map = result;
                if (map == null) {
                    2.$$$reportNull$$$0(2);
                }
                return map;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/css/index/CssIndex$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/css/index/CssIndex$2";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (dataIndexer == null) {
            CssIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            CssIndex.$$$reportNull$$$0(2);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<TIntArrayList> getValueExternalizer() {
        DataExternalizer<TIntArrayList> dataExternalizer = this.myValueExternalizer;
        if (dataExternalizer == null) {
            CssIndex.$$$reportNull$$$0(3);
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileType[] types = (FileType[])Holder.supportedFileTypes.toArray(new LanguageFileType[Holder.supportedFileTypes.size()]);
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(types){

            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!super.acceptInput(file)) {
                    return false;
                }
                FileType fileType = file.getFileType();
                if (fileType == HtmlFileType.INSTANCE || fileType == XHtmlFileType.INSTANCE) {
                    return file.isInLocalFileSystem();
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/index/CssIndex$3", "acceptInput"));
            }
        };
        if (defaultFileTypeSpecificInputFilter == null) {
            CssIndex.$$$reportNull$$$0(4);
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        int version = 29;
        for (LanguageFileType fileType : Holder.supportedFileTypes) {
            version += fileType.getName().hashCode();
        }
        return version;
    }

    public void indexValues(@NotNull Language language, @NotNull CharSequence input, @NotNull CssIndexCallback callback) {
        if (language == null) {
            CssIndex.$$$reportNull$$$0(5);
        }
        if (input == null) {
            CssIndex.$$$reportNull$$$0(6);
        }
        if (callback == null) {
            CssIndex.$$$reportNull$$$0(7);
        }
        if (language == CssFileType.INSTANCE.getLanguage()) {
            CssHighlighterLexer lexer = new CssHighlighterLexer(CssElementDescriptorFactory2.getInstance().getValueIdentifiers());
            lexer.start(input);
            CssIndex.indexCss(input, callback, (Lexer)lexer, false);
        }
        if (language == HTMLLanguage.INSTANCE || language == XHTMLLanguage.INSTANCE) {
            HtmlHighlightingLexer originalLexer = language == HTMLLanguage.INSTANCE ? new HtmlHighlightingLexer((FileType)CssFileType.INSTANCE) : new XHtmlHighlightingLexer();
            FilterLexer lexer = new FilterLexer((Lexer)originalLexer, new FilterLexer.Filter(){

                public boolean reject(IElementType type) {
                    return XmlTokenType.XML_WHITE_SPACE == type || XmlTokenType.XML_REAL_WHITE_SPACE == type || XmlTokenType.TAG_WHITE_SPACE == type;
                }
            });
            lexer.start(input);
            CssIndex.indexCss(input, callback, (Lexer)lexer, true);
        }
        for (CssSupportedFileTypesProvider provider : Holder.supportedFileTypesProviders) {
            if (language != provider.getLanguage()) continue;
            Lexer lexer = provider.getIndexingLexer();
            lexer.start(input);
            CssIndex.indexCss(input, callback, lexer, false);
        }
    }

    private static void indexCss(CharSequence input, CssIndexCallback callback, Lexer lexer, boolean blockInitial) {
        IElementType tokenType = lexer.getTokenType();
        boolean block = blockInitial;
        boolean afterAnimationNameProperty = false;
        boolean afterFontOrFontFamilyProperty = false;
        CharSequence lastAttrName = null;
        boolean isCssLexer = lexer instanceof CssHighlighterLexer;
        CssHighlighterLexer cssLexer = null;
        if (isCssLexer) {
            cssLexer = (CssHighlighterLexer)lexer;
        }
        StringBuilder fontFamilyPack = new StringBuilder();
        int fontFamilyPackTokenStart = 0;
        boolean fontFamilyPackHasMoreThanOneFontName = false;
        while (tokenType != null) {
            if (isCssLexer) {
                if (tokenType == CssElementTypes.CSS_COLOR) {
                    CssIndex.indexColorValue(lexer, input, callback);
                } else {
                    if (!CssIndex.indexKeyframes(lexer, input, callback)) {
                        tokenType = lexer.getTokenType();
                        continue;
                    }
                    if (tokenType == CssElementTypes.CSS_PROPERTY_NAME) {
                        CharSequence value = input.subSequence(lexer.getTokenStart(), lexer.getTokenEnd());
                        String propertyName = value.toString();
                        afterAnimationNameProperty = "animation-name".equalsIgnoreCase(propertyName);
                        afterFontOrFontFamilyProperty = CssIndex.isFontOrFontFamily(propertyName);
                        fontFamilyPackTokenStart = lexer.getTokenEnd();
                    } else if (afterAnimationNameProperty && tokenType == CssElementTypes.CSS_IDENT) {
                        CssIndex.indexAnimationName((Lexer)cssLexer, input, callback, false);
                        afterAnimationNameProperty = false;
                    } else if (afterFontOrFontFamilyProperty) {
                        if (cssLexer.isPropertyValueAllowed() && (tokenType == CssElementTypes.CSS_IDENT || tokenType == CssElementTypes.CSS_STRING_TOKEN || tokenType == CssElementTypes.CSS_PROPERTY_VALUE)) {
                            int tokenStart = cssLexer.getTokenStart();
                            int tokenEnd = cssLexer.getTokenEnd();
                            fontFamilyPack.append(input.subSequence(tokenStart, cssLexer.getTokenEnd()));
                            while (tokenType != null) {
                                cssLexer.advance();
                                tokenType = cssLexer.getTokenType();
                                if (tokenType == CssElementTypes.CSS_COMMA) {
                                    fontFamilyPack.append(", ");
                                    fontFamilyPackHasMoreThanOneFontName = true;
                                    break;
                                }
                                if (StringUtil.isEmptyOrSpaces((String)cssLexer.getTokenText())) {
                                    fontFamilyPack.append(' ');
                                } else {
                                    if (tokenType != CssElementTypes.CSS_IDENT) break;
                                    fontFamilyPack.append(cssLexer.getTokenText());
                                }
                                tokenEnd = cssLexer.getTokenEnd();
                            }
                            String fontFamily = input.subSequence(tokenStart, tokenEnd).toString().trim();
                            if ((fontFamily = StringUtil.unquoteString((String)fontFamily)).isEmpty()) continue;
                            callback.index(tokenStart, CssIndexValue.FONT_FAMILY, fontFamily);
                            continue;
                        }
                        if (tokenType != CssElementTypes.CSS_COMMA && tokenType != CssElementTypes.CSS_COLON && !StringUtil.isEmptyOrSpaces((String)lexer.getTokenText())) {
                            afterFontOrFontFamilyProperty = false;
                            if (fontFamilyPack.length() > 0 && fontFamilyPackHasMoreThanOneFontName) {
                                callback.index(fontFamilyPackTokenStart, CssIndexValue.FONT_FAMILY_PACK, fontFamilyPack.toString().trim());
                            }
                            fontFamilyPackTokenStart = 0;
                            fontFamilyPackHasMoreThanOneFontName = false;
                            fontFamilyPack.setLength(0);
                        }
                    }
                }
            } else {
                String name;
                if (XmlTokenType.XML_TAG_NAME == tokenType) {
                    lastAttrName = null;
                    String name2 = input.subSequence(lexer.getTokenStart(), lexer.getTokenEnd()).toString();
                    if ("style".equalsIgnoreCase(name2)) {
                        int startCss;
                        block = false;
                        while (lexer.getTokenType() != null && lexer.getTokenType() != XmlTokenType.XML_TAG_END) {
                            lexer.advance();
                        }
                        int endCss = startCss = lexer.getTokenEnd();
                        while (lexer.getTokenType() != null) {
                            if (lexer.getTokenType() == XmlTokenType.XML_END_TAG_START) {
                                String endTagName;
                                endCss = lexer.getTokenStart();
                                lexer.advance();
                                if (lexer.getTokenType() == XmlTokenType.XML_TAG_NAME && "style".equalsIgnoreCase(endTagName = input.subSequence(lexer.getTokenStart(), lexer.getTokenEnd()).toString())) break;
                            }
                            lexer.advance();
                        }
                        if (startCss < endCss) {
                            CssIndex.indexSubCss(input, callback, startCss, endCss, false);
                        }
                    } else if ("body".equalsIgnoreCase(name2)) {
                        block = true;
                    }
                } else if (XmlTokenType.XML_NAME == tokenType) {
                    lastAttrName = input.subSequence(lexer.getTokenStart(), lexer.getTokenEnd());
                }
                if (XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN == tokenType && lastAttrName != null && "style".equalsIgnoreCase(name = lastAttrName.toString())) {
                    CssIndex.indexSubCss(input, callback, lexer.getTokenStart(), lexer.getTokenEnd(), true);
                }
                CssIndex.index(lexer, block, input, callback);
            }
            lexer.advance();
            tokenType = lexer.getTokenType();
        }
    }

    private static void indexSubCss(CharSequence input, CssIndexCallback callback, int start, int end, boolean blockInitial) {
        CssHighlighterLexer styleBlockLexer = new CssHighlighterLexer(CssElementDescriptorFactory2.getInstance().getValueIdentifiers());
        styleBlockLexer.start(input, start, end);
        CssIndex.indexCss(input, callback, (Lexer)styleBlockLexer, blockInitial);
    }

    private static void index(Lexer lexer, boolean block, CharSequence input, CssIndexCallback callback) {
        if (block) {
            CssIndex.indexColorValue(lexer, input, callback);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean indexKeyframes(Lexer lexer, CharSequence input, CssIndexCallback callback) {
        if (lexer.getTokenType() != CssElementTypes.CSS_KEYFRAMES_SYM) return true;
        lexer.advance();
        if (!CssElementTypes.WHITESPACES.contains(lexer.getTokenType())) return false;
        lexer.advance();
        if (lexer.getTokenType() == CssElementTypes.CSS_IDENT) {
            CssIndex.indexAnimationName(lexer, input, callback, true);
            return true;
        } else {
            if (lexer.getTokenType() != CssElementTypes.CSS_COLON) return false;
            lexer.advance();
            if (lexer.getTokenType() != CssElementTypes.CSS_PSEUDO) {
                return false;
            }
            lexer.advance();
            if (lexer.getTokenType() != CssElementTypes.CSS_LPAREN) {
                return false;
            }
            lexer.advance();
            if (lexer.getTokenType() != CssElementTypes.CSS_IDENT) {
                return false;
            }
            CssIndex.indexAnimationName(lexer, input, callback, true);
        }
        return true;
    }

    private static void indexAnimationName(Lexer lexer, CharSequence input, CssIndexCallback callback, boolean afterKeyframes) {
        String value = input.subSequence(lexer.getTokenStart(), lexer.getTokenEnd()).toString();
        if (!value.isEmpty()) {
            callback.index(lexer.getTokenStart(), CssIndexValue.ANIMATION, value);
            if (afterKeyframes) {
                callback.index(lexer.getTokenStart(), CssIndexValue.KEYFRAMES, value);
            }
        }
    }

    private static void indexColorValue(Lexer lexer, CharSequence input, CssIndexCallback callback) {
        IElementType tokenType = lexer.getTokenType();
        CharSequence value = input.subSequence(lexer.getTokenStart(), lexer.getTokenEnd());
        if (tokenType == CssElementTypes.CSS_COLOR && value.length() > 1) {
            String hex_value = value.subSequence(1, value.length()).toString();
            if (hex_value.length() == 3) {
                StringBuilder v = new StringBuilder();
                for (int i = 0; i < hex_value.length(); ++i) {
                    v.append(hex_value.charAt(i)).append(hex_value.charAt(i));
                }
                hex_value = v.toString();
            }
            if (hex_value.length() == 6) {
                callback.index(lexer.getTokenStart(), CssIndexValue.COLOR, hex_value);
            }
        }
        if (tokenType == CssElementTypes.CSS_FUNCTION_TOKEN) {
            int functionOffset = lexer.getTokenStart();
            if ("rgb".equalsIgnoreCase(value.toString())) {
                lexer.advance();
                tokenType = lexer.getTokenType();
                if (CssElementTypes.CSS_LPAREN == tokenType) {
                    lexer.advance();
                    String rgb_hex = CssIndex.extractColorComponent(lexer, input);
                    if (rgb_hex != null) {
                        callback.index(functionOffset, CssIndexValue.COLOR_RGB, rgb_hex);
                    }
                }
            }
        }
    }

    @Nullable
    private static String extractColorComponent(Lexer lexer, CharSequence input) {
        IElementType tokenType = lexer.getTokenType();
        if (CssElementTypes.CSS_COMMA == tokenType) {
            lexer.advance();
            tokenType = lexer.getTokenType();
        }
        if (CssElementTypes.CSS_NUMBER == tokenType) {
            int color_value;
            CharSequence number = input.subSequence(lexer.getTokenStart(), lexer.getTokenEnd());
            try {
                color_value = Integer.valueOf(number.toString());
            }
            catch (NumberFormatException e) {
                return null;
            }
            lexer.advance();
            tokenType = lexer.getTokenType();
            if (CssElementTypes.CSS_PERCENT == tokenType) {
                color_value = (int)((float)color_value / 100.0f * 255.0f);
                lexer.advance();
                tokenType = lexer.getTokenType();
            }
            String hex_number = Integer.toHexString(color_value);
            StringBuilder result = new StringBuilder();
            if (hex_number.length() < 2) {
                result.append('0');
            }
            result.append(hex_number);
            if (CssElementTypes.CSS_COMMA != tokenType) {
                return result.toString();
            }
            String next_components = CssIndex.extractColorComponent(lexer, input);
            if (next_components != null) {
                return result.toString() + next_components;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/index/CssIndex";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/index/CssIndex";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "indexValues";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class CssIndexCallback {
        private CssIndexCallback() {
        }

        abstract void index(int var1, @Nullable CssIndexValue var2, @NotNull String var3);
    }

    private static class Holder {
        private static final CssSupportedFileTypesProvider[] supportedFileTypesProviders = (CssSupportedFileTypesProvider[])Extensions.getExtensions(CssSupportedFileTypesProvider.EP_NAME);
        private static final List<LanguageFileType> supportedFileTypes = new ArrayList<LanguageFileType>();

        private Holder() {
        }

        static {
            supportedFileTypes.add(CssFileType.INSTANCE);
            supportedFileTypes.add((LanguageFileType)XHtmlFileType.INSTANCE);
            supportedFileTypes.add((LanguageFileType)HtmlFileType.INSTANCE);
            for (CssSupportedFileTypesProvider cssSupportedFileTypesProvider : supportedFileTypesProviders) {
                supportedFileTypes.add(cssSupportedFileTypesProvider.getSupportedFileType());
            }
            for (CssSupportedFileTypesProvider cssSupportedFileTypesProvider : FileTypeRegistry.getInstance().getRegisteredFileTypes()) {
                if (!CssIndex.isSupportedTemplateLanguage((FileType)cssSupportedFileTypesProvider)) continue;
                supportedFileTypes.add((LanguageFileType)cssSupportedFileTypesProvider);
            }
        }
    }
}

