/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.nashorn;

import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.PositionManagerFactory;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.PositionManagerEx;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.javascript.debugger.JavaScriptDebuggerEvaluator;
import com.intellij.javascript.debugger.nashorn.NashornArray;
import com.intellij.javascript.debugger.nashorn.NashornCallFrame;
import com.intellij.javascript.debugger.nashorn.NashornCallFrameEvaluateContextKt;
import com.intellij.javascript.debugger.nashorn.NashornObject;
import com.intellij.javascript.debugger.nashorn.NashornPositionManagerFactory;
import com.intellij.javascript.debugger.nashorn.NashornSourceMapHandler;
import com.intellij.javascript.debugger.nashorn.NashornSourceMapHandlerKt;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueNode;
import com.jetbrains.debugger.jdi.JavaDebuggerViewSupport;
import com.jetbrains.debugger.jdi.JdiSuspendContext;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import gnu.trove.THashMap;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;
import org.jetbrains.io.LocalFileFinder;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00072\u00020\u0001:\u0002\u0007\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory;", "Lcom/intellij/debugger/PositionManagerFactory;", "()V", "createPositionManager", "Lcom/intellij/debugger/PositionManager;", "process", "Lcom/intellij/debugger/engine/DebugProcess;", "Companion", "NashornPositionManager", "nashorn-debugger"})
public final class NashornPositionManagerFactory
extends PositionManagerFactory {
    @NotNull
    private static final Logger LOG;
    private static final Companion.DEBUGGER_VIEW_SUPPORT.1 DEBUGGER_VIEW_SUPPORT;
    public static final Companion Companion;

    @Nullable
    public PositionManager createPositionManager(@NotNull DebugProcess process) {
        Intrinsics.checkParameterIsNotNull((Object)process, (String)"process");
        return (PositionManager)new NashornPositionManager(process);
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(NashornPositionManagerFactory.class);
        DEBUGGER_VIEW_SUPPORT = new JavaDebuggerViewSupport(){

            public void computeObjectPresentation(@NotNull ObjectValue value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
                if (value instanceof NashornObject) {
                    VariableView.Companion.setObjectPresentation(value, icon, node);
                } else {
                    super.computeObjectPresentation(value, variable, context, node, icon);
                }
            }

            public void computeArrayPresentation(@NotNull Value value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
                if (value instanceof NashornArray) {
                    VariableView.Companion.setArrayPresentation(value, context, icon, node);
                } else {
                    super.computeArrayPresentation(value, variable, context, node, icon);
                }
            }

            @NotNull
            public XDebuggerEvaluator createFrameEvaluator(@NotNull CallFrameView frameView) {
                Intrinsics.checkParameterIsNotNull((Object)frameView, (String)"frameView");
                return (XDebuggerEvaluator)new JavaScriptDebuggerEvaluator((VariableContext)frameView);
            }
        };
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u0000 +2\u00020\u0001:\u0001+B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\"\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0 2\u0006\u0010!\u001a\u00020\u0010H\u0017J\u0010\u0010\"\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0015H\u0002J\u0014\u0010#\u001a\u0004\u0018\u00010\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0017J\u0012\u0010$\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001a\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001e2\b\u0010(\u001a\u0004\u0018\u00010\u0007H\u0002J\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00170 2\u0006\u0010*\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$NashornPositionManager;", "Lcom/intellij/debugger/engine/PositionManagerEx;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcess;", "(Lcom/intellij/debugger/engine/DebugProcess;)V", "mapping", "Lgnu/trove/THashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/sun/jdi/ReferenceType;", "suspendContext", "Lcom/jetbrains/debugger/jdi/JdiSuspendContext;", "createPrepareRequest", "Lcom/sun/jdi/request/ClassPrepareRequest;", "requestor", "Lcom/intellij/debugger/requests/ClassPrepareRequestor;", "position", "Lcom/intellij/debugger/SourcePosition;", "createStackFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "jdiFrame", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "location", "Lcom/sun/jdi/Location;", "evaluateCondition", "Lcom/intellij/util/ThreeState;", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContext;", "frame", "expression", "", "getAllClasses", "", "classPosition", "getOrCreateSuspendManager", "getSourcePosition", "getVirtualFile", "isInOutput", "", "vmPath", "sourceRootForFile", "locationsOfLine", "type", "Companion", "nashorn-debugger"})
    private static final class NashornPositionManager
    extends PositionManagerEx {
        private final THashMap<VirtualFile, ReferenceType> mapping;
        private JdiSuspendContext suspendContext;
        private final DebugProcess debugProcess;
        private static final String NASHORN_SCRIPT_FQN = "jdk.nashorn.internal.scripts.Script";
        private static final String NASHORN_SCRIPT_PREFIX = "jdk.nashorn.internal.scripts.Script$";
        private static final String NASHORN_SCRIPT_NAME_PATTERN = "jdk.nashorn.internal.scripts.Script$*";
        public static final Companion Companion = new Companion(null);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final VirtualFile getVirtualFile(Location location) {
            String vmPath;
            try {
                ReferenceType referenceType = location.declaringType();
                Intrinsics.checkExpressionValueIsNotNull((Object)referenceType, (String)"location.declaringType()");
                vmPath = NashornPositionManager.Companion.getNormalizedVmPath(referenceType);
            }
            catch (AbsentInformationException ignored) {
                return null;
            }
            if (vmPath == null) {
                return null;
            }
            VirtualFile file = null;
            GlobalSearchScope searchScope = this.debugProcess.getSearchScope();
            if (searchScope instanceof ModuleWithDependenciesScope) {
                Module module;
                Module module2 = module = ((ModuleWithDependenciesScope)searchScope).getModule();
                Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"module");
                file = NashornPositionManager.Companion.getSourceFileByOutput(vmPath, module2, null);
                if (file == null) {
                    AccessToken token = ReadAction.start();
                    try {
                        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                        VirtualFile[] virtualFileArray = moduleRootManager.getSourceRoots();
                        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"moduleRootManager.sourceRoots");
                        file = NashornPositionManager.Companion.findFileByRelativePath(vmPath, virtualFileArray);
                        if (file == null) {
                            VirtualFile[] virtualFileArray2 = moduleRootManager.getContentRoots();
                            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray2, (String)"moduleRootManager.contentRoots");
                            file = NashornPositionManager.Companion.findFileByRelativePath(vmPath, virtualFileArray2);
                        }
                    }
                    finally {
                        token.finish();
                    }
                }
            }
            if (file == null) {
                file = this.debugProcess.getProject().getBaseDir().findFileByRelativePath(vmPath);
            }
            if (file == null) {
                String workingDirectory;
                RunProfile runProfile;
                DebugProcessImpl debugProcessImpl;
                DebugProcess debugProcess = this.debugProcess;
                if (!(debugProcess instanceof DebugProcessImpl)) {
                    debugProcess = null;
                }
                if (!(((debugProcessImpl = (DebugProcessImpl)debugProcess) != null && (debugProcessImpl = debugProcessImpl.getXdebugProcess()) != null && (debugProcessImpl = debugProcessImpl.getSession()) != null ? debugProcessImpl.getRunProfile() : (runProfile = null)) instanceof CommonProgramRunConfigurationParameters)) {
                    runProfile = null;
                }
                CommonProgramRunConfigurationParameters commonProgramRunConfigurationParameters = (CommonProgramRunConfigurationParameters)runProfile;
                String string = workingDirectory = commonProgramRunConfigurationParameters != null ? commonProgramRunConfigurationParameters.getWorkingDirectory() : null;
                if (workingDirectory != null) {
                    File javaFile = new File(workingDirectory, vmPath);
                    file = VfsUtil.findFileByIoFile((File)javaFile, (boolean)true);
                }
            }
            if (file == null) {
                return LocalFileFinder.findFile((String)vmPath);
            }
            return file;
        }

        @Nullable
        public XStackFrame createStackFrame(@NotNull StackFrameProxyImpl jdiFrame, @NotNull DebugProcessImpl debugProcess, @NotNull Location location) {
            Intrinsics.checkParameterIsNotNull((Object)jdiFrame, (String)"jdiFrame");
            Intrinsics.checkParameterIsNotNull((Object)debugProcess, (String)"debugProcess");
            Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
            if (!NashornPositionManager.Companion.isNashornScriptLocation(location)) {
                return null;
            }
            VirtualFile file = this.getVirtualFile(location);
            Object object = (Lazy)debugProcess.getUserData(NashornSourceMapHandlerKt.getNASHORN_SOURCE_MAP_HANDLER_KEY());
            if (object == null || (object = (NashornSourceMapHandler)object.getValue()) == null || (object = ((NashornSourceMapHandler)object).getSourceInfo(file, location)) == null) {
                object = file == null ? null : new SourceInfo(file, location.lineNumber() - 1, 0, 0, null, null, 60, null);
            }
            if (object == null) {
                return null;
            }
            Object sourceInfo = object;
            NashornCallFrame frame = new NashornCallFrame(this.getOrCreateSuspendManager(debugProcess).getValueManager(), jdiFrame, sourceInfo.getLine(), sourceInfo.getColumn());
            return (XStackFrame)new CallFrameView((CallFrame)frame, (DebuggerViewSupport)Companion.getDEBUGGER_VIEW_SUPPORT(), null, (SourceInfo)sourceInfo, null, null, 48, null);
        }

        private final JdiSuspendContext getOrCreateSuspendManager(DebugProcessImpl debugProcess) {
            JdiSuspendContext _suspendContext = this.suspendContext;
            if (_suspendContext == null) {
                this.suspendContext = _suspendContext = new JdiSuspendContext(debugProcess, true);
            }
            return _suspendContext;
        }

        @NotNull
        public ThreeState evaluateCondition(@NotNull EvaluationContext context, @NotNull StackFrameProxyImpl frame, @NotNull Location location, @NotNull String expression) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
            Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
            Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
            if (!NashornPositionManager.Companion.isNashornScriptLocation(location)) {
                return ThreeState.UNSURE;
            }
            DebuggerManagerThreadImpl.assertIsManagerThread();
            try {
                com.sun.jdi.Value jdiValue = frame.visibleValueByName(expression);
                if (jdiValue != null) {
                    if (jdiValue instanceof BooleanValue) {
                        return ((BooleanValue)jdiValue).booleanValue() ? ThreeState.YES : ThreeState.NO;
                    }
                    return ThreeState.UNSURE;
                }
                DebugProcess debugProcess = context.getDebugProcess();
                if (debugProcess == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.debugger.engine.DebugProcessImpl");
                }
                Value value = NashornCallFrameEvaluateContextKt.doEvaluate(expression, frame, this.getOrCreateSuspendManager((DebugProcessImpl)debugProcess).getValueManager(), context);
                if (value.getType() == ValueType.BOOLEAN) {
                    return Intrinsics.areEqual((Object)"true", (Object)value.getValueString()) ? ThreeState.YES : ThreeState.NO;
                }
                return ThreeState.UNSURE;
            }
            catch (Exception e) {
                Companion.getLOG$nashorn_debugger().warn((Throwable)e);
                return ThreeState.UNSURE;
            }
        }

        @Nullable
        public SourcePosition getSourcePosition(@Nullable Location location) throws NoDataException {
            PsiFile psiFile;
            if (location == null || !NashornPositionManager.Companion.isNashornScriptLocation(location)) {
                NoDataException noDataException = NoDataException.INSTANCE;
                Intrinsics.checkExpressionValueIsNotNull((Object)noDataException, (String)"NoDataException.INSTANCE");
                throw (Throwable)noDataException;
            }
            VirtualFile virtualFile = this.getVirtualFile(location);
            if (virtualFile != null && (psiFile = PsiManager.getInstance((Project)this.debugProcess.getProject()).findFile(virtualFile)) != null) {
                return SourcePosition.createFromLine((PsiFile)psiFile, (int)(location.lineNumber() - 1));
            }
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)noDataException, (String)"NoDataException.INSTANCE");
            throw (Throwable)noDataException;
        }

        @NotNull
        public List<ReferenceType> getAllClasses(@NotNull SourcePosition classPosition) throws NoDataException {
            Intrinsics.checkParameterIsNotNull((Object)classPosition, (String)"classPosition");
            NashornPositionManager.Companion.checkJsFile(classPosition);
            ReferenceType referenceType = (ReferenceType)this.mapping.get((Object)classPosition.getFile().getVirtualFile());
            if (referenceType == null) {
                NoDataException noDataException = NoDataException.INSTANCE;
                Intrinsics.checkExpressionValueIsNotNull((Object)noDataException, (String)"NoDataException.INSTANCE");
                throw (Throwable)noDataException;
            }
            ReferenceType type = referenceType;
            return CollectionsKt.listOf((Object)type);
        }

        @NotNull
        public List<Location> locationsOfLine(@NotNull ReferenceType type, @NotNull SourcePosition position) throws NoDataException {
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
            NashornPositionManager.Companion.checkJsFile(position);
            try {
                List<Location> list = type.locationsOfLine("Java", null, position.getLine() + 1);
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"type.locationsOfLine(Deb\u2026 null, position.line + 1)");
                return list;
            }
            catch (AbsentInformationException absentInformationException) {
                return CollectionsKt.emptyList();
            }
        }

        private final boolean isInOutput(String vmPath, VirtualFile sourceRootForFile) {
            GlobalSearchScope globalSearchScope = this.debugProcess.getSearchScope();
            if (!(globalSearchScope instanceof ModuleWithDependenciesScope)) {
                globalSearchScope = null;
            }
            ModuleWithDependenciesScope moduleWithDependenciesScope = (ModuleWithDependenciesScope)globalSearchScope;
            if (moduleWithDependenciesScope == null) {
                return false;
            }
            ModuleWithDependenciesScope searchScope = moduleWithDependenciesScope;
            Module module = searchScope.getModule();
            Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"searchScope.module");
            return NashornPositionManager.Companion.getSourceFileByOutput(vmPath, module, sourceRootForFile) != null;
        }

        @Nullable
        public ClassPrepareRequest createPrepareRequest(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) throws NoDataException {
            Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
            Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
            NashornPositionManager.Companion.checkJsFile(position);
            return this.debugProcess.getRequestsManager().createClassPrepareRequest(new ClassPrepareRequestor(this, position, requestor){
                final /* synthetic */ NashornPositionManager this$0;
                final /* synthetic */ SourcePosition $position;
                final /* synthetic */ ClassPrepareRequestor $requestor;

                public final void processClassPrepare(DebugProcess debuggerProcess, ReferenceType referenceType) {
                    String vmPath;
                    try {
                        ReferenceType referenceType2 = referenceType;
                        Intrinsics.checkExpressionValueIsNotNull((Object)referenceType2, (String)"referenceType");
                        vmPath = Companion.access$getNormalizedVmPath(NashornPositionManager.Companion, referenceType2);
                    }
                    catch (AbsentInformationException ignored) {
                        return;
                    }
                    if (vmPath != null && Intrinsics.areEqual((Object)vmPath, (Object)"<eval>") ^ true && !StringsKt.startsWith$default((String)vmPath, (String)"nashorn:", (boolean)false, (int)2, null)) {
                        VirtualFile positionFile = this.$position.getFile().getVirtualFile();
                        VirtualFile sourceRootForFile = ProjectFileIndex.SERVICE.getInstance((Project)debuggerProcess.getProject()).getSourceRootForFile(positionFile);
                        if (!NashornPositionManager.access$isInOutput(this.this$0, vmPath, sourceRootForFile)) {
                            String path = positionFile.getPath();
                            if (!(SystemInfo.isFileSystemCaseSensitive ? StringsKt.endsWith$default((String)path, (String)vmPath, (boolean)false, (int)2, null) : StringUtilRt.endsWithIgnoreCase((CharSequence)path, (CharSequence)vmPath))) {
                                return;
                            }
                        }
                        NashornPositionManager.access$getMapping$p(this.this$0).put((Object)positionFile, (Object)referenceType);
                        this.$requestor.processClassPrepare(debuggerProcess, referenceType);
                    }
                }
                {
                    this.this$0 = nashornPositionManager;
                    this.$position = sourcePosition;
                    this.$requestor = classPrepareRequestor;
                }
            }, NashornPositionManager.Companion.getNASHORN_SCRIPT_NAME_PATTERN());
        }

        public NashornPositionManager(@NotNull DebugProcess debugProcess) {
            Intrinsics.checkParameterIsNotNull((Object)debugProcess, (String)"debugProcess");
            this.debugProcess = debugProcess;
            this.mapping = new THashMap();
            this.debugProcess.addDebugProcessListener(new DebugProcessListener(){

                public void processDetached(@NotNull DebugProcess process, boolean closedByUser) {
                    Intrinsics.checkParameterIsNotNull((Object)process, (String)"process");
                    suspendContext = null;
                }

                public void resumed(@NotNull SuspendContext javaSuspendContext) {
                    Intrinsics.checkParameterIsNotNull((Object)javaSuspendContext, (String)"javaSuspendContext");
                    suspendContext = null;
                }
            });
        }

        static {
            NASHORN_SCRIPT_FQN = NASHORN_SCRIPT_FQN;
            NASHORN_SCRIPT_PREFIX = NashornPositionManager.Companion.getNASHORN_SCRIPT_FQN() + "$";
            NASHORN_SCRIPT_NAME_PATTERN = NashornPositionManager.Companion.getNASHORN_SCRIPT_PREFIX() + "*";
        }

        public static final /* synthetic */ boolean access$isInOutput(NashornPositionManager $this, @NotNull String vmPath, @Nullable VirtualFile sourceRootForFile) {
            return $this.isInOutput(vmPath, sourceRootForFile);
        }

        @NotNull
        public static final /* synthetic */ THashMap access$getMapping$p(NashornPositionManager $this) {
            return $this.mapping;
        }

        @Nullable
        public static final /* synthetic */ JdiSuspendContext access$getSuspendContext$p(NashornPositionManager $this) {
            return $this.suspendContext;
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0003J%\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00042\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0003J$\u0010\u0018\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0010H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006!"}, d2={"Lcom/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$NashornPositionManager$Companion;", "", "()V", "NASHORN_SCRIPT_FQN", "", "getNASHORN_SCRIPT_FQN", "()Ljava/lang/String;", "NASHORN_SCRIPT_NAME_PATTERN", "getNASHORN_SCRIPT_NAME_PATTERN", "NASHORN_SCRIPT_PREFIX", "getNASHORN_SCRIPT_PREFIX", "checkJsFile", "", "position", "Lcom/intellij/debugger/SourcePosition;", "findFileByRelativePath", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "roots", "", "(Ljava/lang/String;[Lcom/intellij/openapi/vfs/VirtualFile;)Lcom/intellij/openapi/vfs/VirtualFile;", "getNormalizedVmPath", "referenceType", "Lcom/sun/jdi/ReferenceType;", "getSourceFileByOutput", "vmPath", "module", "Lcom/intellij/openapi/module/Module;", "sourceRootForFile", "isNashornScriptLocation", "", "location", "Lcom/sun/jdi/Location;", "nashorn-debugger"})
        public static final class Companion {
            private final String getNASHORN_SCRIPT_FQN() {
                return NASHORN_SCRIPT_FQN;
            }

            private final String getNASHORN_SCRIPT_PREFIX() {
                return NASHORN_SCRIPT_PREFIX;
            }

            private final String getNASHORN_SCRIPT_NAME_PATTERN() {
                return NASHORN_SCRIPT_NAME_PATTERN;
            }

            private final void checkJsFile(SourcePosition position) throws NoDataException {
                if (!NashornPositionManagerFactory.Companion.isNashornApplicable(position)) {
                    NoDataException noDataException = NoDataException.INSTANCE;
                    Intrinsics.checkExpressionValueIsNotNull((Object)noDataException, (String)"NoDataException.INSTANCE");
                    throw (Throwable)noDataException;
                }
            }

            private final VirtualFile findFileByRelativePath(String path, VirtualFile[] roots) {
                for (int i = 0; i < roots.length; ++i) {
                    VirtualFile root = roots[i];
                    VirtualFile file = root.findFileByRelativePath(path);
                    if (file == null) continue;
                    return file;
                }
                return null;
            }

            private final String getNormalizedVmPath(ReferenceType referenceType) throws AbsentInformationException {
                String name = StringUtil.nullize((String)referenceType.sourceName());
                return name == null ? null : FileUtil.toCanonicalPath((String)FileUtil.toSystemIndependentName((String)name), (char)'/');
            }

            private final boolean isNashornScriptLocation(Location location) {
                return StringsKt.startsWith$default((String)location.declaringType().name(), (String)this.getNASHORN_SCRIPT_PREFIX(), (boolean)false, (int)2, null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final VirtualFile getSourceFileByOutput(String vmPath, Module module, VirtualFile sourceRootForFile) {
                CompilerModuleExtension compilerModuleExtension = CompilerModuleExtension.getInstance((Module)module);
                if (compilerModuleExtension == null) {
                    return null;
                }
                CompilerModuleExtension compilerModuleExtension2 = compilerModuleExtension;
                AccessToken token = ReadAction.start();
                try {
                    VirtualFile[] sourceRoots = null;
                    VirtualFile[] virtualFileArray = compilerModuleExtension2.getOutputRoots(true);
                    for (int i = 0; i < virtualFileArray.length; ++i) {
                        VirtualFile outputRoot = virtualFileArray[i];
                        String outputRootPath = outputRoot.getPath();
                        String relativePath = FileUtilRt.getRelativePath((String)outputRootPath, (String)vmPath, (char)'/');
                        if (relativePath == null) continue;
                        if (sourceRootForFile != null) {
                            VirtualFile file = sourceRootForFile.findFileByRelativePath(relativePath);
                            if (file == null) continue;
                            VirtualFile virtualFile = file;
                            return virtualFile;
                        }
                        if (sourceRoots == null) {
                            sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots();
                        }
                        for (int j = 0; j < sourceRoots.length; ++j) {
                            VirtualFile sourceRoot = sourceRoots[j];
                            VirtualFile file = sourceRoot.findFileByRelativePath(relativePath);
                            if (file == null) continue;
                            VirtualFile virtualFile = file;
                            return virtualFile;
                        }
                    }
                }
                finally {
                    token.finish();
                }
                return null;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0016\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$Companion;", "", "()V", "DEBUGGER_VIEW_SUPPORT", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$Companion$DEBUGGER_VIEW_SUPPORT$1", "getDEBUGGER_VIEW_SUPPORT", "()Lcom/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$Companion$DEBUGGER_VIEW_SUPPORT$1;", "Lcom/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$Companion$DEBUGGER_VIEW_SUPPORT$1;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG$nashorn_debugger", "()Lcom/intellij/openapi/diagnostic/Logger;", "isNashornApplicable", "", "position", "Lcom/intellij/debugger/SourcePosition;", "nashorn-debugger"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG$nashorn_debugger() {
            return LOG;
        }

        private final DEBUGGER_VIEW_SUPPORT.1 getDEBUGGER_VIEW_SUPPORT() {
            return DEBUGGER_VIEW_SUPPORT;
        }

        public final boolean isNashornApplicable(@NotNull SourcePosition position) {
            Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
            return position.getFile() instanceof JSFile;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

