/*
 * Copyright 2000-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.persistence.model.manipulators;

import com.intellij.credentialStore.Credentials;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.psi.PsiClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * @author Gregory.Shrago
 */
public interface PersistenceUnitManipulator<T extends PersistencePackage> extends PersistenceManipulator<T> {
  void ensureMappingIncluded(PersistenceMappings mappings);
  void ensureClassIncluded(PsiClass psiClass);
  void setConnectionProperties(@NotNull Project project, @NotNull RawConnectionConfig info, @Nullable Credentials credentials);
}