/*
 * Copyright 2000-2017 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.contexts.model;

import com.intellij.psi.PsiClass;
import com.intellij.spring.model.SpringBeanPointer;
import org.jetbrains.annotations.NotNull;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public abstract class LocalAnnotationModel extends AbstractSimpleLocalModel<PsiClass> {

  /**
   * @deprecated To remove in 2018.1
   */
  @Deprecated
  public abstract void setActiveProfiles(@NotNull Set<String> activeProfiles);

  /**
   * Skip processing nested configuration classes.
   *
   * @since 2017.2
   * @deprecated To remove in 2018.1
   */
  @Deprecated
  public void disableEvaluatingInnerConfigurationClasses() {}

  @NotNull
  @Override
  public Collection<SpringBeanPointer> calculateDomBeans() {
    return Collections.emptySet();
  }
}