/*
 * Copyright 2000-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.spring.model;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.spring.model.xml.beans.ConstructorArgDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @author Dmitry Avdeev
 */
public interface ResolvedConstructorArgs {

  boolean isResolved();

  @Nullable
  PsiMethod getResolvedMethod();

  @NotNull
  List<PsiMethod> getCheckedMethods();

  /**
   * @return null if {@link #getResolvedMethod()} returns null.
   */
  @Nullable
  Map<ConstructorArgDefinition, PsiParameter> getResolvedArgs();

  @Nullable
  Map<ConstructorArgDefinition, PsiParameter> getResolvedArgs(@NotNull PsiMethod method);

  @Nullable
  Map<PsiParameter, Collection<SpringBeanPointer>> getAutowiredParams(@NotNull PsiMethod method);

  List<PsiMethod> getCandidates();
}
