/*
 * Copyright 2000-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.custom;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import org.jetbrains.annotations.NotNull;

import java.util.Collection;
import java.util.Collections;

/**
 * @since 16
 */
public abstract class ComponentScanExtender {
  public static final ExtensionPointName<ComponentScanExtender> EP_NAME =
    ExtensionPointName.create("com.intellij.spring.componentScanExtender");

  @NotNull
  public  Collection<? extends SpringStereotypeElement> getComponents(@NotNull GlobalSearchScope scope, @NotNull Module module) {return Collections.emptySet();}

  @NotNull
  @Deprecated
  public Collection<? extends SpringStereotypeElement> getComponents(@NotNull GlobalSearchScope scope, @NotNull Project project){return Collections.emptySet();}
}
