/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.highlighting.dom;

import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.model.SpringModelVisitor;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * @author Dmitry Avdeev
 */
public abstract class SpringBeanInspectionBase extends DomElementsInspection<Beans> {

  public SpringBeanInspectionBase() {
    super(Beans.class);
  }

  public void checkFileElement(final DomFileElement<Beans> domFileElement, final DomElementAnnotationHolder holder) {
    final XmlFile xmlFile = domFileElement.getFile();
    final Beans beans = domFileElement.getRootElement();
    final CommonSpringModel model = SpringManager.getInstance(xmlFile.getProject()).getSpringModelByFile(xmlFile);
    final SpringModelVisitor visitor = createVisitor(holder, beans, model);
    SpringModelVisitor.visitBeans(visitor, beans);
  }

  protected SpringModelVisitor createVisitor(final DomElementAnnotationHolder holder, @NotNull  final Beans beans, @Nullable final CommonSpringModel model) {
    return new SpringModelVisitor() {

      protected boolean visitBean(CommonSpringBean bean) {
        if (bean instanceof SpringBean) {
          checkBean((SpringBean)bean, beans, holder, model);
        }
        return true;
      }
    };
  }

  protected void checkBean(@NotNull SpringBean springBean,
                           @NotNull final Beans beans,
                           @NotNull final DomElementAnnotationHolder holder,
                           @Nullable final CommonSpringModel springModel) {
  }
}
