/*
 * Copyright 2000-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.jam.testContexts.converters;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.model.converters.SpringImportResourceConverter;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collections;
import java.util.List;

/**
 * @since 16
 */
public class ApplicationContextReferenceConverter extends ResourcePathReferenceConverter<XmlFile> {

  @Override
  protected Function<ResolveResult, XmlFile> getMapper() {
    return SpringImportResourceConverter.XML_FILE_MAPPER;
  }

  @NotNull
  public static List<XmlFile> getApplicationContexts(@Nullable String path, @NotNull PsiElement context, Module... modules) {
    return path == null ? Collections.emptyList() :
           SpringImportResourceConverter.getFiles(getReferencesOnFakeElement(context, path, modules));
  }
}
