/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.xml.context;

import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiPackage;
import com.intellij.spring.model.SpringInfrastructureBean;
import com.intellij.spring.model.jam.utils.filters.SpringContextFilter;
import com.intellij.spring.model.CommonSpringBean;
import org.jetbrains.annotations.NotNull;

import java.util.Set;

public interface SpringBeansPackagesScan extends CommonModelElement, SpringInfrastructureBean {

  @NotNull
  Set<CommonSpringBean> getScannedElements(@NotNull final Module module);

  @NotNull
  Set<PsiPackage> getPsiPackages();

  boolean useDefaultFilters();

  @NotNull
  Set<SpringContextFilter.Exclude> getExcludeContextFilters();

  @NotNull
  Set<SpringContextFilter.Include> getIncludeContextFilters();
}
