/*
 * Copyright 2000-2017 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.xml.context;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiPackage;
import com.intellij.spring.model.converters.PackageListConverter;
import com.intellij.spring.model.xml.BeanName;
import com.intellij.spring.model.xml.BeanNameProvider;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.Stubbed;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.List;

@BeanName(provider = SpringBeansPackagesScanBean.SpringBeansPackagesScanBeanNameProvider.class, displayOnly = true)
public interface SpringBeansPackagesScanBean extends DomSpringBean, SpringBeansPackagesScan {

  /**
   * Returns name of provider do distinguish component-scans from different namespaces (Context, Data, ..).
   *
   * @return Name.
   * @since 14
   */
  String getProviderName();

  class SpringBeansPackagesScanBeanNameProvider implements BeanNameProvider<SpringBeansPackagesScanBean> {

    @Nullable
    @Override
    public String getBeanName(SpringBeansPackagesScanBean bean) {
      return "(" + StringUtil.notNullize(bean.getBasePackage().getRawText()) + ") [" + bean.getProviderName() + "]";
    }
  }

  @NotNull
  @Required
  @Convert(PackageListConverter.class)
  @Stubbed
  GenericAttributeValue<Collection<PsiPackage>> getBasePackage();

  @NotNull
  List<Filter> getIncludeFilters();

  @NotNull
  List<Filter> getExcludeFilters();
}
