package com.intellij.psi.css.descriptor;

/**
 * User: zolotov
 * Date: 3/18/13
 * <p/>
 * Represents descriptor of css pseudo selectors (
 */
public interface CssPseudoSelectorDescriptor extends CssElementDescriptor {
  boolean hasArguments();

  /**
   * Return the length of colon prefix before element.
   * E.g. pseudo-element :after in CSS2 should be separated with single colon,
   * but pseudo-element ::first-child - with double colon
   *
   * @return count of colons in prefix
   */
  int getColonPrefixLength();

  /**
   * @return true if pseudo-selector should be defined after any element in selector
   */
  boolean isElementRequired();
}
