/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated on Mon Jan 23 20:05:38 MSK 2006
// DTD/Schema  :    http://java.sun.com/xml/ns/javaee

package com.intellij.javaee.model.enums;

/**
 * http://java.sun.com/xml/ns/javaee:transport-guaranteeType enumeration.
 * <pre>
 * <h3>Enumeration http://java.sun.com/xml/ns/javaee:transport-guaranteeType documentation</h3>
 * The transport-guaranteeType specifies that the communication
 * 	between client and server should be NONE, INTEGRAL, or
 * 	CONFIDENTIAL. NONE means that the application does not
 * 	require any transport guarantees. A value of INTEGRAL means
 * 	that the application requires that the data sent between the
 * 	client and server be sent in such a way that it can't be
 * 	changed in transit. CONFIDENTIAL means that the application
 * 	requires that the data be transmitted in a fashion that
 * 	prevents other entities from observing the contents of the
 * 	transmission. In most cases, the presence of the INTEGRAL or
 * 	CONFIDENTIAL flag will indicate that the use of SSL is
 * 	required.
 * 	Used in: user-data-constraint
 * </pre>
 */
public enum TransportGuarantee {
	CONFIDENTIAL,
	INTEGRAL,
	NONE
}
