/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.javaee.ui;

import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.util.xml.ui.MockDomElementsEditor;
import com.intellij.util.xml.DomElement;

/**
 * @author nik
 */
public class MockJavaeeDomElementsEditor extends MockDomElementsEditor {
  private final JavaeeFacet myFacet;

  public MockJavaeeDomElementsEditor(final JavaeeFacet facet) {
    super(facet.getModule());
    myFacet = facet;
  }

  protected <T extends DomElement> T createMockElement(final Class<T> aClass) {
    final T t = super.createMockElement(aClass);
    JavaeeFacetUtil.getInstance().setFacetForMockElement(t, myFacet);
    return t;
  }
}
