/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.CustomResourceBundleState;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ResourceBundleManagerState {
    @Property(surroundWithTag=false)
    @XCollection(elementName="file", valueAttributeName="url")
    public Set<String> myDissociatedFiles = new HashSet();
    @Property(surroundWithTag=false)
    @XCollection(elementName="custom-rb")
    public List<CustomResourceBundleState> myCustomResourceBundles = new ArrayList<CustomResourceBundleState>();

    public Set<String> getDissociatedFiles() {
        return this.myDissociatedFiles;
    }

    public List<CustomResourceBundleState> getCustomResourceBundles() {
        return this.myCustomResourceBundles;
    }

    public boolean isEmpty() {
        return this.myCustomResourceBundles.isEmpty() && this.myDissociatedFiles.isEmpty();
    }

    public ResourceBundleManagerState removeNonExistentFiles() {
        ResourceBundleManagerState newState = new ResourceBundleManagerState();
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        for (String dissociatedFileUrl : this.myDissociatedFiles) {
            if (virtualFileManager.findFileByUrl(dissociatedFileUrl) == null) continue;
            newState.myDissociatedFiles.add(dissociatedFileUrl);
        }
        for (CustomResourceBundleState customResourceBundle : this.myCustomResourceBundles) {
            CustomResourceBundleState updatedCustomResourceBundle = customResourceBundle.removeNonExistentFiles(virtualFileManager);
            if (updatedCustomResourceBundle == null) continue;
            newState.myCustomResourceBundles.add(updatedCustomResourceBundle);
        }
        return newState;
    }
}

