/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.psi.impl;

import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiLanguageInjectionHost;
import org.jetbrains.annotations.NotNull;

class PropertyImplEscaper
extends LiteralTextEscaper<PropertyImpl> {
    private static final Logger LOG = Logger.getInstance(PropertyImplEscaper.class);
    private int[] outSourceOffsets;

    PropertyImplEscaper(@NotNull PropertyImpl value) {
        if (value == null) {
            PropertyImplEscaper.$$$reportNull$$$0(0);
        }
        super((PsiLanguageInjectionHost)value);
    }

    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
        if (rangeInsideHost == null) {
            PropertyImplEscaper.$$$reportNull$$$0(1);
        }
        if (outChars == null) {
            PropertyImplEscaper.$$$reportNull$$$0(2);
        }
        String subText = rangeInsideHost.substring(((PropertyImpl)this.myHost).getText());
        this.outSourceOffsets = new int[subText.length() + 1];
        int prefixLen = outChars.length();
        boolean b = PropertyImpl.parseCharacters(subText, outChars, this.outSourceOffsets);
        if (b) {
            int len = outChars.length();
            for (int i = prefixLen; i < len; ++i) {
                char inChar;
                char outChar = outChars.charAt(i);
                if (outChar == (inChar = subText.charAt(this.outSourceOffsets[i - prefixLen])) || inChar == '\\') continue;
                LOG.error("input: " + subText + ";\noutput: " + outChars + "\nat: " + i + "; prefix-length: " + prefixLen);
            }
        }
        return b;
    }

    public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
        int result;
        if (rangeInsideHost == null) {
            PropertyImplEscaper.$$$reportNull$$$0(3);
        }
        int n = result = offsetInDecoded < this.outSourceOffsets.length ? this.outSourceOffsets[offsetInDecoded] : -1;
        if (result == -1) {
            return -1;
        }
        return (result <= rangeInsideHost.getLength() ? result : rangeInsideHost.getLength()) + rangeInsideHost.getStartOffset();
    }

    public boolean isOneLine() {
        return !((PropertyImpl)this.myHost).getText().contains("\\");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInsideHost";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outChars";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/properties/psi/impl/PropertyImplEscaper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "decode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getOffsetInHost";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

