/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex;

import com.intellij.javascript.flex.refactoring.RenameMoveUtils;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.file.UpdateAddedFileProcessor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class FlexUpdateAddedFileHandler
extends UpdateAddedFileProcessor {
    public boolean canProcessElement(@NotNull PsiFile element) {
        if (element == null) {
            FlexUpdateAddedFileHandler.$$$reportNull$$$0(0);
        }
        return element instanceof JSFile || JavaScriptSupportLoader.isFlexMxmFile((PsiFile)element);
    }

    public void update(PsiFile element, PsiFile originalElement) throws IncorrectOperationException {
        if (element instanceof JSFile) {
            JSFile file = (JSFile)element;
            RenameMoveUtils.updateFileWithChangedName(file);
            RenameMoveUtils.prepareMovedFile(file);
            RenameMoveUtils.updateMovedFile(file);
        } else if (element instanceof XmlFile) {
            XmlFile file = (XmlFile)element;
            RenameMoveUtils.prepareMovedMxmlFile(file, (XmlFile)originalElement);
            RenameMoveUtils.updateMovedMxmlFile(file);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/flex/FlexUpdateAddedFileHandler", "canProcessElement"));
    }
}

